/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteObjRefResultTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public final class SubstituteObjRefResultTransformation
extends AEveryMethodTransformation {
    private final TracerGroup fTracerGroup;
    private final IMethodName fSourceMethod;
    private final FullyQualifiedMethodName fSubstitutionMethod;
    private final IMethodMatcher fMethodMatcher;

    public SubstituteObjRefResultTransformation(ICompilerLog log, IMethodName sourceMethod, FullyQualifiedMethodName substitutionMethod) {
        this(log, null, sourceMethod, substitutionMethod);
    }

    public SubstituteObjRefResultTransformation(ICompilerLog log, TracerGroup tracerGroup, IMethodName sourceMethod, FullyQualifiedMethodName substitutionMethod) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fSourceMethod = sourceMethod;
        this.fSubstitutionMethod = substitutionMethod;
        this.fMethodMatcher = new NamedMethodMatcher(this.getSourceMethod());
    }

    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public IMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    public FullyQualifiedMethodName getSubstitutionMethod() {
        return this.fSubstitutionMethod;
    }

    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && this.getTracerGroup().getClassMatcher().IClassMatcher_matches(targetClass);
    }

    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return this.fMethodMatcher.IMethodMatcher_matches(targetMethod) && targetMethod.hasBytecode();
    }

    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newSubstituteObjRefResultMethodMutation(settings, targetMethod, this);
    }

    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new SubstituteObjRefResultTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getSourceMethod(), this.getSubstitutionMethod());
    }
}

