/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.util.InvocationDataUtils;
import com.wily.util.properties.AttributeListing;
import java.util.Map;
import java.util.Set;

public class ExitPointTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    private static final String IS_AUTOMATIC_PARAM_KEY = "Is Automatic";
    private static final String IS_AUTOMATIC_PARAM_VALUE = String.valueOf(Boolean.TRUE);

    public ExitPointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return ExitPointTracer.isShutOff();
    }

    public static boolean isShutOff() {
        VirtualStack.TransactionCache cache = VirtualStack.getTransactionCache();
        return cache.getStartTransactionElement() == null || cache.getBackend() != null;
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        super.doOnStartTrace(tracerIndex, elementData, element);
        elementData.setParameterCallback(this);
    }

    @Override
    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        parameters.put(IS_AUTOMATIC_PARAM_KEY, IS_AUTOMATIC_PARAM_VALUE);
        Map hostPortsMap = InvocationDataUtils.getRemoteServerInfo(data);
        if (hostPortsMap != null) {
            int index = 1;
            for (Map.Entry entry : hostPortsMap.entrySet()) {
                String host = (String)entry.getKey();
                for (String port : (Set)entry.getValue()) {
                    parameters.put("Remote Server Name" + index, host);
                    parameters.put("Remote Port" + index, port);
                    ++index;
                }
            }
        }
    }

    @Override
    protected long getFilterEnablerBit() {
        return 0L;
    }
}

