/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelBackendTracer;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DatagramSendMethodBackendTracer
extends ChannelBackendTracer {
    public DatagramSendMethodBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected final String getComponentName(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel) {
            DatagramChannel channel = (DatagramChannel)invocationObject;
            InetSocketAddress remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(1);
            if (DatagramChannelMap.isRequired(channel, remoteAddress, this.getAgent())) {
                return this.formatParameterizedName(data);
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: invocation object not a DatagramChannel");
        }
        return null;
    }

    @Override
    protected final boolean isRequired(InvocationData data) {
        InetSocketAddress remoteAddress;
        DatagramChannel channel;
        if (data.getInvocationObject() instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(1) instanceof InetSocketAddress && DatagramChannelMap.isClientConnection(channel = (DatagramChannel)data.getInvocationObject(), remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(1))) {
            return DatagramChannelMap.isClientRequired(channel, remoteAddress, this.getAgent());
        }
        return false;
    }

    @Override
    protected String getAnnotationTitle(InvocationData data) {
        return "Datagram " + data.getProbeInformation().getProbeIdentification().getProbeMethodName();
    }

    @Override
    protected InetSocketAddress getResourceAddress(InvocationData data) {
        DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
        InetSocketAddress remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(1);
        return DatagramChannelMap.getAddress(channel, remoteAddress);
    }
}

