/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FixedSizeRollingQueue {
    private final Object[] fElements;
    private int fHead;
    private int fTail;
    private int fCount;
    private static final Object[] kZeroLengthObjectArray = new Object[0];

    public FixedSizeRollingQueue(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Queue must support at least one element!");
        }
        this.fHead = 0;
        this.fTail = 0;
        this.fCount = 0;
        this.fElements = new Object[size];
    }

    public synchronized Object enqueue(Object data) {
        return this.enqueueNonSync(data);
    }

    public Object enqueueNonSync(Object data) {
        Object result = null;
        if (this.fCount == this.fElements.length) {
            result = this.removeElement();
        }
        this.addElement(data);
        return result;
    }

    public synchronized Object dequeue() {
        Object result = null;
        if (this.fCount > 0) {
            result = this.removeElement();
        }
        return result;
    }

    public synchronized Object peek() {
        return this.fElements[this.fHead];
    }

    public Object[] getContents() {
        return this.getContents(kZeroLengthObjectArray);
    }

    public synchronized Object[] getContents(Object[] potentialResultArray) {
        Object[] resultArray = potentialResultArray;
        int count = this.fCount;
        if (resultArray.length < count) {
            resultArray = (Object[])Array.newInstance(resultArray.getClass().getComponentType(), count);
        }
        int cur = this.fHead;
        int i = 0;
        while (i < this.fCount) {
            resultArray[i] = this.fElements[cur];
            cur = this.increment(cur);
            ++i;
        }
        if (resultArray.length > count) {
            resultArray[count] = null;
        }
        return resultArray;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private int fCurrentCount = 0;
            private int fIndex;
            {
                this.fIndex = FixedSizeRollingQueue.this.fHead;
            }

            public boolean hasMoreElements() {
                return this.fCurrentCount < FixedSizeRollingQueue.this.fCount;
            }

            public Object nextElement() {
                if (this.fCurrentCount < FixedSizeRollingQueue.this.fCount) {
                    Object result = FixedSizeRollingQueue.this.fElements[this.fIndex];
                    this.fIndex = FixedSizeRollingQueue.this.increment(this.fIndex);
                    ++this.fCurrentCount;
                    return result;
                }
                throw new NoSuchElementException("No more elements in enumeration");
            }
        };
    }

    public boolean isEmpty() {
        return this.fCount == 0;
    }

    public int size() {
        return this.fCount;
    }

    public int capacity() {
        return this.fElements.length;
    }

    public synchronized void clear() {
        while (this.fCount > 0) {
            this.removeElement();
        }
    }

    public void debug_show(PrintStream ps) {
        ps.println("There are " + this.fCount + " (max " + this.fElements.length + ") total elements in the queue");
        int cur = this.fHead;
        int i = 0;
        while (i < this.fCount) {
            this.debug_showElement(ps, i, this.fElements[cur]);
            cur = this.increment(cur);
            ++i;
        }
    }

    public void debug_showElement(PrintStream ps, int index, Object obj) {
        ps.println(String.valueOf(index) + ".\t" + obj.toString());
    }

    private void addElement(Object element) {
        this.fElements[this.fTail] = element;
        this.fTail = this.increment(this.fTail);
        ++this.fCount;
    }

    private Object removeElement() {
        Object result = this.fElements[this.fHead];
        this.fElements[this.fHead] = null;
        this.fHead = this.increment(this.fHead);
        --this.fCount;
        return result;
    }

    private int increment(int index) {
        return (index + 1) % this.fElements.length;
    }
}

