/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.trace.common.MutableInteger;
import com.wily.introscope.agent.brtm.trace.common.PPSimpleTracer;
import com.wily.introscope.agent.brtm.utilities.KBRTMConstants;
import com.wily.introscope.agent.brtm.utilities.WrapperFactoryUtils;
import com.wily.introscope.agent.brtm.utilities.WrapperUtils;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.INonReentrant;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.util.ArrayUtilities;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BrtmTracer
extends PPSimpleTracer
implements INonReentrant {
    private static final Module BRTM_MODULE = new Module("BrowserAgent");
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;
    private String fBRTMJarManifestAttributeName = null;
    private String fBRTMJarManifestAttributeValue = null;
    private static volatile boolean autoInjectionOn;
    private static volatile boolean responseCookieOn;
    private static final String brtmLocallyOn = "introscope.agent.brtm.locally.enabled";
    private static volatile boolean sustainabilityMetricsOn;
    private static String[] g_ExcludePattern;
    private IBizDefSupportBean brtmBizDefAdmin = null;
    public static final String[] methodNames;
    public static final String[] overrideClassName;
    private static boolean g_initialized;
    private IRegisteredBehavior throttleBehavior;
    private IRegisteredBehavior maxSearchingBehavior;
    private IRegisteredBehavior unsupportedBrowsersBehavior;
    static int g_iResponseCounter;
    static int g_iThrottleResponseLimit;
    static boolean g_bThrottleWarn;
    static boolean g_bThrottleMetricWarn;
    static long g_maxResponseContentLengthForSearching;
    static volatile boolean maxSearchCountWarned;
    volatile IWeakIdentityMap invocationDataObjectToMethodMap;
    public static final String sustainabilityBaseMetricName = "Agent Stats|Sustainability|Browser Agent Business Transaction";
    private static volatile IWeakIdentityMap brtmClassLoaderHelpers;
    static volatile int g_iUnsupportedBrowsersCount;
    static int g_searchingMethodHierarchyMaxDepth;
    public static ThreadLocal stackDepthLocal;

    static {
        autoInjectionOn = false;
        responseCookieOn = false;
        sustainabilityMetricsOn = true;
        methodNames = KBRTMConstants.methodNames;
        overrideClassName = KBRTMConstants.overrideClassName;
        g_initialized = false;
        g_iResponseCounter = 0;
        g_iThrottleResponseLimit = 1000;
        g_bThrottleWarn = false;
        g_bThrottleMetricWarn = false;
        g_maxResponseContentLengthForSearching = 32768L;
        maxSearchCountWarned = false;
        brtmClassLoaderHelpers = BrtmTracer.getCache("BrtmClassLoaderHelpers");
        g_iUnsupportedBrowsersCount = 0;
        g_searchingMethodHierarchyMaxDepth = 3;
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }

    public BrtmTracer(IAgent arg0, AttributeListing arg1, ProbeIdentification arg2, Object arg3) throws AgentNotAvailableException {
        super(arg0, arg1, arg2, arg3);
        agent = arg0;
        feedback = new DelegatingFeedbackChannel(arg0.IAgent_getModuleFeedback(), BRTM_MODULE);
        if (!g_initialized) {
            g_initialized = true;
            this.fBRTMJarManifestAttributeName = BTThreadLocalAdministrator.getInstance().getJarManifestAttributeName();
            this.fBRTMJarManifestAttributeValue = BTThreadLocalAdministrator.getInstance().getJarManifestAttributeValue();
            g_searchingMethodHierarchyMaxDepth = BTThreadLocalAdministrator.getInstance().getSearchingMethodHierarchyMaxDepth();
            g_ExcludePattern = BTThreadLocalAdministrator.getInstance().getExcludeResponseContentPatterns();
            this.initializeProperties();
        }
        try {
            this.brtmBizDefAdmin = (IBizDefSupportBean)this.getAgent().IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.agent.bizdef.BizDefAdministratorFactory", "").getTraceSupportInstance();
        }
        catch (Throwable t) {
            feedback.warn(BRTM_MODULE, "Tracer failed initialization");
            feedback.verbose(BRTM_MODULE, "Tracer failed initialization", t);
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return !(agent.IAgent_getComponentTracer().isAgentOldMode() ? Boolean.FALSE != false : BTThreadLocalAdministrator.getInstance().isAutoInjectionEnabled() || BTThreadLocalAdministrator.getInstance().isResponseCookieEnabled() != false);
    }

    @Override
    public void ITracer_startTrace(int arg0, InvocationData invocationData) {
        BTThreadLocalAdministrator.getInstance();
        if (BTThreadLocalAdministrator.isReInitialize() && BTThreadLocalAdministrator.getInstance().get(brtmLocallyOn) == null) {
            this.initializeProperties();
        }
        if (!autoInjectionOn && !responseCookieOn) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        Boolean isEncodingSupport = BTThreadLocalAdministrator.getInstance().isEncodingSupport();
        int autoSkipClassDepth = BTThreadLocalAdministrator.getInstance().getAutoskipInstrumentClassDepth();
        if (isEncodingSupport.booleanValue() && BTThreadLocalAdministrator.getInstance().get("browseragent.tracer.reset") != null) {
            stackDepth.clear();
            BTThreadLocalAdministrator.getInstance().remove("browseragent.tracer.reset");
            BTThreadLocalAdministrator.getInstance().remove("browseragent.apprequest.processed");
        }
        stackDepth.inc();
        if (!isEncodingSupport.booleanValue() || !autoInjectionOn) {
            if (stackDepth.getValue() > 1) {
                return;
            }
        } else {
            if (stackDepth.getValue() > autoSkipClassDepth + 1) {
                return;
            }
            if (BTThreadLocalAdministrator.getInstance().get("browseragent.apprequest.processed") != null) {
                return;
            }
        }
        if (!this.init(invocationData).booleanValue()) {
            return;
        }
        Object req = invocationData.getInvocationParameterAsObject(0);
        invocationData.getInvocationParameterAsObject(1);
        WrapperFactoryUtils wrapperFactoryUtil = this.getWrapperFactoryUtils(req);
        Object factoryObject = wrapperFactoryUtil.getFactoryObject();
        if (req != null) {
            BTThreadLocalAdministrator.getInstance().insert(brtmLocallyOn, (Object)new Boolean(true));
            String url = null;
            String fullURL = null;
            if (BTThreadLocalAdministrator.getInstance().get("BRTM_REQ_URI") != null) {
                url = (String)BTThreadLocalAdministrator.getInstance().get("BRTM_REQ_URI");
            } else {
                Object requestPath = this.getURLWithQueryString(req, invocationData, factoryObject, wrapperFactoryUtil);
                if (requestPath == null) {
                    return;
                }
                if (!(requestPath instanceof String[]) || ((String[])requestPath).length != 2) {
                    return;
                }
                url = ((String[])requestPath)[0];
                fullURL = ((String[])requestPath)[1];
                BTThreadLocalAdministrator.getInstance().insert("shouldAddResponseCookie", (Object)this.shouldAddResponseCookie(fullURL));
                BTThreadLocalAdministrator.getInstance().insert("BRTM_REQ_URI", (Object)url);
                BTThreadLocalAdministrator.getInstance().insert("wrapperFactoryUtil", (Object)wrapperFactoryUtil);
                BTThreadLocalAdministrator.getInstance().insert("requestObject", req);
                if (BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-tt-starttime") == null) {
                    BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", (Object)invocationData.getWallClockTime());
                }
            }
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...1.1 startTrace... request class loader =" + invocationData.getInvocationParameterAsObject(0).getClass().getClassLoader() + ", url= " + url);
                feedback.trace(BRTM_MODULE, "...1.2 startTrace... response class loader =" + invocationData.getInvocationParameterAsObject(1).getClass().getClassLoader() + ", url= " + url);
                feedback.trace(BRTM_MODULE, "...1.3 startTrace... InvocationObject class loader =" + invocationData.getInvocationObject().getClass().getClassLoader() + ", url= " + url);
            }
            if (BTThreadLocalAdministrator.getInstance().get("brtm-response-wrapper-created") == null) {
                BTThreadLocalAdministrator.getInstance().insert("brtm-response-wrapper-created", (Object)Boolean.FALSE);
            }
            if (!autoInjectionOn) {
                return;
            }
            if (!this.checkThrottleLimit()) {
                return;
            }
            Object alreadyCheckExclude = BTThreadLocalAdministrator.getInstance().get("BrowserAgentExcludeURL");
            String snippetCode = null;
            if (BTThreadLocalAdministrator.getInstance().get("snippet") != null) {
                snippetCode = (String)BTThreadLocalAdministrator.getInstance().get("snippet");
            }
            if (alreadyCheckExclude == null) {
                if (BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-bt-p") != null && "Unsupported".equalsIgnoreCase((String)BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-bt-p"))) {
                    if (sustainabilityMetricsOn && g_iUnsupportedBrowsersCount < 2147483547) {
                        ++g_iUnsupportedBrowsersCount;
                    }
                    BTThreadLocalAdministrator.getInstance().insert("BrowserAgentExcludeURL", (Object)Boolean.TRUE);
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(BRTM_MODULE, "...2 shouldContinueBRTM... request is skipped in Browser Agent from unsupported browser, fullURL= " + fullURL);
                    }
                    BTThreadLocalAdministrator.getInstance().insert("browseragent.apprequest.processed", (Object)Boolean.TRUE);
                    return;
                }
                snippetCode = this.shouldContinueAutoInjection(fullURL);
                if (snippetCode == null) {
                    BTThreadLocalAdministrator.getInstance().insert("BrowserAgentExcludeURL", (Object)Boolean.TRUE);
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(BRTM_MODULE, "...2 shouldContinueBRTM... no snippet code, request is skipped in Browser Agent, fullURL= " + fullURL);
                    }
                    BTThreadLocalAdministrator.getInstance().insert("browseragent.apprequest.processed", (Object)Boolean.TRUE);
                    return;
                }
                BTThreadLocalAdministrator.getInstance().insert("BrowserAgentExcludeURL", (Object)Boolean.FALSE);
                BTThreadLocalAdministrator.getInstance().insert("snippet", (Object)snippetCode);
            } else if (alreadyCheckExclude instanceof Boolean && ((Boolean)alreadyCheckExclude).booleanValue()) {
                return;
            }
            if (this.skipInstrumentClass(invocationData, stackDepth, autoSkipClassDepth)) {
                return;
            }
            BTThreadLocalAdministrator.getInstance().insert("browseragent.apprequest.processed", (Object)Boolean.TRUE);
            this.processAppRequest(invocationData, url, stackDepth, factoryObject, wrapperFactoryUtil, snippetCode);
        }
    }

    private Boolean shouldAddResponseCookie(String fullURL) {
        if (!BTThreadLocalAdministrator.getInstance().isResponseCookieEnabled().booleanValue()) {
            return Boolean.FALSE;
        }
        Object browserType = BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-bt-p");
        if (browserType != null && browserType instanceof String && "Unsupported".equalsIgnoreCase((String)browserType)) {
            return Boolean.FALSE;
        }
        Pattern p = BTThreadLocalAdministrator.getInstance().getResponseCookieIncludeURLsRegexPattern();
        if (p != null && p.matcher(fullURL).matches()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private WrapperFactoryUtils getWrapperFactoryUtils(Object req) {
        return (WrapperFactoryUtils)brtmClassLoaderHelpers.getWeak(this.getObjectClassLoader(req));
    }

    private void processAppRequest(InvocationData invocationData, String url, MutableInteger stackDepth, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil, String snippetCode) {
        if (g_ExcludePattern != null) {
            BrtmTracer.invoke1ArgReturnsVoid(factoryObject, invocationData, 1, g_ExcludePattern, g_ExcludePattern.getClass(), wrapperFactoryUtil.getMethodCache());
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...2 processAppRequest... app request ... start callSameMethodWithWrapperResponse in brtmtracer, url= " + url);
        }
        ++g_iResponseCounter;
        if (!this.callSameMethodWithWrapperResponse(invocationData, url, factoryObject, wrapperFactoryUtil, snippetCode).booleanValue()) {
            return;
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...5 processAppRequest... app request ... finish callSameMethodWithWrapperResponse in brtmtracer, url= " + url);
        }
        BTThreadLocalAdministrator.getInstance().flush();
        if (stackDepth.getValue() > 0) {
            stackDepth.clear();
        }
    }

    private Boolean init(InvocationData invocationData) {
        if (!this.initClassLoader(invocationData).booleanValue()) {
            return Boolean.FALSE;
        }
        if (this.invocationDataObjectToMethodMap == null) {
            this.invocationDataObjectToMethodMap = agent.IAgent_getConcurrentMapFactory().getConcurrentCappedWeakIdentityMap("BrtmInvocationDataObjectToMethod");
        }
        return Boolean.TRUE;
    }

    private Boolean initClassLoader(InvocationData invocationData) {
        if (invocationData != null) {
            Object req = invocationData.getInvocationParameterAsObject(0);
            if (brtmClassLoaderHelpers == null) {
                brtmClassLoaderHelpers = BrtmTracer.getCache("BrtmClassLoaderHelpers");
            }
            if (req != null) {
                WrapperFactoryUtils result = this.getWrapperFactoryUtils(req);
                if (result != null) {
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(BRTM_MODULE, " initClassLoader :: Got ClassLoader/class from cache");
                    }
                    return Boolean.TRUE;
                }
                try {
                    Method method;
                    Class<?> wrapperFactory;
                    URLClassLoader classLoader = WrapperUtils.getJARClassLoader(this.getObjectClassLoader(req), agent, feedback, this.fBRTMJarManifestAttributeName, this.fBRTMJarManifestAttributeValue);
                    if (classLoader != null && (wrapperFactory = classLoader.loadClass("com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory")) != null && (method = wrapperFactory.getMethod("getInstance", IAgent.class)) != null) {
                        Object factoryObject = method.invoke(wrapperFactory, agent);
                        if (feedback.isDebugEnabled()) {
                            feedback.debug(BRTM_MODULE, " initClassLoader :: New ClassLoader loads class.  Browser Agent classloader = " + classLoader.toString());
                        }
                        if (factoryObject != null) {
                            brtmClassLoaderHelpers.putWeak(this.getObjectClassLoader(req), new WrapperFactoryUtils(classLoader, factoryObject));
                            return Boolean.TRUE;
                        }
                    }
                }
                catch (SecurityException e) {
                    feedback.error(BRTM_MODULE, "SecurityException: ", e);
                }
                catch (NoSuchMethodException e) {
                    feedback.error(BRTM_MODULE, "NoSuchMethodException: ", e);
                }
                catch (IllegalArgumentException e) {
                    feedback.error(BRTM_MODULE, "IllegalArgumentException: ", e);
                }
                catch (IllegalAccessException e) {
                    feedback.error(BRTM_MODULE, "IllegalAccessException: ", e);
                }
                catch (InvocationTargetException e) {
                    feedback.error(BRTM_MODULE, "InvocationTargetException: ", e);
                    invocationData.IParameterizedMethodTracer_setThrownException((Object)e.getTargetException());
                }
                catch (MalformedURLException e) {
                    feedback.error(BRTM_MODULE, "MalformedURLException: ", e);
                }
                catch (ClassNotFoundException e) {
                    feedback.error(BRTM_MODULE, "ClassNotFoundException: ", e);
                }
            }
        }
        return Boolean.FALSE;
    }

    private ClassLoader getObjectClassLoader(Object o) {
        return o.getClass().getClassLoader();
    }

    @Override
    public void ITracer_finishTrace(int arg0, InvocationData invocationData) {
        if (!autoInjectionOn && !responseCookieOn) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        if (stackDepth.getValue() > 0) {
            stackDepth.dec();
            if (stackDepth.getValue() > 1) {
                return;
            }
        }
        if (BTThreadLocalAdministrator.getInstance().get(brtmLocallyOn) != null) {
            if (stackDepth.getValue() == 0) {
                BTThreadLocalAdministrator.getInstance().flush();
                if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...finishTrace...flush() = " + stackDepth.getValue());
                }
            }
            return;
        }
    }

    private void initializeProperties() {
        block12: {
            autoInjectionOn = BTThreadLocalAdministrator.getInstance().isAutoInjectionEnabled();
            responseCookieOn = BTThreadLocalAdministrator.getInstance().isResponseCookieEnabled();
            sustainabilityMetricsOn = BTThreadLocalAdministrator.getInstance().isSustainabilityMetricEnabled();
            g_iThrottleResponseLimit = BTThreadLocalAdministrator.getInstance().getThrottleLimit();
            if (autoInjectionOn) {
                if (this.throttleBehavior == null) {
                    BrtmTracer.resetThrottleTimer();
                    this.throttleBehavior = this.getAgent().IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                        @Override
                        public void ITimestampedRunnable_execute(long nowInMillis) {
                            if (BTThreadLocalAdministrator.getInstance().isAutoInjectionEnabled() && BTThreadLocalAdministrator.getInstance().isSustainabilityMetricEnabled()) {
                                BrtmTracer.this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.responseCount").ILongAggregatingDataAccumulator_recordDataPoint((long)g_iResponseCounter);
                            }
                            BrtmTracer.resetThrottleTimer();
                        }
                    }, "BRTMThrottleLimit", true, 15000L, false);
                }
                if (this.maxSearchingBehavior == null) {
                    BTThreadLocalAdministrator.getInstance().resetMaxSearchCountAndUrl();
                    this.maxSearchingBehavior = this.getAgent().IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                        @Override
                        public void ITimestampedRunnable_execute(long nowInMillis) {
                            int maxSearchCount = BTThreadLocalAdministrator.getInstance().getMaxSearchCount();
                            if (BTThreadLocalAdministrator.getInstance().isAutoInjectionEnabled() && BTThreadLocalAdministrator.getInstance().isSustainabilityMetricEnabled()) {
                                BrtmTracer.this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingReached.count").ILongAggregatingDataAccumulator_recordDataPoint((long)maxSearchCount);
                            }
                            if (maxSearchCount > 0) {
                                if (feedback.isTraceEnabled()) {
                                    feedback.trace(BRTM_MODULE, new StringBuffer().append("Stop injection snippet code").append(BTThreadLocalAdministrator.getInstance().getMaxSearchUrls()).append(" because they exceeded max searching length ").append(BTThreadLocalAdministrator.getInstance().getMaxResponseContentLengthForSearching()).toString());
                                }
                                if (!maxSearchCountWarned) {
                                    feedback.warn(BRTM_MODULE, "Stop injection snippet code because one or more pages exceeded max searching length " + BTThreadLocalAdministrator.getInstance().getMaxResponseContentLengthForSearching());
                                    maxSearchCountWarned = true;
                                }
                                BTThreadLocalAdministrator.getInstance().resetMaxSearchCountAndUrl();
                            }
                        }
                    }, "BRTMMaxSearhCount", true, 15000L, false);
                }
                if (this.unsupportedBrowsersBehavior == null) {
                    g_iUnsupportedBrowsersCount = 0;
                    this.unsupportedBrowsersBehavior = this.getAgent().IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                        @Override
                        public void ITimestampedRunnable_execute(long nowInMillis) {
                            if (BTThreadLocalAdministrator.getInstance().isAutoInjectionEnabled() && BTThreadLocalAdministrator.getInstance().isSustainabilityMetricEnabled()) {
                                BrtmTracer.this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.unsupportedBrowsers.count").ILongAggregatingDataAccumulator_recordDataPoint((long)g_iUnsupportedBrowsersCount);
                            }
                            g_iUnsupportedBrowsersCount = 0;
                        }
                    }, "BRTMUnsupportedBrowsersCount", true, 15000L, false);
                }
            } else {
                try {
                    if (this.throttleBehavior != null) {
                        agent.IAgent_getCommonHeartbeat().removeBehavior(this.throttleBehavior);
                        agent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.responseCount");
                        this.throttleBehavior = null;
                    }
                    if (this.maxSearchingBehavior != null) {
                        agent.IAgent_getCommonHeartbeat().removeBehavior(this.maxSearchingBehavior);
                        agent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingReached.count");
                        this.maxSearchingBehavior = null;
                    }
                    if (this.unsupportedBrowsersBehavior != null) {
                        agent.IAgent_getCommonHeartbeat().removeBehavior(this.unsupportedBrowsersBehavior);
                        agent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.unsupportedBrowsers.count");
                        this.unsupportedBrowsersBehavior = null;
                    }
                }
                catch (BadlyFormedNameException e) {
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(BRTM_MODULE, "BadlyFormedNameException:" + e.getMessage());
                    }
                }
                catch (MetricNotFoundException e) {
                    if (!feedback.isTraceEnabled()) break block12;
                    feedback.trace(BRTM_MODULE, "MetricNotFoundException:" + e.getMessage());
                }
            }
        }
        BTThreadLocalAdministrator.getInstance();
        BTThreadLocalAdministrator.setReInitialize((boolean)false);
    }

    private boolean checkThrottleLimit() {
        if (g_iResponseCounter >= g_iThrottleResponseLimit) {
            if (!g_bThrottleWarn) {
                g_bThrottleWarn = true;
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "Exceeded the throttle limit. Not inserting JavaScript for the remainder of the interval and any future intervals that exceed the limit.");
                }
            }
            return false;
        }
        return true;
    }

    public static void resetThrottleTimer() {
        g_iResponseCounter = 0;
    }

    public static void setThrottleResponseLimit(Integer value) {
        if (value != null) {
            g_iThrottleResponseLimit = value;
        }
    }

    private Boolean callSameMethodWithWrapperResponse(InvocationData invocationData, String url, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil, String snippetCode) {
        String methodDesc;
        Object[] argPassArray = new Object[invocationData.getInvocationParameterCount()];
        int i = 0;
        while (i < invocationData.getInvocationParameterCount()) {
            argPassArray[i] = invocationData.getInvocationParameterAsObject(i);
            ++i;
        }
        Object o = invocationData.getInvocationObject();
        String className = invocationData.getProbeInformation().getProbeIdentification().getProbeClassName();
        String methodName = invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName();
        Map methodItem = this.getMethodAndArgClass(o, methodName, argPassArray.length, methodDesc = invocationData.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor());
        if (methodItem == null) {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...callSameMethodWithWrapperResponse... no invocationObject method is found ....");
            }
            return Boolean.FALSE;
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        argMap.put("argPassArray", argPassArray);
        argMap.put("methodItem", methodItem);
        argMap.put("snippetJS", snippetCode);
        argMap.put("maxResponseContentLengthForSearching", BTThreadLocalAdministrator.getInstance().getMaxResponseContentLengthForSearching());
        argMap.put("invocationData", invocationData);
        Object[] argArray = new Object[6];
        Class[] argClassArray = new Class[6];
        argArray[0] = o;
        argArray[1] = methodName;
        argArray[2] = className;
        argArray[3] = methodDesc;
        argArray[4] = argMap;
        argArray[5] = url;
        argClassArray[0] = Object.class;
        argClassArray[1] = String.class;
        argClassArray[2] = String.class;
        argClassArray[3] = String.class;
        argClassArray[4] = Map.class;
        argClassArray[5] = String.class;
        try {
            Boolean wrapperedFlag = BrtmTracer.invokeReturnsBoolean(factoryObject, invocationData, 2, argArray, argClassArray, wrapperFactoryUtil.getMethodCache());
            if (!wrapperedFlag.booleanValue()) {
                return Boolean.FALSE;
            }
        }
        catch (Exception exception) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "Exception in callSameMethodWithWrapperResponse method, restore original request. ");
            }
            invocationData.IMethodTracer_setShouldStub(false);
            invocationData.IMethodTracer_setReentrancyOverwrite(false);
        }
        return Boolean.TRUE;
    }

    private String shouldContinueAutoInjection(String fullURL) {
        if (fullURL == null) {
            return null;
        }
        return this.getSnippetCode(fullURL);
    }

    private String getSnippetCode(String fullURL) {
        String result = null;
        List snippetCodeList = BTThreadLocalAdministrator.getInstance().getSnippetCodeList();
        List compiledPatternList = BTThreadLocalAdministrator.getInstance().getCompiledPatternList();
        int i = 0;
        while (i < compiledPatternList.size()) {
            if (snippetCodeList.get(i) != null && compiledPatternList.get(i) != null && ((Pattern)compiledPatternList.get(i)).matcher(fullURL).matches() && (result = (String)snippetCodeList.get(i)).length() > 0) break;
            ++i;
        }
        return result;
    }

    private Map getMethodAndArgClass(Object invocationDataObject, String methodName, int argCount, String methodDesc) {
        HashMap methodItemsMap = null;
        String innerKey = new StringBuffer().append(methodName).append(argCount).append(methodDesc).toString();
        if (this.invocationDataObjectToMethodMap.containsWeakKey(invocationDataObject) && (methodItemsMap = (HashMap)this.invocationDataObjectToMethodMap.getWeak(invocationDataObject)).containsKey(innerKey)) {
            Map methodItem = (Map)methodItemsMap.get(innerKey);
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... got invocationObject method/class from invocationDataObjectToMethodMap....");
                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... invocationDataObject class name =" + invocationDataObject.getClass().getName() + "... invocationDataObject classloader =" + invocationDataObject.getClass().getClassLoader().toString());
            }
            return methodItem;
        }
        Class<?> invocationDataObjectClasses = invocationDataObject.getClass();
        HashMap<String, Object> methodItem = new HashMap<String, Object>();
        int maxSearchCount = g_searchingMethodHierarchyMaxDepth;
        Method[] methods = null;
        while (invocationDataObjectClasses != null && maxSearchCount > 0) {
            methods = maxSearchCount == g_searchingMethodHierarchyMaxDepth ? (Method[])ArrayUtilities.append(invocationDataObjectClasses.getMethods(), invocationDataObjectClasses.getDeclaredMethods(), Method.class) : invocationDataObjectClasses.getDeclaredMethods();
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method i = methodArray[n2];
                if (methodName.equals(i.getName()) && i.getParameterTypes().length == argCount) {
                    Class<?>[] argClassArray = i.getParameterTypes();
                    try {
                        MethodName newMethod = MethodName.getMethodName(i, true);
                        if (methodDesc.equalsIgnoreCase(newMethod.getMethodDescriptor().toString())) {
                            methodItem.put("method", i);
                            methodItem.put("argClassArray", argClassArray);
                            if (methodItemsMap == null) {
                                methodItemsMap = new HashMap();
                            }
                            methodItemsMap.put(innerKey, methodItem);
                            this.invocationDataObjectToMethodMap.putWeak(invocationDataObject, methodItemsMap);
                            if (feedback.isTraceEnabled()) {
                                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... add new invocationObject method/class into invocationDataObjectToMethodMap....");
                                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... invocationDataObject class name =" + invocationDataObject.getClass().getName() + "... invocationDataObject classloader =" + invocationDataObject.getClass().getClassLoader().toString());
                            }
                            return methodItem;
                        }
                    }
                    catch (InvalidMethodDescriptorException e) {
                        feedback.error(BRTM_MODULE, "Failed to get Method: " + e.getMessage(), e);
                    }
                    catch (InvalidMethodNameException e) {
                        feedback.error(BRTM_MODULE, "Failed to get Method: " + e.getMessage(), e);
                    }
                }
                ++n2;
            }
            invocationDataObjectClasses = invocationDataObjectClasses.getSuperclass();
            --maxSearchCount;
        }
        return null;
    }

    private static final IWeakIdentityMap getCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory mapFactory = agent.IAgent_getConcurrentMapFactory();
            return mapFactory.getConcurrentCappedWeakIdentityMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    private Object getURLWithQueryString(Object request, InvocationData invocationData, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil) {
        Object[] argArray = new Object[2];
        Class[] classArray = new Class[2];
        argArray[0] = request;
        argArray[1] = invocationData;
        classArray[0] = Object.class;
        classArray[1] = Object.class;
        Object result = BrtmTracer.invokeReturnsObject(factoryObject, invocationData, 0, argArray, classArray, wrapperFactoryUtil.getMethodCache());
        return result;
    }

    private boolean skipInstrumentClass(InvocationData invocationData, MutableInteger stackDepth, int autoSkipClassDepth) {
        if (!BTThreadLocalAdministrator.getInstance().isEncodingSupport()) {
            return false;
        }
        String invocationDataMethod = invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName();
        if ("service".equalsIgnoreCase(invocationDataMethod) || "handleRequest".equalsIgnoreCase(invocationDataMethod) || "_jspService".equalsIgnoreCase(invocationDataMethod)) {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "Instrumenting class: " + invocationData.getProbeInformation().getProbeIdentification().getRuntimeFullClassName());
            }
            return false;
        }
        if (stackDepth.getValue() <= autoSkipClassDepth) {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "Skip instrument class: " + invocationData.getProbeInformation().getProbeIdentification().getRuntimeFullClassName());
            }
            return true;
        }
        return false;
    }
}

