/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtils {
    private static final Module BRTM_MODULE = new Module("BrowserAgent");

    public static void createCookies(IAgent agent, IModuleFeedbackChannel feedback, HttpServletResponse resp) {
        String cookieValue;
        long gaptime;
        String url;
        int expirationTime;
        block31: {
            String encrypted_UTF8_Msg;
            Object params;
            Cookie[] requestCookies;
            Object shouldAddCookie = BTThreadLocalAdministrator.getInstance().get("shouldAddResponseCookie");
            if (shouldAddCookie == null || shouldAddCookie instanceof Boolean && !((Boolean)shouldAddCookie).booleanValue()) {
                return;
            }
            BTThreadLocalAdministrator.getInstance();
            expirationTime = BTThreadLocalAdministrator.getResponseCookieExpirationTime();
            if (BTThreadLocalAdministrator.getInstance().get("requestObject") != null && BTThreadLocalAdministrator.getInstance().get("requestObject") instanceof HttpServletRequest && (requestCookies = ((HttpServletRequest)BTThreadLocalAdministrator.getInstance().get("requestObject")).getCookies()) != null) {
                Cookie[] cookieArray = requestCookies;
                int n = requestCookies.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie c = cookieArray[n2];
                    if (c.getName().equals("x-apm-brtm-response-bt-id") && c.getValue() != null) {
                        try {
                            BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-response-bt-id", (Object)URLDecoder.decode(c.getValue(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            feedback.error(BRTM_MODULE, "UnsupportedEncodingException: ", e);
                        }
                    }
                    ++n2;
                }
            }
            url = (String)BTThreadLocalAdministrator.getInstance().get("BRTM_REQ_URI");
            gaptime = 0L;
            if (BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-gaptime") != null) {
                try {
                    gaptime = Long.parseLong((String)BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-gaptime"));
                }
                catch (NumberFormatException numberFormatException) {
                    gaptime = 0L;
                }
                if (feedback.isTraceEnabled()) {
                    feedback.trace("...insertBRTMCookie ..client-server gaptime... = " + gaptime + ", url = " + url);
                }
                if (gaptime < 0L) {
                    gaptime = 0L;
                } else if (gaptime + 120L >= Integer.MAX_VALUE) {
                    gaptime = -1L;
                }
            }
            StringBuffer cookieBuffer = new StringBuffer();
            IBizTrx btDefine = (IBizTrx)BTThreadLocalAdministrator.getInstance().get("BusinessTrxData");
            if (btDefine != null) {
                cookieBuffer.append("bs=").append(btDefine.getBizProcessName()).append(",bt=").append(btDefine.getBizTrxName()).append(",btc=").append(btDefine.getBizTrxComponentName());
            } else {
                cookieBuffer.append("bs=-1,bt=-1,btc=-1");
            }
            Boolean ttSent = CookieUtils.getFiltersStatus(agent);
            long time = 0L;
            if (BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-tt-starttime") != null) {
                time = (Long)BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-tt-starttime");
                Cookie serverTimeCookie = new Cookie("x-apm-brtm-servertime", String.valueOf(time));
                serverTimeCookie.setPath("/");
                resp.addCookie(serverTimeCookie);
            }
            if (ttSent.booleanValue()) {
                String guidKey;
                SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
                if (cache == null || cache.getCorrelationID() == null) {
                    new CorrelationId();
                }
                if ((guidKey = cache.getCorrelationID()) != null) {
                    cookieBuffer.append(",").append("CorBrowsGUID").append("=").append(guidKey);
                }
                if (time > 0L) {
                    cookieBuffer.append(",startTime=").append(time);
                    if (BTThreadLocalAdministrator.getInstance().get("endTime") != null) {
                        time = (Long)BTThreadLocalAdministrator.getInstance().get("endTime");
                    }
                    cookieBuffer.append(",endTime=").append(time);
                }
            }
            if ((params = BTThreadLocalAdministrator.getInstance().get("agentInfo")) != null && params instanceof Map && (encrypted_UTF8_Msg = CookieUtils.toEncryptedAgentInfo((Map)params, feedback)) != null && encrypted_UTF8_Msg.length() > 0) {
                cookieBuffer.append(",").append(encrypted_UTF8_Msg);
            }
            cookieValue = cookieBuffer.toString();
            try {
                if (cookieValue.length() > 0) {
                    cookieValue = URLEncoder.encode(cookieValue, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!feedback.isDebugEnabled()) break block31;
                feedback.debug(BRTM_MODULE, "Browser Agent UnsupportedEncodingException:" + e.toString());
            }
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace("...insertBRTMCookie ..cookieValue... = " + cookieValue + ", url = " + url);
        }
        if (BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-response-bt-id") != null) {
            Cookie ajaxCookie = new Cookie("x-apm-brtm-response-bt-" + BTThreadLocalAdministrator.getInstance().get("x-apm-brtm-response-bt-id"), cookieValue);
            ajaxCookie.setPath("/");
            ajaxCookie.setMaxAge((int)((long)expirationTime + gaptime));
            resp.addCookie(ajaxCookie);
        } else {
            String urlEncoded;
            block32: {
                urlEncoded = url;
                try {
                    if (urlEncoded.length() > 0) {
                        urlEncoded = URLEncoder.encode(url, "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!feedback.isDebugEnabled()) break block32;
                    feedback.debug(BRTM_MODULE, "Browser Agent UnsupportedEncodingException:" + e.toString());
                }
            }
            Cookie pagecookie = new Cookie("x-apm-brtm-response-bt-page-" + urlEncoded, cookieValue);
            pagecookie.setPath("/");
            pagecookie.setMaxAge((int)((long)expirationTime + gaptime));
            resp.addCookie(pagecookie);
        }
    }

    public static boolean getFiltersStatus(IAgent agent) {
        if (agent.IAgent_getComponentTracer().getHeadFilteringStatus()) {
            return true;
        }
        boolean checkHeadPresence = BTThreadLocalAdministrator.getInstance().shouldCheckForHeadFilterPresence();
        boolean checkTailPresence = BTThreadLocalAdministrator.getInstance().shouldCheckForTailFilterPresence();
        if (checkHeadPresence && checkTailPresence) {
            return FilterController.getDynamicFilterPresence();
        }
        if (checkHeadPresence) {
            return FilterController.getTransientHeadFilterPresence();
        }
        if (checkTailPresence) {
            return FilterController.getTailFilterPresence();
        }
        return false;
    }

    public static String toEncryptedAgentInfo(Map<String, String> params, IModuleFeedbackChannel feedback) {
        StringBuffer result = new StringBuffer();
        boolean firstItem = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = entry.getValue();
            if (value == null || value.length() <= 0) continue;
            if (!firstItem) {
                result.append(',');
            } else {
                firstItem = false;
            }
            result.append(entry.getKey());
            result.append('=');
            result.append(value);
        }
        return result.toString();
    }
}

