/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class WrapperUtils {
    private static final Module BA_MODULE = new Module("BrowserAgent");
    public static final String JAR_FILE_EXTENSION = ".jar";

    public static File getJARFile(String dir, String jarManifestAttributeName, String jarManifestAttributeValue, IModuleFeedbackChannel feedback) {
        List<File> fileList;
        File jarFile = null;
        if (dir != null && dir.length() > 0 && jarManifestAttributeName != null && jarManifestAttributeName.length() > 0 && jarManifestAttributeValue != null && jarManifestAttributeValue.length() > 0 && (fileList = WrapperUtils.listJARFilesByAttributeNameAndValue(dir, jarManifestAttributeName, jarManifestAttributeValue, feedback)) != null) {
            if (fileList.isEmpty()) {
                feedback.debug(BA_MODULE, "There are no JARs which contain the manifest attribute name: " + jarManifestAttributeName + " and manifest attribute value: " + jarManifestAttributeValue);
            } else if (fileList.size() == 1) {
                jarFile = fileList.get(0);
            } else if (fileList.size() > 1) {
                feedback.debug(BA_MODULE, "There are more than one JAR which contain the manifest attribute name: " + jarManifestAttributeName + " and manifest attribute value: " + jarManifestAttributeValue + "; The JARs are: " + fileList + "; One JAR would be picked from this list randomly.");
                jarFile = fileList.get(0);
            }
        }
        if (jarFile != null) {
            try {
                feedback.debug(BA_MODULE, "The JAR: " + jarFile.getCanonicalPath() + " that contains the manifest attribute name: " + jarManifestAttributeName + " and manifest attribute value: " + jarManifestAttributeValue + " would be considered for ClassLoader.");
            }
            catch (IOException e) {
                feedback.error("IOException: " + e);
            }
        }
        return jarFile;
    }

    public static List<File> listJARFilesByAttributeNameAndValue(String dir, String manifestAttributeName, String manifestAttributeValue, IModuleFeedbackChannel feedback) {
        File[] listOfFiles;
        File folder;
        ArrayList<File> jarFileList = new ArrayList<File>();
        if (dir != null && dir.length() > 0 && manifestAttributeName != null && manifestAttributeName.length() > 0 && manifestAttributeValue != null && manifestAttributeValue.length() > 0 && (folder = new File(dir)) != null && (listOfFiles = folder.listFiles()) != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                File file = listOfFiles[i];
                if (file != null && file.isFile() && file.canRead() && WrapperUtils.hasMatchingFileExtension(file, JAR_FILE_EXTENSION) && WrapperUtils.isMatchingJARByManifestAttributeNameAndValue(file, manifestAttributeName, manifestAttributeValue, feedback)) {
                    jarFileList.add(file);
                }
                ++i;
            }
        }
        feedback.debug(BA_MODULE, "jarFileList: " + jarFileList);
        return jarFileList;
    }

    public static boolean hasMatchingFileExtension(File file, String fileExtension) {
        boolean isMatchingFileExtensionFlag = false;
        if (file != null && fileExtension != null && fileExtension.length() > 0 && file.getName() != null && file.getName().endsWith(fileExtension)) {
            isMatchingFileExtensionFlag = true;
        }
        return isMatchingFileExtensionFlag;
    }

    public static boolean isMatchingJARByManifestAttributeNameAndValue(File file, String manifestAttributeName, String manifestAttributeValue, IModuleFeedbackChannel feedback) {
        boolean flag;
        block4: {
            flag = false;
            if (file != null && manifestAttributeName != null && manifestAttributeName.length() > 0 && manifestAttributeValue != null && manifestAttributeValue.length() > 0) {
                try {
                    Attributes attrs;
                    Manifest manifest;
                    JarFile jarFile = new JarFile(file);
                    if (jarFile == null || (manifest = jarFile.getManifest()) == null || (attrs = manifest.getMainAttributes()) == null) break block4;
                    for (Attributes.Name name : attrs.keySet()) {
                        String attrValue = attrs.getValue(name);
                        if (!name.toString().equals(manifestAttributeName) || attrValue == null || !attrValue.equals(manifestAttributeValue)) continue;
                        flag = true;
                        break;
                    }
                }
                catch (IOException e) {
                    feedback.error("IOException: " + e);
                }
            }
        }
        return flag;
    }

    public static URLClassLoader getJARClassLoader(ClassLoader parent, IAgent agent, IModuleFeedbackChannel feedback, String jarManifestAttributeName, String jarManifestAttributeValue) throws MalformedURLException {
        URLClassLoader urlClassLoader = null;
        String extensionDir = null;
        if (parent != null && agent != null && feedback != null && jarManifestAttributeName != null && jarManifestAttributeName.length() > 0 && jarManifestAttributeValue != null && jarManifestAttributeValue.length() > 0) {
            URL[] urlResources;
            IResource resource;
            feedback.debug(BA_MODULE, "jarManifestAttributeName: " + jarManifestAttributeName);
            feedback.debug(BA_MODULE, "jarManifestAttributeValue: " + jarManifestAttributeValue);
            String directoryProperty = (String)agent.IAgent_getIndexedProperties().get("introscope.agent.extensions.directory");
            feedback.debug(BA_MODULE, "directoryProperty: " + directoryProperty);
            extensionDir = ExtendedFile.isAbsolutePath(directoryProperty) ? WrapperUtils.getExtensionDirectory(agent, feedback) : String.valueOf(WrapperUtils.getAbsoluteAgentPath(agent)) + File.separator + WrapperUtils.getExtensionDirectory(agent, feedback);
            feedback.debug(BA_MODULE, "extensionDir: " + extensionDir);
            File jarFile = WrapperUtils.getJARFile(extensionDir, jarManifestAttributeName, jarManifestAttributeValue, feedback);
            if (jarFile != null && (resource = WrapperUtils.getFileResource(jarFile, feedback)) != null && (urlResources = new URL[]{resource.IResource_getURL()}) != null) {
                urlClassLoader = new URLClassLoader(urlResources, parent);
            }
        }
        if (urlClassLoader != null) {
            feedback.debug(BA_MODULE, "urlClassLoader: " + urlClassLoader);
        } else {
            feedback.info(BA_MODULE, "No JAR with the matching manifest attribute: " + jarManifestAttributeName + " and value: " + jarManifestAttributeValue + " can be found in the " + "extensionDirectory: " + extensionDir + ".  Returning null ClassLoader.");
        }
        return urlClassLoader;
    }

    public static String getAbsoluteAgentPath(IAgent agent) {
        String path = "";
        IResource profileResource = agent.IAgent_getConfigurationResource();
        if (profileResource.IResource_isFileResource()) {
            File profileDirectory = new File(profileResource.IResource_getLocation()).getParentFile();
            File pathFile = new File(profileDirectory, path);
            path = pathFile.getAbsolutePath();
        }
        return path;
    }

    public static IResource getFileResource(File file, IModuleFeedbackChannel feedback) {
        String extendedFileCanonicalPath;
        ExtendedFile extendedFile;
        FileBasedResource fileResource = null;
        if (file != null && file.exists() && file.canRead() && (extendedFile = new ExtendedFile(file)) != null && (extendedFileCanonicalPath = extendedFile.safeGetCanonicalPath()) != null) {
            fileResource = new FileBasedResource(extendedFileCanonicalPath);
        }
        if (fileResource != null) {
            feedback.debug(BA_MODULE, "fileResource: " + fileResource);
        }
        return fileResource;
    }

    public static String getExtensionDirectory(IAgent agent, IModuleFeedbackChannel feedback) {
        String extFolder = "";
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        extFolder = props.getTrimmedProperty("introscope.agent.extensions.directory");
        return extFolder;
    }
}

