/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.ConditionalAnchorTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;

public class ConditionalBlamePointTracer
extends BlamePointTracer {
    private boolean fIsConditional = false;

    public ConditionalBlamePointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String callingClassParameter = this.getParameter("callingClass");
        String callingMethodParameter = this.getParameter("callingMethod");
        if (callingClassParameter != null && callingMethodParameter != null) {
            this.fIsConditional = true;
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!this.fIsConditional) {
            super.ITracer_startTrace(tracerIndex, data);
        } else {
            String callingMethodParameter;
            String callingClassParameter = this.getParameter("callingClass");
            if (ConditionalAnchorTracer.existsAnchor(callingClassParameter, callingMethodParameter = this.getParameter("callingMethod"))) {
                super.ITracer_startTrace(tracerIndex, data);
            }
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!this.fIsConditional) {
            super.ITracer_finishTrace(tracerIndex, data);
        } else {
            String callingMethodParameter;
            String callingClassParameter = this.getParameter("callingClass");
            if (ConditionalAnchorTracer.existsAnchor(callingClassParameter, callingMethodParameter = this.getParameter("callingMethod"))) {
                super.ITracer_finishTrace(tracerIndex, data);
            }
        }
    }
}

