/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.BlameStackAnnotationHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IBlameStackAnnotator;
import com.wily.introscope.agent.LazyMetricNameProvider;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.introscope.agent.probe.net.DefaultBackendFeatureFactory;
import com.wily.introscope.agent.trace.BackendTracer;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.util.properties.AttributeListing;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public abstract class ChannelBackendTracer
extends BackendTracer
implements LazyMetricNameProvider {
    private static final IAgent sAgent = ChannelBackendTracer.findAgent();
    private static boolean shouldAnnotateTT = sAgent == null ? false : sAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.reportInTT", true);
    private static boolean runsOnOldConfig;
    private static final ComponentTracer sComponentTracer;

    static {
        sComponentTracer = sAgent == null ? null : sAgent.IAgent_getComponentTracer();
        runsOnOldConfig = sComponentTracer == null ? false : sComponentTracer.isAgentOldMode();
    }

    private static final IAgent findAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException anae) {
            try {
                AgentShim.handleError("Unable to gather socket data because the Agent is not available", anae);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    public ChannelBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected abstract boolean isRequired(InvocationData var1);

    @Override
    protected abstract String getComponentName(InvocationData var1);

    protected abstract String getAnnotationTitle(InvocationData var1);

    protected abstract InetSocketAddress getResourceAddress(InvocationData var1);

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return;
        }
        if (this.isRequired(data)) {
            this.annotateBlameStack(data);
        }
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    public static String getDnsHostName(InetAddress inIpAddress) {
        String dnsName;
        try {
            IAgent agent = AgentShim.getAgent();
            IDnsService dnsService = agent.IAgent_getDnsService();
            dnsName = dnsService.getDnsHostNameByIPAddr(inIpAddress);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            dnsName = inIpAddress.getHostAddress();
        }
        catch (Exception exception) {
            dnsName = inIpAddress.getHostAddress();
        }
        return dnsName;
    }

    private void annotateBlameStack(InvocationData data) {
        if (runsOnOldConfig) {
            if (shouldAnnotateTT && !DefaultBackendFeatureFactory.getFeatureForCurrentThread().backendWasTouchedInMostRecentBlameFrame()) {
                String formattedName = this.formatParameterizedName(data);
                InetSocketAddress address = this.getResourceAddress(data);
                IBlameStack stack = data.getStack(sComponentTracer, false);
                sComponentTracer.addExtraParameter(stack, this.getAnnotationTitle(data), formattedName);
                String dnsName = ChannelBackendTracer.getDnsHostName(address.getAddress());
                DefaultBackendFeatureFactory.getFeatureForCurrentThread().setDefaultBackend(formattedName, dnsName, address.getPort());
            }
        } else {
            IBlameStackAnnotator defaultBlameStackAnnotator;
            IStackElement currentData = VirtualStack.peek();
            if (currentData == null) {
                return;
            }
            ITransactionElement currentCursor = currentData.getCursor();
            if (currentCursor != null && (defaultBlameStackAnnotator = BlameStackAnnotationHelper.getBlameStackAnnotator(BlameStackAnnotationHelper.kDefaultBackendBlameStackAnnotator)) != null) {
                defaultBlameStackAnnotator.annotateBlameStack((Object)this.formatParameterizedName(data), currentCursor, currentData, false);
                data.setHasNewCursor();
                data.setParent(currentData);
            }
        }
    }

    @Override
    public String getMetricName(IStackElement data) {
        return this.formatParameterizedName((InvocationData)data);
    }
}

