/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer.dynamic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.ICodeIntrospectionService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationFilter;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ACodeIntrospectionService
implements ICodeIntrospectionService {
    private IAgent fAgent;
    private IModuleFeedbackChannel fFeedback;
    private IDynamicInstrumentationTransformer fTransformer;
    private IDynamicInstrumentationFilter fFilter;
    private static final Module kModule = new Module("CodeIntrospectionService");
    private static final String NOT_IMPLEMENTED = "Not implemented";
    private static final String INVALID_METHOD_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST = "Invalid method name in dynamic intrumentation request: ";
    private static final String INVALID_CLASS_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST = "Invalid class name in dynamic intrumentation request: ";

    public ACodeIntrospectionService(IDynamicInstrumentationTransformer transformer, IDynamicInstrumentationFilter filter, IAgent agent, IModuleFeedbackChannel feedback) {
        this.fAgent = agent;
        this.fFeedback = feedback;
        this.fTransformer = transformer;
        this.fFilter = filter;
    }

    public String findClassWithMethod(String classPattern, String methodPattern) {
        this.fFeedback.trace(kModule, "input class = " + classPattern);
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = this.fTransformer.getClasses();
        if (rep != null) {
            ArrayList targetMethodClassPairs = new ArrayList();
            this.getMethodsForClass(classPattern, true, rep, targetMethodClassPairs);
            for (DynamicInstrumentationResult.ClassMethodPair pair : targetMethodClassPairs) {
                if (!pair.getMethodSignature().equals(methodPattern)) continue;
                this.fFeedback.trace("output class = " + pair.getClassName());
                return ACodeIntrospectionService.convertToDotNotation(pair.getClassName());
            }
            this.fFeedback.trace("output class = " + classPattern);
            return classPattern;
        }
        return null;
    }

    public void filterMethodCallsForInstrumentation(String requesterClass, Collection classMethodPairs) {
        HashMap cache = new HashMap();
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = this.fTransformer.getClasses();
        for (DynamicInstrumentationResult.ClassMethodPair pair : classMethodPairs) {
            this.upgradeByRequesterClass(rep, requesterClass, pair);
            if (this.shouldSkip(rep, cache, pair)) {
                pair.setInstrumentable(false);
            } else {
                pair.setInstrumentable(true);
            }
            pair.setInstrumented(this.hasTracers(rep, cache, pair));
            pair.setInterface(this.isInterface(rep, cache, pair));
        }
    }

    private void getMethodsForClass(String className, boolean actualImplementingClassAsResult, IClassRedefinitionDelegate.IRedefinedClassRepository rep, Collection targetMethodClassPairCollection) {
        HashSet methods = new HashSet();
        SimpleModeledMethod smm = new SimpleModeledMethod(null);
        int i = 0;
        while (i < rep.getAllClassInVM().length) {
            block7: {
                block6: {
                    Class clazz = rep.getAllClassInVM()[i];
                    try {
                        ClassName name = ClassName.getClassName(clazz.getName());
                        if (!name.getReflectionFriendlyQualifiedNameString().equals(className)) break block6;
                        try {
                            this.getDeclaredMethods(methods, smm, clazz, name, targetMethodClassPairCollection);
                        }
                        catch (IllegalStateException illegalStateException) {
                            break block7;
                        }
                        if (actualImplementingClassAsResult) {
                            this.addInheritedMethods(null, clazz, methods, targetMethodClassPairCollection, smm);
                            break;
                        }
                        this.addInheritedMethods(name, clazz, methods, targetMethodClassPairCollection, smm);
                        break;
                    }
                    catch (InvalidClassNameException invalidClassNameException) {
                        this.fFeedback.trace(kModule, "Class name " + clazz.getName() + " returned from repository is not valid");
                    }
                }
                methods.clear();
            }
            ++i;
        }
    }

    private void getDeclaredMethods(Set methods, SimpleModeledMethod smm, Class clazz, IClassName name, Collection methodClassPairs) {
        Method[] m = clazz.getDeclaredMethods();
        int j = 0;
        while (j < m.length) {
            smm.setMethod(m[j]);
            DynamicInstrumentationResult.ClassMethodPair pair = new DynamicInstrumentationResult.ClassMethodPair(name.getReflectionFriendlyQualifiedNameString(), smm.methodName.getNameAndSignatureString());
            pair.setAbstractMethod(smm.isAbstract());
            methodClassPairs.add(pair);
            ++j;
        }
        methods.addAll(Arrays.asList(clazz.getMethods()));
    }

    private void addInheritedMethods(IClassName originalBaseName, Class clazz, Set availableMethods, Collection result, SimpleModeledMethod smm) throws InvalidClassNameException {
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ClassName name = ClassName.getClassName(superClass.getName());
            Method[] m = superClass.getDeclaredMethods();
            int j = 0;
            while (j < m.length) {
                if (MethodName.isProtected(m[j]) || availableMethods.contains(m[j])) {
                    smm.setMethod(m[j]);
                    IClassName declaringClassName = name;
                    if (originalBaseName != null) {
                        declaringClassName = originalBaseName;
                    }
                    DynamicInstrumentationResult.ClassMethodPair pair = new DynamicInstrumentationResult.ClassMethodPair(declaringClassName.getReflectionFriendlyQualifiedNameString(), smm.methodName.getNameAndSignatureString());
                    pair.setAbstractMethod(smm.isAbstract());
                    result.add(pair);
                }
                ++j;
            }
            this.addInheritedMethods(originalBaseName, superClass, availableMethods, result, smm);
        }
    }

    private void upgradeByRequesterClass(IClassRedefinitionDelegate.IRedefinedClassRepository rep, String requesterClassName, DynamicInstrumentationResult.ClassMethodPair pair) {
        Class<?> declaringClass;
        Object m;
        Class requesterClass = this.getLoadedClass(rep, ACodeIntrospectionService.convertToDotNotation(requesterClassName));
        Class pairClass = this.getLoadedClass(rep, ACodeIntrospectionService.convertToDotNotation(pair.getClassName()));
        if (pairClass != null && pairClass.isAssignableFrom(requesterClass) && (m = this.getMethod(requesterClass, pair.getMethodSignature())) != null && !(declaringClass = ((Method)m).getDeclaringClass()).getName().equals(pair.getClassName())) {
            pair.setClassName(((Method)m).getDeclaringClass().getName());
        }
    }

    private boolean shouldSkip(IClassRedefinitionDelegate.IRedefinedClassRepository rep, Map cache, DynamicInstrumentationResult.ClassMethodPair pair) {
        SimpleModeledMethod m = this.getRedefinableMethod(rep, cache, pair.getClassName(), pair.getMethodSignature());
        if (m != null) {
            SimpleModeledClass cls = SimpleModeledClass.getInstance(m.getUnderlyingClass());
            return !this.fFilter.canRedefine(cls, m);
        }
        return true;
    }

    private boolean hasTracers(IClassRedefinitionDelegate.IRedefinedClassRepository rep, Map cache, DynamicInstrumentationResult.ClassMethodPair pair) {
        SimpleModeledMethod m = this.getRedefinableMethod(rep, cache, pair.getClassName(), pair.getMethodSignature());
        if (m != null) {
            SimpleModeledClass cls = SimpleModeledClass.getInstance(m.getUnderlyingClass());
            return this.fFilter.hasTracers(cls, m);
        }
        return false;
    }

    private boolean isInterface(IClassRedefinitionDelegate.IRedefinedClassRepository rep, Map cache, DynamicInstrumentationResult.ClassMethodPair pair) {
        SimpleModeledMethod m = this.getRedefinableMethod(rep, cache, pair.getClassName(), pair.getMethodSignature());
        if (m != null) {
            SimpleModeledClass cls = SimpleModeledClass.getInstance(m.getUnderlyingClass());
            return cls.isInterface();
        }
        return false;
    }

    private Object getMethod(Class ownerClass, String methodSignature) {
        if (ownerClass == null) {
            return null;
        }
        SimpleModeledMethod buffer = new SimpleModeledMethod(null);
        Method[] m = ownerClass.getDeclaredMethods();
        int j = 0;
        while (j < m.length) {
            buffer.setMethod(m[j]);
            if (buffer.getMethodName().getNameAndSignatureString().equals(methodSignature)) {
                return m[j];
            }
            ++j;
        }
        return this.getMethod(ownerClass.getSuperclass(), methodSignature);
    }

    public void getMethods(String classPattern, Collection methodClassPairs) {
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = this.fTransformer.getClasses();
        this.getMethodsForClass(classPattern, true, rep, methodClassPairs);
    }

    public void getClasses(String packagePattern, Collection result) {
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = this.fTransformer.getClasses();
        int i = 0;
        while (i < rep.getAllClassInVM().length) {
            Class clazz = rep.getAllClassInVM()[i];
            try {
                ClassName name = ClassName.getClassName(clazz.getName());
                String packageName = name.getPackageName().getNameString();
                String packageNameReflectionFriently = ACodeIntrospectionService.convertToDotNotation(packageName);
                if (packageNameReflectionFriently.equals(packagePattern) || packageName.equals(packagePattern)) {
                    result.add(name.getReflectionFriendlyQualifiedNameString());
                }
            }
            catch (InvalidClassNameException invalidClassNameException) {
                this.fFeedback.trace(kModule, "Class name " + clazz.getName() + " returned from repository is not valid");
            }
            ++i;
        }
    }

    public void getPackagesOrAssemblies(Collection result) {
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = this.fTransformer.getClasses();
        int i = 0;
        while (i < rep.getAllClassInVM().length) {
            Class clazz = rep.getAllClassInVM()[i];
            try {
                ClassName name = ClassName.getClassName(clazz.getName());
                String packageName = name.getPackageName().getNameString();
                String packageNameReflectionFriendly = ACodeIntrospectionService.convertToDotNotation(packageName);
                result.add(packageNameReflectionFriendly);
            }
            catch (InvalidClassNameException invalidClassNameException) {
                this.fFeedback.trace(kModule, "Class name " + clazz.getName() + " returned from repository is not valid");
            }
            ++i;
        }
    }

    public ICodeIntrospectionService.ClassMethodName getClassMethodName(IClassRedefinitionDelegate.IRedefinedClassRepository rep, String className, String methodName) {
        ICodeIntrospectionService.ClassMethodName result = new ICodeIntrospectionService.ClassMethodName();
        if (className == null || methodName == null) {
            return result;
        }
        try {
            result.setClassName(ClassName.getClassName(className));
            result.setMethodName(MethodName.getMethodName(methodName));
            Class clazz = this.getLoadedClass(rep, result.getClassName());
            if (clazz == null) {
                throw new InvalidClassNameException(className);
            }
            result.setInterface(clazz.isInterface());
            TreeSet methodClassPairs = new TreeSet();
            IClassName clazzName = result.getClassName();
            while (clazz != null) {
                clazzName = ClassName.getClassName(clazz.getName());
                this.getDeclaredMethods(new HashSet(), new SimpleModeledMethod(null), clazz, clazzName, methodClassPairs);
                for (DynamicInstrumentationResult.ClassMethodPair pair : methodClassPairs) {
                    if (!pair.getClassName().equals(clazz.getName()) || !pair.getMethodSignature().equals(result.getMethodName().getNameAndSignatureString())) continue;
                    result.setAbstractMethod(pair.isAbstractMethod());
                    result.setClassName(clazzName);
                    return result;
                }
                clazz = clazz.getSuperclass();
                methodClassPairs.clear();
            }
            throw new NoSuchMethodException(String.valueOf(className) + "." + methodName);
        }
        catch (InvalidClassNameException e) {
            result.setException(e);
            result.setVerbose(INVALID_CLASS_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST + className);
        }
        catch (InvalidMethodDescriptorException e) {
            result.setException(e);
            result.setVerbose(INVALID_METHOD_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST + methodName);
        }
        catch (InvalidMethodNameException e) {
            result.setException(e);
            result.setVerbose(INVALID_METHOD_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST + methodName);
        }
        catch (NoSuchMethodException e) {
            result.setException(e);
            result.setVerbose(INVALID_METHOD_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST + methodName);
        }
        return result;
    }

    private SimpleModeledMethod getRedefinableMethod(IClassRedefinitionDelegate.IRedefinedClassRepository rep, Map foundClassMethods, String className, String methodSignature) {
        Class ownerClass = null;
        Object cachedClassMap = foundClassMethods.get(className);
        if (cachedClassMap == null) {
            cachedClassMap = new HashMap();
            ownerClass = this.getLoadedClass(rep, ACodeIntrospectionService.convertToDotNotation(className));
            ((Map)cachedClassMap).put(className, ownerClass);
        }
        Object cachedMethod = null;
        if (ownerClass != null && (cachedMethod = (Object)((Map)cachedClassMap).get(methodSignature)) == null && (cachedMethod = this.getMethod(ownerClass, methodSignature)) != null) {
            Class<?> methodClass = ((Method)cachedMethod).getDeclaringClass();
            if (!methodClass.equals(ownerClass) && (cachedClassMap = foundClassMethods.get(methodClass.getName())) == null) {
                cachedClassMap = new HashMap();
                ((Map)cachedClassMap).put(methodClass.getName(), methodClass);
            }
            ((Map)cachedClassMap).put(methodSignature, cachedMethod);
        }
        if (cachedMethod != null) {
            return SimpleModeledMethod.getInstance((Method)cachedMethod);
        }
        return null;
    }

    private Class getLoadedClass(IClassRedefinitionDelegate.IRedefinedClassRepository rep, IClassName className) {
        String classNameReflectionFriendly = className.getReflectionFriendlyQualifiedNameString();
        return this.getLoadedClass(rep, classNameReflectionFriendly);
    }

    private Class getLoadedClass(IClassRedefinitionDelegate.IRedefinedClassRepository rep, String className) {
        if (rep != null) {
            int i = 0;
            while (i < rep.getAllClassInVM().length) {
                Class clazz = rep.getAllClassInVM()[i];
                if (className.equals(clazz.getName())) {
                    return clazz;
                }
                ++i;
            }
        }
        return null;
    }

    private static String convertToDotNotation(String input) {
        if (input != null) {
            return input.replace('/', '.');
        }
        return "";
    }

    static class SimpleModeledClass
    implements IModeledClass {
        Class cls;

        SimpleModeledClass() {
        }

        public boolean containsAnnotation(IClassName annotationName) {
            return false;
        }

        public Iterator getAllDeclaredMethods() {
            return null;
        }

        public IClassName getClassName() {
            try {
                return ClassName.getClassName(this.cls.getName());
            }
            catch (InvalidClassNameException e) {
                e.printStackTrace();
                return null;
            }
        }

        public IClassName getSuperClassName() {
            if (this.cls.getSuperclass() == null) {
                return null;
            }
            try {
                return ClassName.getClassName(this.cls.getSuperclass().getName());
            }
            catch (InvalidClassNameException e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean hasSuperClass() {
            return this.cls.getSuperclass() != null;
        }

        public boolean inheritsDirectlyFromInterface(IClassName interfaceName) {
            return false;
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }

        public boolean isValueType() {
            return this.cls.isPrimitive();
        }

        public boolean referencesClass(IClassName referencedName) {
            return false;
        }

        public static SimpleModeledClass getInstance(Class c) {
            SimpleModeledClass result = new SimpleModeledClass();
            result.cls = c;
            return result;
        }

        public boolean isInstanceOf(IClassName interfaceName) {
            try {
                Class<?> interfaceClass = Class.forName(interfaceName.getReflectionFriendlyQualifiedNameString(), false, this.cls.getClassLoader());
                return interfaceClass.isAssignableFrom(this.cls);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public void debugDump(PrintWriter log) {
        }
    }

    static class SimpleModeledMethod
    implements IModeledMethod {
        IMethodName methodName;
        Method method;

        public void setMethod(Method m) {
            this.getMethodNameFromMethod(m);
        }

        public SimpleModeledMethod(Method m) {
            this.getMethodNameFromMethod(m);
        }

        private void getMethodNameFromMethod(Method m) {
            if (m == null) {
                return;
            }
            try {
                this.methodName = MethodName.getMethodName(m, true);
                this.method = m;
            }
            catch (InvalidMethodDescriptorException e) {
                e.printStackTrace();
            }
            catch (InvalidMethodNameException e) {
                e.printStackTrace();
            }
        }

        public boolean containsAnnotation(IClassName annotationName) {
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public IMethodName getMethodName() {
            return this.methodName;
        }

        public IModeledClass getModeledClass() {
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public Class getUnderlyingClass() {
            return this.method.getDeclaringClass();
        }

        public IMethodSignature getSignature() {
            if (this.methodName != null) {
                return this.methodName.getSignature();
            }
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public boolean hasBytecode() {
            if (this.method != null) {
                return !this.isAbstract();
            }
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public boolean isClassConstructor() {
            if (this.method != null) {
                return this.method.getName().equals("<clinit>");
            }
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public boolean isComplex() {
            return true;
        }

        public boolean isComplex(boolean includeRestricted) {
            return true;
        }

        public boolean isEntryPoint() {
            if (this.method != null) {
                return this.method.getName().equals("main");
            }
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public boolean isInstanceConstructor() {
            if (this.method != null) {
                return this.method.getName().equals("<init>");
            }
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public boolean isRemote() {
            if (this.method != null) {
                try {
                    Class<?> remoteException = Class.forName("java.rmi.RemoteException");
                    return Arrays.asList(this.method.getExceptionTypes()).contains(remoteException);
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public boolean isStatic() {
            if (this.method != null) {
                return Modifier.isStatic(this.method.getModifiers());
            }
            throw new UnsupportedOperationException(ACodeIntrospectionService.NOT_IMPLEMENTED);
        }

        public static SimpleModeledMethod getInstance(Method m) {
            return new SimpleModeledMethod(m);
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.method.getModifiers());
        }
    }
}

