/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITailParameterTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;

public final class ThresholdTransactionTraceFilter
extends ATransactionTraceFilter
implements ITailParameterTransactionTraceFilter,
Externalizable {
    private static final long serialVersionUID = -6710050481378412060L;
    private long fThresholdInMillis;

    public ThresholdTransactionTraceFilter() {
        this.fThresholdInMillis = -1L;
    }

    public ThresholdTransactionTraceFilter(long thresholdInMillis) {
        Assertion.wilyAssert(false);
        this.fThresholdInMillis = thresholdInMillis;
    }

    public long getThresholdInMillis() {
        return this.fThresholdInMillis;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        Assertion.wilyAssert(false);
        String traceType = root.getParameterValue("Trace Type");
        if (traceType != null && !traceType.equals("Normal")) {
            return false;
        }
        return root.getDuration() >= this.fThresholdInMillis;
    }

    public boolean shouldCollect(Map parameters) {
        return true;
    }

    public static int getFilterType() {
        return 1;
    }

    public int ITransactionTraceFilter_getFilterType() {
        return ThresholdTransactionTraceFilter.getFilterType();
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Threshold_Filter_Description_Message", String.valueOf(this.getThresholdInMillis()));
    }

    public static ThresholdTransactionTraceFilter read(DataInput in) throws IOException {
        ThresholdTransactionTraceFilter filter = new ThresholdTransactionTraceFilter();
        filter.readInternal(in);
        return filter;
    }

    public int hashCode() {
        long threshold = this.getThresholdInMillis();
        return (int)(threshold ^ threshold >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == ThresholdTransactionTraceFilter.class) {
            ThresholdTransactionTraceFilter filter = (ThresholdTransactionTraceFilter)obj;
            return this.getThresholdInMillis() == filter.getThresholdInMillis();
        }
        return false;
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    public void writeInternal(DataOutput out) throws IOException {
        out.writeLong(this.fThresholdInMillis);
    }

    private void readInternal(DataInput in) throws IOException {
        this.fThresholdInMillis = in.readLong();
    }

    public String toString() {
        return "[threshold = " + this.getThresholdInMillis() + "ms]";
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        long thresholdTimeMillis = this.getThresholdInMillis();
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Threshold_Status_Bar_Text_Millis_Message", Long.toString(thresholdTimeMillis));
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        long thresholdTimeMillis = this.getThresholdInMillis();
        return localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Threshold_Status_Bar_Text_Millis_Message", Long.toString(thresholdTimeMillis));
    }

    public boolean isHeadFilter() {
        return false;
    }

    public boolean ITailParameterTransactionTraceFilter_passesFilter(Map parameters) {
        Assertion.wilyAssert(false);
        Long thresholdValue = (Long)parameters.get("introscope.transactiontrace.threshold.key");
        if (thresholdValue != null) {
            return thresholdValue >= this.fThresholdInMillis;
        }
        return false;
    }
}

