/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace.websphere;

import com.wily.introscope.spec.server.transactiontrace.ACrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.introscope.spec.server.transactiontrace.ICrossProcessData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WebSphereCrossProcessData
extends ACrossProcessData
implements ICrossProcessData {
    private String correlationID;
    private int sequenceNo;
    private boolean markedForReporting = false;
    private static WebSphereWorkAreaReflectionHelper sHelper = new WebSphereWorkAreaReflectionHelper();
    private static final String kWorkAreaName = "com.wily.introscope.transactiontrace.WorkAreaName";

    private WebSphereCrossProcessData(CrossProcessObject cpObj) {
        this.correlationID = cpObj.guid;
        this.sequenceNo = cpObj.seqNo;
        this.markedForReporting = cpObj.isMarked;
    }

    public static WebSphereCrossProcessData getCurrentCrossProcessData(boolean create, IModuleFeedbackChannel feedback) {
        WebSphereCrossProcessData result = null;
        CrossProcessObject obj = sHelper.getCrossProcessObject(create, feedback);
        if (obj != null) {
            result = new WebSphereCrossProcessData(obj);
        }
        return result;
    }

    public static WebSphereCrossProcessData createCrossProcessData(IModuleFeedbackChannel feedback) {
        WebSphereCrossProcessData result = null;
        CrossProcessObject obj = new CrossProcessObject(GUIDGenerator.getInstance().generateKey(), 0, false);
        if (sHelper.setCrossProcessObject(obj, feedback)) {
            result = new WebSphereCrossProcessData(obj);
        }
        return result;
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public int getSequence() {
        return this.sequenceNo;
    }

    public void incrementCrossProcessData(ICrossProcessData currentData, IModuleFeedbackChannel feedback) {
        CrossProcessObject newObj = new CrossProcessObject(currentData.getCorrelationID(), currentData.getSequence() + 1, currentData.isMarkedForSympatheticCrossJVMTracing());
        sHelper.setCrossProcessObject(newObj, feedback);
    }

    public void decrementCrossProcessData(ICrossProcessData currentData, IModuleFeedbackChannel feedback) {
        CrossProcessObject newObj = new CrossProcessObject(currentData.getCorrelationID(), currentData.getSequence() - 1, currentData.isMarkedForSympatheticCrossJVMTracing());
        if (newObj.seqNo < 0) {
            sHelper.removeCrossProcessObject(feedback);
        } else {
            sHelper.setCrossProcessObject(newObj, feedback);
        }
    }

    public boolean isMarkedForSympatheticCrossJVMTracing() {
        return this.markedForReporting;
    }

    public void markForSympatheticCrossJVMTracing(ICrossProcessData currentData, IModuleFeedbackChannel feedback) {
        CrossProcessObject newObj = new CrossProcessObject(currentData.getCorrelationID(), currentData.getSequence(), true);
        sHelper.setCrossProcessObject(newObj, feedback);
        this.markedForReporting = true;
    }

    public int getReportingMark() {
        return this.markedForReporting ? 1 : 0;
    }

    public String toString() {
        return "[WebSphereCrossProcessData: corID=" + this.getCorrelationID() + ", seq=" + this.getSequence() + "]";
    }

    private static class CrossProcessObject
    implements Serializable {
        int seqNo;
        String guid;
        boolean isMarked;
        private static final long serialVersionUID = 6362926373496594148L;

        CrossProcessObject(String corrID, int sequenceNo, boolean mark) {
            this.guid = corrID;
            this.seqNo = sequenceNo;
            this.isMarked = mark;
        }

        public String toString() {
            return "[CrossProcessObject: corID=" + this.guid + ", seq=" + this.seqNo + "]";
        }
    }

    private static class WebSphereWorkAreaReflectionHelper {
        private Method getMethod;
        private Method setMethod;
        private Method beginMethod;
        private Method completeMethod;
        private Method removeMethod;
        private boolean valid = true;
        private static final String kGetMethodName = "get";
        private static final Class[] kGetMethodSignature = new Class[]{String.class};
        private static final String kSetMethodName = "set";
        private static final Class[] kSetMethodSignature = new Class[]{String.class, Serializable.class};
        private static final String kBeginMethodName = "begin";
        private static final Class[] kBeginMethodSignature = kGetMethodSignature;
        private static final String kCompleteMethodName = "complete";
        private static final Class[] kCompleteMethodSignature = new Class[0];
        private static final String kRemoveMethodName = "remove";
        private static final Class[] kRemoveMethodSignature = kGetMethodSignature;
        private static final String kPropertyKey = "com.wily.introscope.spec.server.transactiontrace.websphere.WorkAreaPropertyKey";

        WebSphereWorkAreaReflectionHelper() {
        }

        private Object getWorkArea() throws NoSuchMethodException {
            Object result = null;
            InitialContext jndi = null;
            try {
                jndi = new InitialContext();
                result = jndi.lookup("java:comp/websphere/UserWorkArea");
                if (result != null) {
                    Class<?> userWorkAreaClass = result.getClass();
                    this.getMethodObjects(userWorkAreaClass);
                    this.valid = true;
                }
            }
            catch (NamingException namingException) {}
            return result;
        }

        private void getMethodObjects(Class workAreaClass) throws NoSuchMethodException {
            if (this.getMethod == null) {
                this.getMethod = workAreaClass.getMethod(kGetMethodName, kGetMethodSignature);
            }
            if (this.setMethod == null) {
                this.setMethod = workAreaClass.getMethod(kSetMethodName, kSetMethodSignature);
            }
            if (this.beginMethod == null) {
                this.beginMethod = workAreaClass.getMethod(kBeginMethodName, kBeginMethodSignature);
            }
            if (this.completeMethod == null) {
                this.completeMethod = workAreaClass.getMethod(kCompleteMethodName, kCompleteMethodSignature);
            }
            if (this.removeMethod == null) {
                this.removeMethod = workAreaClass.getMethod(kRemoveMethodName, kRemoveMethodSignature);
            }
        }

        CrossProcessObject getCrossProcessObject(boolean create, IModuleFeedbackChannel feedback) {
            CrossProcessObject result = null;
            try {
                Object[] args;
                Object workAreaObj = this.getWorkArea();
                if (workAreaObj != null && (result = (CrossProcessObject)this.getMethod.invoke(workAreaObj, args = new Object[]{kPropertyKey})) == null && create) {
                    Object[] beginArgs = new Object[]{WebSphereCrossProcessData.kWorkAreaName};
                    this.beginMethod.invoke(workAreaObj, beginArgs);
                    result = new CrossProcessObject(GUIDGenerator.getInstance().generateKey(), 0, false);
                    Object[] setArgs = new Object[]{kPropertyKey, result};
                    this.setMethod.invoke(workAreaObj, setArgs);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("Unable to access the WebSphere work area service: " + t.toString());
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            return result;
        }

        boolean setCrossProcessObject(CrossProcessObject cpData, IModuleFeedbackChannel feedback) {
            boolean result = false;
            try {
                Object workAreaObj = this.getWorkArea();
                if (workAreaObj != null) {
                    Object[] beginArgs = new Object[]{WebSphereCrossProcessData.kWorkAreaName};
                    this.beginMethod.invoke(workAreaObj, beginArgs);
                    Object[] setArgs = new Object[]{kPropertyKey, cpData};
                    this.setMethod.invoke(workAreaObj, setArgs);
                    result = true;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("Unable to access the WebSphere work area service: " + t.toString());
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            return result;
        }

        boolean removeCrossProcessObject(IModuleFeedbackChannel feedback) {
            boolean result = false;
            try {
                Object workAreaObj = this.getWorkArea();
                if (workAreaObj != null) {
                    Object[] removeArgs = new Object[]{kPropertyKey};
                    this.removeMethod.invoke(workAreaObj, removeArgs);
                    Object[] completeArgs = new Object[]{};
                    this.completeMethod.invoke(workAreaObj, completeArgs);
                    result = true;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("Unable to access the WebSphere work area service: " + t.toString());
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            return result;
        }

        boolean isValid() {
            return this.valid;
        }
    }
}

