/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.concurrent;

import com.wily.util.feedback.IModuleFeedbackChannel;

public class DebuggableQueue {
    private static final int kDefaultLogDropInterval = 250;
    private static final int kDefaultLogGrowthInterval = 250;
    private static final int kDefaultLogShrinkInterval = 250;
    private IModuleFeedbackChannel fFeedback;
    protected String fQueueName;
    private int fDropCount;
    private boolean fLogDropsEnabled;
    private int fLogDropsInterval;
    private String fLogDropsMessage;
    private boolean fLogGrowthEnabled;
    private int fLogGrowthLastReportedSize;
    private int fLogGrowthInterval;
    private String fLogGrowthMessage;
    private boolean fLogShrinkEnabled;
    private int fLogShrinkInterval;
    private String fLogShrinkMessage;
    private int fLogShrinkLastReportedSize;

    protected DebuggableQueue(String queueName, IModuleFeedbackChannel feedback) {
        this.fFeedback = feedback;
        this.fQueueName = queueName;
        this.fLogDropsEnabled = false;
        this.fLogDropsInterval = 250;
        this.fDropCount = 0;
        this.fLogGrowthEnabled = false;
        this.fLogGrowthLastReportedSize = -1;
        this.fLogGrowthInterval = 0;
        this.fLogShrinkEnabled = false;
        this.fLogShrinkInterval = 0;
        this.fLogShrinkLastReportedSize = -1;
    }

    public synchronized void setName(String name) {
        this.fQueueName = name;
    }

    public void IExecutionQueue_setQueueDebuggingFeature(String whichFeature, String logMessage, Object parameter) {
        if (whichFeature.equals("com.wily.util.concurrent.IExecutionQueue.log.drops")) {
            this.setLogDrops(logMessage, parameter);
        } else if (whichFeature.equals("com.wily.util.concurrent.IExecutionQueue.log.growth")) {
            this.setLogGrowth(logMessage, parameter);
        } else if (whichFeature.equals("com.wily.util.concurrent.IExecutionQueue.log.shrink")) {
            this.setLogShrink(logMessage, parameter);
        }
    }

    private synchronized void setLogGrowth(String message, Object parameter) {
        int growthInterval = (Integer)parameter;
        this.fLogGrowthEnabled = true;
        this.fLogGrowthMessage = message == null ? "growth interval: " : message;
        this.fLogGrowthInterval = growthInterval == 0 ? 250 : growthInterval;
        this.fFeedback.info(this.fQueueName + " configured \"" + this.fLogGrowthMessage + "\" to " + this.fLogGrowthInterval);
    }

    private synchronized void setLogShrink(String message, Object parameter) {
        int shrinkInterval = (Integer)parameter;
        this.fLogShrinkEnabled = true;
        this.fLogShrinkMessage = message == null ? "shrink interval: " : message;
        this.fLogShrinkInterval = shrinkInterval == 0 ? 250 : shrinkInterval;
        this.fFeedback.info(this.fQueueName + " configured \"" + this.fLogShrinkMessage + "\" to " + this.fLogShrinkInterval);
    }

    private synchronized void setLogDrops(String message, Object parameter) {
        int dropInterval = (Integer)parameter;
        this.fLogDropsEnabled = true;
        this.fLogDropsMessage = message == null ? "drop total: " : message;
        this.fLogDropsInterval = dropInterval == 0 ? 250 : dropInterval;
        this.fFeedback.info(this.fQueueName + " configured \"" + this.fLogDropsMessage + "\" to " + this.fLogDropsInterval);
    }

    protected void logGrowth(int queueSize) {
        if (this.fLogGrowthEnabled && queueSize % this.fLogGrowthInterval == 0 && queueSize != this.fLogGrowthLastReportedSize) {
            this.fLogGrowthLastReportedSize = queueSize;
            this.fFeedback.info(this.fQueueName + " " + this.fLogGrowthMessage + " " + queueSize);
        }
    }

    protected void logShrink(int queueSize) {
        if (this.fLogShrinkEnabled) {
            int currentSize = queueSize;
            if (currentSize % this.fLogShrinkInterval == 0 && currentSize != this.fLogShrinkLastReportedSize) {
                this.fLogShrinkLastReportedSize = currentSize;
                this.fFeedback.info(this.fQueueName + " " + this.fLogShrinkMessage + " " + currentSize);
            }
            if (currentSize == 0) {
                this.fLogGrowthLastReportedSize = 0;
            }
        }
    }

    protected final void logDroppedCommand(Runnable command) {
        ++this.fDropCount;
        if (this.fLogDropsEnabled && this.fDropCount % this.fLogDropsInterval == 0) {
            this.fFeedback.info(this.fQueueName + " " + this.fLogDropsMessage + " " + this.fDropCount);
        }
    }
}

