/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.validate.ValidationException;

public final class IdentifyTwoFlagUnionAsAggregateFlagDirective
extends ADirective {
    private final FlagName fFlagName1;
    private final FlagName fFlagName2;
    private final FlagName fAggregateFlagName;

    public IdentifyTwoFlagUnionAsAggregateFlagDirective(String source, int lineNumber, FlagName flagName1, FlagName flagName2, FlagName aggregateFlagName) {
        super(source, lineNumber);
        this.fFlagName1 = flagName1;
        this.fFlagName2 = flagName2;
        this.fAggregateFlagName = aggregateFlagName;
    }

    private void validateParameters(CompilerSettingsBuilder builder) throws ValidationException {
        String lineNumberStr = "" + this.getLineNumber();
        TracerGroupBuilder aflag = builder.getTracerGroupBuilder(this.getAggregateFlagName());
        if (aflag.isAggregate()) {
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Already_Aggregate_Flag_Key", this.getAggregateFlagName().toString(), this.getSource(), lineNumberStr));
        }
    }

    private FlagName getFlagName1() {
        return this.fFlagName1;
    }

    private FlagName getFlagName2() {
        return this.fFlagName2;
    }

    private FlagName getAggregateFlagName() {
        return this.fAggregateFlagName;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) throws ValidationException {
        this.validateParameters(builder);
        TracerGroupBuilder flag1 = builder.getTracerGroupBuilder(this.getFlagName1());
        TracerGroupBuilder flag2 = builder.getTracerGroupBuilder(this.getFlagName2());
        TracerGroupBuilder aggregateFlag = builder.getTracerGroupBuilder(this.getAggregateFlagName());
        aggregateFlag.setOperator(2);
        aggregateFlag.addFlagDependency(flag1);
        aggregateFlag.addFlagDependency(flag2);
        flag1.setSource(this.getSource());
        flag2.setSource(this.getSource());
        aggregateFlag.setSource(this.getSource());
    }
}

