/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGStackMapFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfoArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGChopFrame
extends DGStackMapFrame {
    private int fLocalsChopped;
    public static final int kFrameTagBase = 248;
    public static final int kFrameTagMax = 250;
    private static final int kFrameTagOffset = 251;
    private static final int kFrameSize = 3;

    public DGChopFrame(DataInputStream data, int frameType, int prevOffset) throws IOException {
        super(prevOffset);
        this.fLocalsChopped = 251 - frameType;
        int offsetDelta = data.readUnsignedShort();
        this.setOffsetDelta(offsetDelta);
    }

    public int getLocalsChopped() {
        return this.fLocalsChopped;
    }

    public String toString() {
        return "Chop(offset=" + this.getOffset() + ", delta=" + this.getOffsetDelta() + ", chopped=" + this.getLocalsChopped() + ")";
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(251 - this.fLocalsChopped);
        out.writeShort(this.getOffsetDelta());
    }

    public int size() {
        return 3;
    }

    protected DGVerificationTypeInfoArray adjustLocals(DGVerificationTypeInfoArray locals) {
        return new DGVerificationTypeInfoArray(locals, this.fLocalsChopped);
    }

    protected DGVerificationTypeInfoArray adjustStack(DGVerificationTypeInfoArray stack) {
        return new DGVerificationTypeInfoArray(0);
    }

    protected boolean updateUninitializedTypeOffset(int pc, int delta) {
        return false;
    }
}

