/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICachedNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.StringUtils;

public final class DefaultNameFormatter
implements ICachedNameFormatter {
    public static final String kFormatSubstitutionPrefix = "{";
    public static final String kMethodPlaceHolder = "{method}";
    public static final String kClassNamePlaceHolder = "{classname}";
    public static final String kPackageNamePlaceHolder = "{packagename}";
    public static final String kNamespaceNamePlaceHolder = "{namespacename}";
    public static final String kPackageAndClassNamePlaceHolder = "{packageandclassname}";
    public static final String kNamespaceAndClassNamePlaceHolder = "{namespaceandclassname}";
    public static final String kAssemblyNamePlaceHolder = "{assemblyname}";
    public static final String kFullClassNamePlaceHolder = "{fullclassname}";

    public DefaultNameFormatter() {
    }

    public DefaultNameFormatter(IAgent agent) {
    }

    public final String INameFormatter_format(String name, InvocationData data) {
        return this.ICachedNameFormatter_format(name, data.getProbeInformation().getProbeIdentification(), data.getInvocationObject());
    }

    public final String ICachedNameFormatter_format(String name, ProbeIdentification probe, Object sampleTracedObject) {
        if (name != null) {
            if (name.indexOf(kClassNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kClassNamePlaceHolder, probe.getRuntimeSimpleClassName());
            }
            if (name.indexOf(kPackageNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kPackageNamePlaceHolder, DefaultNameFormatter.getRuntimePackageNameForFormatting(probe));
            }
            if (name.indexOf(kNamespaceNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kNamespaceNamePlaceHolder, DefaultNameFormatter.getRuntimeNamespaceNameForFormatting(probe));
            }
            if (name.indexOf(kPackageAndClassNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kPackageAndClassNamePlaceHolder, probe.getRuntimePackageAndClassName());
            }
            if (name.indexOf(kNamespaceAndClassNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kNamespaceAndClassNamePlaceHolder, probe.getRuntimePackageAndClassName());
            }
            if (name.indexOf(kMethodPlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kMethodPlaceHolder, probe.getProbeMethodName());
            }
            if (name.indexOf(kAssemblyNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kAssemblyNamePlaceHolder, DefaultNameFormatter.getRuntimeContainerNameForFormatting(probe));
            }
            if (name.indexOf(kFullClassNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kFullClassNamePlaceHolder, probe.getRuntimeFullClassName());
            }
        }
        return name;
    }

    private static String getRuntimePackageNameForFormatting(ProbeIdentification probe) {
        String runtimePackage = probe.getRuntimePackageName();
        if (runtimePackage == null || runtimePackage.length() == 0) {
            return "<Unnamed Package>";
        }
        return runtimePackage;
    }

    private static String getRuntimeNamespaceNameForFormatting(ProbeIdentification probe) {
        String runtimePackage = probe.getRuntimePackageName();
        if (runtimePackage == null || runtimePackage.length() == 0) {
            return "<Unnamed Namespace>";
        }
        return runtimePackage;
    }

    private static String getRuntimeContainerNameForFormatting(ProbeIdentification probe) {
        String runtimeContainer = probe.getRuntimeContainerName();
        if (runtimeContainer == null || runtimeContainer.length() == 0) {
            return "<Unknown Assembly>";
        }
        return runtimeContainer;
    }
}

