/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerService;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.IntelligentInstrumentationThreadLocalObject;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DownstreamTransactionHarvester {
    private static String AUTO_TRIGGER_CRITERIA_KEY = "Autotrace Trigger Criteria";
    private static String AUTO_TRIGGER_CRITERIA_VALUE = "Cross Process Trigger";
    private HighPerformanceTransactionCache highPerformanceCache = HighPerformanceTransactionCache.getInstance();

    public void sendTrace(String transactionGUID) {
        HashMap TcdHash = new HashMap();
        this.createAndSendTCD(TcdHash, transactionGUID);
    }

    public static void validateTransactionFromIntelligentInstrumentation(TransactionComponentData root, TransactionComponentData parent) {
        int numChildren;
        if (parent != null) {
            root.fixTimingData(parent);
        }
        if (root.getParameterValue("Total Methods") != null) {
            root.getParameters().remove("Total Methods");
        }
        if ((numChildren = root.getSubNodeCount()) > 0) {
            TransactionComponentData[] children = root.getSubNodes();
            int i = 0;
            while (i < numChildren) {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(children[i], root);
                ++i;
            }
        }
    }

    private void createAndSendTCD(HashMap TcdHash, String transactionGUID) {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] deepStacks = this.highPerformanceCache.getForTransactionTrace(transactionGUID);
        if (deepStacks == null) {
            SustainabilityMetricsHelper.reportNumberOfTracesMissedInCacheMetric(1);
            return;
        }
        boolean success = false;
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] highPerformanceIntelligenceStackElementVirtualStackArray = deepStacks;
        int n = deepStacks.length;
        int n2 = 0;
        while (n2 < n) {
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceIntelligenceStackElementVirtualStack = highPerformanceIntelligenceStackElementVirtualStackArray[n2];
            if (!highPerformanceIntelligenceStackElementVirtualStack.hasTraceBeenSent()) {
                TcdHash.clear();
                success = this.createAndSendTCDHelper(TcdHash, transactionGUID, highPerformanceIntelligenceStackElementVirtualStack);
                highPerformanceIntelligenceStackElementVirtualStack.setTraceSent();
            }
            highPerformanceIntelligenceStackElementVirtualStack.trySetInUse(false);
            ++n2;
        }
        if (success) {
            this.highPerformanceCache.addUpstreamGUID(transactionGUID);
        }
    }

    private boolean createAndSendTCDHelper(HashMap TcdHash, String transactionGUID, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
        int stackElements = deepStack.getStackElementCount();
        int i = 2;
        while (i <= stackElements) {
            IIntelligentInstrumentationStackElement stackElement = deepStack.getElementAt(i);
            DownstreamTransactionHarvester.createTcd(stackElement, TcdHash);
            ++i;
        }
        IntelligentInstrumentationThreadLocalObject tlObj = deepStack.sIntelligentThreadLocalObject;
        HashMap normalTcdHash = tlObj.fTopTCDElements;
        IIntelligentInstrumentationStackElement topElement = deepStack.getElementAt(1);
        int topElementInvID = topElement.getInvocationId();
        if (topElementInvID != -1) {
            TransactionComponentData normalRootElement = (TransactionComponentData)normalTcdHash.get(topElementInvID);
            deepStack.getElementAt(1).setTransactionComponentData(normalRootElement);
            TransactionComponentData bizDefComponent = null;
            if (!normalRootElement.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(normalRootElement)) != null) {
                HighPerformanceIntelligentStackHelper.realizeSubcomponent(bizDefComponent);
                bizDefComponent.getParameters().put("Trace Type", "Normal");
            }
            DownstreamTransactionHarvester.joinTCDSubTrees(deepStack);
            if (CrossProcessLogger.isDebugEnabled()) {
                CrossProcessLogger.logDebugMessage("Downstream agent sent the TT for: " + transactionGUID);
            }
            if (bizDefComponent != null) {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(bizDefComponent, null);
                bizDefComponent.getParameters().put(AUTO_TRIGGER_CRITERIA_KEY, AUTO_TRIGGER_CRITERIA_VALUE);
                HighPerformanceIntelligenceStackElement.getAgent().IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(bizDefComponent);
            } else {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(normalRootElement, null);
                normalRootElement.getParameters().put(AUTO_TRIGGER_CRITERIA_KEY, AUTO_TRIGGER_CRITERIA_VALUE);
                HighPerformanceIntelligenceStackElement.getAgent().IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(normalRootElement);
            }
            SustainabilityMetricsHelper.reportNumberOfTracesFromCacheMetric(1);
            DownStreamListenerService.tracesPerIntervalCount.getAndIncrement();
            return true;
        }
        return false;
    }

    private static void joinTCDSubTrees(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
        int stackElements = deepStack.getStackElementCount();
        IIntelligentInstrumentationStackElement rootElement = null;
        rootElement = deepStack.getElementAt(1);
        TransactionComponentData tcdRoot = rootElement.getTransactionComponentData();
        rootElement.reassignTcdCursor(null);
        int i = 2;
        while (i <= stackElements) {
            IIntelligentInstrumentationStackElement stackElement = deepStack.getElementAt(i);
            stackElement.joinTCDSubTreeWithParent();
            ++i;
        }
        rootElement.reassignTcdCursor(tcdRoot);
    }

    private static void createTcd(IIntelligentInstrumentationStackElement currElement, Map TcdMap) {
        ITransactionElement txElement;
        IIntelligentInstrumentationStackElement currentElement = currElement;
        int invocationId = currentElement.getInvocationId();
        if (invocationId != -1 && (txElement = currentElement.getLastTransactionElement()) != null) {
            ArrayList<ITransactionElement> elements = new ArrayList<ITransactionElement>();
            while (txElement != null && txElement != currentElement.getFirstTransactionElement()) {
                elements.add(txElement);
                txElement = txElement.getParent();
            }
            elements.add(currentElement.getFirstTransactionElement());
            int i = elements.size();
            while (i > 0) {
                txElement = (ITransactionElement)elements.get(i - 1);
                if (txElement instanceof BlameTransactionElement) {
                    DownstreamTransactionHarvester.createTcd(currentElement, ((BlameTransactionElement)txElement).getResourceName());
                    ((BlameTransactionElement)txElement).getResourceName();
                } else {
                    DownstreamTransactionHarvester.decorateComponentWithParameters(currentElement);
                }
                --i;
            }
            return;
        }
        DownstreamTransactionHarvester.decorateComponentWithParameters(currentElement);
    }

    private static void createTcd(IIntelligentInstrumentationStackElement currentElement, String resourceName) {
        String componentName = resourceName != null ? resourceName : currentElement.getElementName();
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(componentName, currentElement.getStartTime(), currentElement.getDuration());
        currentElement.setTransactionComponentData(component);
        Map parameters = component.getParameters();
        parameters.put("Method", currentElement.getProbeMethodName());
        parameters.put("Method Descriptor", currentElement.getProbeMethodDescriptor());
        parameters.put("Class", currentElement.getProbeClassName());
        if (currentElement.getInvocationId() == -1) {
            parameters.put("Method Score Level", currentElement.getProbeMethodScoreLevel());
        }
        parameters.put("Trace Type", "Normal");
    }

    private static void decorateComponentWithParameters(IIntelligentInstrumentationStackElement currElement) {
        IIntelligentInstrumentationStackElement currentElement = currElement;
        String componentName = currentElement.getElementName();
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(componentName, currentElement.getStartTime(), currentElement.getDuration());
        currentElement.setTransactionComponentData(component);
        Map parameters = component.getParameters();
        parameters.put("Method", currentElement.getProbeMethodName());
        parameters.put("Method Descriptor", currentElement.getProbeMethodDescriptor());
        parameters.put("Class", currentElement.getProbeClassName());
        if (currentElement.getInvocationId() == -1) {
            parameters.put("Method Score Level", currentElement.getProbeMethodScoreLevel());
            parameters.put("Is Unmonitored", "True");
        }
        parameters.put("Trace Type", "Normal");
    }
}

