/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.io.AddressHostNameHelper;
import com.wily.introscope.agent.trace.io.ISocketNameFormatter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.util.WilyStringBuilder;
import java.net.InetSocketAddress;

public abstract class ACachedSocketNameFormatter
extends ASocketNameFormatter
implements ISocketNameFormatter {
    public ACachedSocketNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String ISocketNameFormatter_format(String name, InvocationData data, int socketMetricPosition) {
        String result = null;
        try {
            result = this.existsCachedResource(socketMetricPosition, data);
            if (result == null) {
                ASocketNameFormatter.ResourceAndAddress socketInfo = this.getResourceAndAddress(data);
                if (name != null && socketInfo != null) {
                    this.initializeCachedResource(data, socketInfo);
                    WilyStringBuilder bldr = this.buildMetric(name, socketInfo);
                    String bldrString = bldr.toString();
                    this.updateCachedResource(name, data, bldrString, socketMetricPosition);
                    result = this.calculateMetricNameFromBuilderString(bldrString, name);
                } else if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug(this.fModule, "Name and/or SocketInfo null: name=" + name + ", socketInfo=" + socketInfo + ", invocation object=" + (data != null ? data.getInvocationObject().toString() : "null"));
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error(this.fModule, "An error occurred formatting socket name.");
                this.fFeedback.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    private final String existsCachedResource(int position, InvocationData data) {
        SocketFormatMetricsCache cachedResource = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
        if (cachedResource != null) {
            String result = cachedResource.getFormattedMetrics(position);
            return result;
        }
        return null;
    }

    protected abstract String calculateMetricNameFromBuilderString(String var1, String var2);

    protected abstract void updateCachedResource(String var1, InvocationData var2, String var3, int var4);

    private void initializeCachedResource(InvocationData data, ASocketNameFormatter.ResourceAndAddress socketInfo) {
        InetSocketAddress address;
        SocketFormatMetricsCache cachedResource = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
        if (cachedResource == null && (address = socketInfo.getAddress()) != null) {
            cachedResource = new SocketFormatMetricsCache(AddressHostNameHelper.getHostName(address), address.getAddress().getHostAddress(), address.getPort());
            data.setPartialSocketFormattedName(cachedResource);
        }
    }

    protected abstract String getFormattableMetric(String var1, String var2);

    private final WilyStringBuilder buildMetric(String name, ASocketNameFormatter.ResourceAndAddress socketInfo) {
        String resourceName = socketInfo.getResourceName();
        InetSocketAddress address = socketInfo.getAddress();
        WilyStringBuilder bldr = (WilyStringBuilder)NameFormatterBuilder.get();
        bldr.setString(this.getFormattableMetric(resourceName, name));
        int i = bldr.indexOf(kHostNamePlaceHolder);
        if (i >= 0) {
            bldr = bldr.replace(i, i + kHostNamePlaceHolder.length, AddressHostNameHelper.getHostName(address));
        }
        if ((i = bldr.indexOf(kPortPlaceHolder)) >= 0) {
            bldr = bldr.replace(i, i + kPortPlaceHolder.length, Integer.toString(address.getPort()));
        }
        return bldr;
    }
}

