/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.transactiontrace.ExtensionsBlameStackAllocator;
import com.wily.introscope.agent.transactiontrace.ITransactionEnvironment;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;

public class ExtensionsTraceController
implements ITransactionTraceListener {
    private final ITransactionTraceListener fListener;
    private final MetricRecordingAdministrator fAdministrator;
    private final IntervalHeartbeat fHeartbeat;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ITransactionEnvironment fTransactionEnv;
    private final IAgent fAgent;
    private final ExtensionsBlameStackAllocator fAllocator;
    private static final int kCurrentBlameStackPluginVersion = 1;
    private static final String kExpectedExtensionPluginName = "MapTracingStack";
    private boolean fWasAllocatorRegistered = false;

    public ExtensionsTraceController(ITransactionTraceListener listener, IAgent agent, MetricRecordingAdministrator administrator, ComponentTracer componentTracer, IntervalHeartbeat heartbeat, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.fLocalizer = localizer;
        this.fAdministrator = administrator;
        this.fHeartbeat = heartbeat;
        this.fListener = listener;
        this.fFeedback = feedback;
        this.fTransactionEnv = componentTracer;
        this.fAgent = agent;
        this.fAllocator = new ExtensionsBlameStackAllocator(feedback, localizer, this, agent);
    }

    public ExtensionsBlameStackAllocator getBlameStackAllocator() {
        return this.fAllocator;
    }

    public boolean isTraceExtensionEnabled() {
        if (this.fAllocator != null) {
            return this.fAllocator.isTraceExtensionEnabled();
        }
        return false;
    }

    private Class loadExtensionBlameStackWithPluginType(String pluginType) {
        try {
            ExtensionAdministrator extensionAdministrator = this.fAgent.IAgent_getExtensionAdministrator();
            Assertion.wilyAssert(false);
            IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(pluginType);
            int i = 0;
            while (i < plugins.length) {
                Class pluginClass;
                if (plugins[i].IPlugin_getName().equalsIgnoreCase(kExpectedExtensionPluginName) && (pluginClass = ExtensionUtilities.loadEntryPointClass(this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer(), plugins[i], 1, IBlameStack.class)) != null) {
                    return pluginClass;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error("ExtensionsTraceController: unable to instantiate normalizer plugin extension " + e.getMessage());
            this.fAgent.IAgent_getModuleFeedback().debug(e);
        }
        return null;
    }

    public void registerBlameStackWithPluginType(String pluginType) {
        if (!this.fWasAllocatorRegistered) {
            Class extensionBlameStack = this.loadExtensionBlameStackWithPluginType(pluginType);
            if (extensionBlameStack != null) {
                this.fAllocator.registerExtensionBlameStack(extensionBlameStack);
                this.fAgent.IAgent_getModuleFeedback().info("ExtensionsTraceController: call to register extension of plugintype " + pluginType + " succeeded ");
                this.fAgent.IAgent_getComponentTracer().addBlameStackAllocator(this.fAllocator);
                this.fWasAllocatorRegistered = true;
            } else {
                this.fAgent.IAgent_getModuleFeedback().error("ExtensionsTraceController: call to register extension of plugintype " + pluginType + " failed ");
            }
        } else {
            this.fAgent.IAgent_getModuleFeedback().debug("ExtensionsTraceController: registerBlameStack not registering since we already have a pre-registered allocator");
        }
    }

    public void ITransactionTraceListener_reportTransaction(TransactionComponentData root) {
        this.fListener.ITransactionTraceListener_reportTransaction(root);
    }
}

