/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.agent.beans.dynamicinstrumentation;

import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DynamicDirectivesResult
extends DynamicInstrumentationResult {
    private Collection dynamicDirectiveCollection;
    private Collection checkedDynamicDirectiveCollection;
    private List pbd = new ArrayList();
    private String label;

    public DynamicDirectivesResult() {
    }

    public DynamicDirectivesResult(DynamicDirectivesResult input) {
        this.importAll(input);
    }

    public DynamicDirectivesResult(int status) {
        super(status);
    }

    public DynamicDirectivesResult(Integer status) {
        super(status);
    }

    public void importAll(DynamicDirectivesResult input) {
        super.importAll(input);
        this.setDynamicDirectiveCollection(input.getDynamicDirectiveCollection());
        this.setCheckdDynamicDirectiveCollection(input.getCheckedDynamicDirectiveCollection());
        this.pbd.addAll(input.getPbdLines());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dynamicDirectiveCollection = (Collection)in.readObject();
        this.checkedDynamicDirectiveCollection = (Collection)in.readObject();
        this.pbd = (List)in.readObject();
        this.label = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.dynamicDirectiveCollection);
        out.writeObject(this.checkedDynamicDirectiveCollection);
        out.writeObject(this.pbd);
        out.writeObject(this.label);
    }

    public DynamicInstrumentationResult setDynamicDirectiveCollection(Collection collection) {
        this.dynamicDirectiveCollection = collection;
        return this;
    }

    public Collection getDynamicDirectiveCollection() {
        return this.dynamicDirectiveCollection;
    }

    public void setCheckdDynamicDirectiveCollection(Collection checkedDynamicDirectiveCollection2) {
        this.checkedDynamicDirectiveCollection = checkedDynamicDirectiveCollection2;
    }

    public Collection getCheckedDynamicDirectiveCollection() {
        return this.checkedDynamicDirectiveCollection;
    }

    public void addPbdLine(String pbdText) {
        this.pbd.add(pbdText);
    }

    public void addPbdLines(List pbdLines) {
        this.pbd.addAll(pbdLines);
    }

    public List getPbdLines() {
        return this.pbd;
    }

    public void setPbdLine(String pbdLine) {
        this.pbd.clear();
        this.pbd.add(pbdLine);
    }

    public void setEmpty() {
        this.pbd.clear();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }
}

