/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetricPrefixParser;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.InternalException;
import com.wily.isengard.data.IIsengardReadResolve;
import com.wily.util.adt.CanonicalObjectPoolWithKey;
import com.wily.util.exception.UnexpectedExceptionError;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public final class AgentMetricPrefix
implements Externalizable,
IIsengardReadResolve,
CharSequence {
    public static final AgentMetricPrefix[] kEmptyAgentMetricPrefixArray = new AgentMetricPrefix[0];
    private static final long serialVersionUID = 6039670718848422688L;
    private AgentMetricPrefixParser fPathParser;
    private static volatile PoolCache cache = new DefaultPoolCache();
    private static Factory factory = new Factory();

    public static void setPoolCache(PoolCache newCache) {
        newCache.setFactory(factory);
        cache = newCache;
    }

    public static PoolCache getPoolCache() {
        return cache;
    }

    public AgentMetricPrefix() {
    }

    private AgentMetricPrefix(String pathString) throws BadlyFormedNameException {
        this.fPathParser = new AgentMetricPrefixParser(pathString);
    }

    private AgentMetricPrefix(AgentMetricPrefixParser parser) throws BadlyFormedNameException {
        this.fPathParser = parser;
    }

    public boolean isEmpty() {
        return this.fPathParser.isEmpty();
    }

    public String getPathURL() {
        return this.fPathParser.getEntireString();
    }

    public String getSegment(int index) {
        return this.fPathParser.getSegment(index);
    }

    public String getLastSegment() {
        return this.getSegment(this.getSegmentCount() - 1);
    }

    public int getSegmentCount() {
        return this.fPathParser.getSegmentCount();
    }

    public String getPrefixStringIncludingSegmentN(int n) {
        return this.fPathParser.getPrefixIncludingSegmentN(n);
    }

    public String getPrefixStringStartingWithSegmentN(int start) {
        return this.fPathParser.getSubSegment(start);
    }

    public AgentMetricPrefix getPrefixPathIncludingSegmentN(int n) {
        try {
            return AgentMetricPrefix.getAgentMetricPrefix(this.getPrefixStringIncludingSegmentN(n));
        }
        catch (BadlyFormedNameException bfne) {
            throw new InternalException(bfne);
        }
    }

    public AgentMetricPrefix getParentPrefix() {
        int segmentCount = this.getSegmentCount();
        if (segmentCount <= 1) {
            try {
                return AgentMetricPrefix.getAgentMetricPrefix("");
            }
            catch (BadlyFormedNameException e) {
                throw new InternalException(e);
            }
        }
        return this.getPrefixPathIncludingSegmentN(segmentCount - 2);
    }

    protected AgentMetricPrefixParser getPathParser() {
        return this.fPathParser;
    }

    public String toString() {
        return this.getPathURL();
    }

    public boolean startsWith(AgentMetricPrefix agentMetricPrefix) {
        boolean match = this.getSegmentCount() >= agentMetricPrefix.getSegmentCount() && this.getPrefixStringIncludingSegmentN(agentMetricPrefix.getSegmentCount() - 1).equals(agentMetricPrefix.getPathURL());
        return match;
    }

    public boolean isDirectParentOf(AgentMetricPrefix child) {
        if (child.getSegmentCount() != this.getSegmentCount() + 1) {
            return false;
        }
        int i = 0;
        while (i < this.getSegmentCount()) {
            if (!child.getSegment(i).equals(this.getSegment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object readResolve() throws ObjectStreamException {
        return AgentMetricPrefix.getFromWireData(this.fPathParser);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.fPathParser.smartWriteExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fPathParser = AgentMetricPrefixParser.smartReadExternalESEPathParser(in);
    }

    static String computeAggregatePathString(AgentMetricPrefix prefixPath, AgentMetricPrefix suffixPath) {
        if (prefixPath.isEmpty()) {
            return suffixPath.getPathURL();
        }
        if (suffixPath.isEmpty()) {
            return prefixPath.getPathURL();
        }
        return String.valueOf(prefixPath.getPathURL()) + "|" + suffixPath.getPathURL();
    }

    static String computeAggregatePathString(AgentMetricPrefix prefixPath, String suffixString) {
        if (prefixPath.isEmpty()) {
            return suffixString;
        }
        if (suffixString == null || suffixString.length() == 0) {
            return prefixPath.getPathURL();
        }
        return String.valueOf(prefixPath.getPathURL()) + "|" + suffixString;
    }

    static String computeAggregatePathString(String prefixString, AgentMetricPrefix suffixPath) {
        if (prefixString == null || prefixString.length() == 0) {
            return suffixPath.getPathURL();
        }
        if (suffixPath.isEmpty()) {
            return prefixString;
        }
        return String.valueOf(prefixString) + "|" + suffixPath.getPathURL();
    }

    private static AgentMetricPrefix getFromWireData(AgentMetricPrefixParser parser) throws InvalidObjectException {
        try {
            return AgentMetricPrefix.getAgentMetricPrefix(parser);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new InvalidObjectException("Bad ESEPath name");
        }
    }

    private static AgentMetricPrefix getFromCache(String pathURL) throws BadlyFormedNameException {
        return cache.getOrAddToCache(pathURL);
    }

    protected static AgentMetricPrefix getFromCache(AgentMetricPrefixParser pathParser) throws BadlyFormedNameException {
        return cache.getOrAddToCache(pathParser);
    }

    public static AgentMetricPrefix getRootAgentMetricPrefix() {
        try {
            return AgentMetricPrefix.getFromCache("");
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new UnexpectedExceptionError("Unable to get the root agent metric prefix");
        }
    }

    public static AgentMetricPrefix getAgentMetricPrefix(String pathString) throws BadlyFormedNameException {
        return AgentMetricPrefix.getFromCache(pathString);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(String[] stringArray) throws BadlyFormedNameException {
        return AgentMetricPrefix.getAgentMetricPrefix(stringArray, 0, stringArray.length);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(String[] stringArray, int startIndex, int count) throws BadlyFormedNameException {
        AgentMetricPrefixParser parser = new AgentMetricPrefixParser(stringArray, startIndex, count);
        return AgentMetricPrefix.getFromCache(parser);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefix path) {
        return path;
    }

    public static void verifyValidResource(String resourceName) throws BadlyFormedNameException {
        new AgentMetricPrefixParser(resourceName);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefix prefixPath, AgentMetricPrefix suffixPath) throws BadlyFormedNameException {
        AgentMetricPrefixParser parser = new AgentMetricPrefixParser(prefixPath, suffixPath);
        return AgentMetricPrefix.getFromCache(parser);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefix prefixPath, String suffixString) throws BadlyFormedNameException {
        AgentMetricPrefixParser parser = new AgentMetricPrefixParser(prefixPath, suffixString);
        return AgentMetricPrefix.getFromCache(parser);
    }

    private static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefixParser parser) throws BadlyFormedNameException {
        return AgentMetricPrefix.getFromCache(parser);
    }

    public char charAt(int index) {
        return this.fPathParser.charAt(index);
    }

    public int length() {
        return this.fPathParser.length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.fPathParser.subSequence(start, end);
    }

    /* synthetic */ AgentMetricPrefix(String string, AgentMetricPrefix agentMetricPrefix) throws BadlyFormedNameException {
        this(string);
    }

    /* synthetic */ AgentMetricPrefix(AgentMetricPrefixParser agentMetricPrefixParser, AgentMetricPrefix agentMetricPrefix) throws BadlyFormedNameException {
        this(agentMetricPrefixParser);
    }

    public static class DefaultPoolCache
    implements PoolCache {
        private CanonicalObjectPoolWithKey sPathCache = new CanonicalObjectPoolWithKey();

        public CanonicalObjectPoolWithKey getPathCache() {
            return this.sPathCache;
        }

        private AgentMetricPrefix lookupFromCacheNonSync(String pathURL) {
            return (AgentMetricPrefix)this.sPathCache.getCanonicalObject(pathURL);
        }

        private AgentMetricPrefix lookupFromCacheNonSync(AgentMetricPrefixParser pathParser) {
            return this.lookupFromCacheNonSync(pathParser.getEntireString());
        }

        private AgentMetricPrefix addToCacheNonSync(String pathURL, AgentMetricPrefix prefix) throws BadlyFormedNameException {
            return (AgentMetricPrefix)this.sPathCache.getCanonicalObject(pathURL, prefix);
        }

        private AgentMetricPrefix addToCacheNonSync(AgentMetricPrefixParser pathParser) throws BadlyFormedNameException {
            return (AgentMetricPrefix)this.sPathCache.getCanonicalObject(pathParser.getEntireString(), new AgentMetricPrefix(pathParser, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMetricPrefix getOrAddToCache(String pathURL) throws BadlyFormedNameException {
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = this.sPathCache;
            synchronized (canonicalObjectPoolWithKey) {
                AgentMetricPrefix result = this.lookupFromCacheNonSync(pathURL);
                if (result != null) {
                    return result;
                }
            }
            AgentMetricPrefix prefix = new AgentMetricPrefix(pathURL, null);
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey2 = this.sPathCache;
            synchronized (canonicalObjectPoolWithKey2) {
                if (this == cache) {
                    AgentMetricPrefix result = this.lookupFromCacheNonSync(pathURL);
                    if (result == null) {
                        result = this.addToCacheNonSync(pathURL, prefix);
                    }
                    return result;
                }
            }
            return cache.getOrAddToCache(pathURL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMetricPrefix getOrAddToCache(AgentMetricPrefixParser pathParser) throws BadlyFormedNameException {
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = this.sPathCache;
            synchronized (canonicalObjectPoolWithKey) {
                if (this == cache) {
                    AgentMetricPrefix result = this.lookupFromCacheNonSync(pathParser);
                    if (result == null) {
                        result = this.addToCacheNonSync(pathParser);
                    }
                    return result;
                }
            }
            return cache.getOrAddToCache(pathParser);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AgentMetricPrefix getOrAddToCache(AgentMetricPrefix agentMetricPrefix) throws BadlyFormedNameException {
            CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = this.sPathCache;
            synchronized (canonicalObjectPoolWithKey) {
                if (this == cache) {
                    String pathUrl = agentMetricPrefix.getPathParser().getEntireString();
                    AgentMetricPrefix result = this.lookupFromCacheNonSync(pathUrl);
                    if (result == null) {
                        result = this.addToCacheNonSync(pathUrl, agentMetricPrefix);
                    }
                    return result;
                }
            }
            return cache.getOrAddToCache(agentMetricPrefix);
        }

        public void setFactory(Factory factory) {
        }
    }

    public static class Factory {
        private Factory() {
        }

        public AgentMetricPrefix create(String pathURL) throws BadlyFormedNameException {
            return new AgentMetricPrefix(pathURL, null);
        }

        public AgentMetricPrefix create(AgentMetricPrefixParser pathParser) throws BadlyFormedNameException {
            return new AgentMetricPrefix(pathParser, null);
        }
    }

    public static interface PoolCache {
        public AgentMetricPrefix getOrAddToCache(String var1) throws BadlyFormedNameException;

        public AgentMetricPrefix getOrAddToCache(AgentMetricPrefixParser var1) throws BadlyFormedNameException;

        public AgentMetricPrefix getOrAddToCache(AgentMetricPrefix var1) throws BadlyFormedNameException;

        public void setFactory(Factory var1);
    }
}

