/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.stat.gatherer.ALongCombiningGatherer;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class LongFluctuatingCounterGatherer
extends ALongCombiningGatherer {
    private long fValue;
    private long fMinimum;
    private long fMaximum;

    public LongFluctuatingCounterGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    public long getLongValue() {
        return this.fValue;
    }

    public long getLongMinimum() {
        return this.fMinimum;
    }

    public long getLongMaximum() {
        return this.fMaximum;
    }

    protected void directSetLongValue(long value) {
        this.fValue = value;
    }

    protected void directSetLongMinimum(long minimum) {
        this.fMinimum = minimum;
    }

    protected void directSetLongMaximum(long maximum) {
        this.fMaximum = maximum;
    }

    public synchronized void setValue(long value) {
        this.setValueUnsync(value);
    }

    public synchronized void increment() {
        this.setValueUnsync(this.getLongValue() + 1L);
    }

    public synchronized void decrement() {
        this.setValueUnsync(this.getLongValue() - 1L);
    }

    public synchronized void add(long delta) {
        this.setValueUnsync(this.getLongValue() + delta);
    }

    public synchronized void subtract(long delta) {
        this.setValueUnsync(this.getLongValue() - delta);
    }

    protected void doAcceptAggregateLongTimeslicedValue(LongTimeslicedValue typedAggregate) {
        this.directSetLongValue(typedAggregate.getValue());
        this.syncAggregateBounds(typedAggregate);
        this.addToDataPointCount(typedAggregate.getDataPointCount());
    }

    private void setValueUnsync(long value) {
        this.directSetLongValue(value);
        this.syncSinglePointBounds(value);
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
    }

    protected void doResetCombiningGatherer(long when) {
        this.resetMinAndMax();
    }

    protected void doReinitializeCombiningGatherer() {
        this.directSetLongValue(0L);
        this.resetMinAndMax();
    }

    private void resetMinAndMax() {
        this.directSetLongMinimum(this.getLongValue());
        this.directSetLongMaximum(this.getLongValue());
    }
}

