/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.external.biz.util.KExternalBizConstants;
import com.wily.introscope.agent.external.biz.util.MutableInteger;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.properties.AttributeListing;

public class SinglePerIntervalCounter
extends ASingleMetricTracerFactory {
    private static final IUpdater kUpdater = UpdaterFactory.getIncreasingUpdater();
    private Boolean isFeatureOn = false;
    private static ThreadLocal stackDepthLocal = new ThreadLocal(){

        public Object initialValue() {
            return new MutableInteger();
        }
    };

    public SinglePerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.isFeatureOn = agent.IAgent_getComponentTracer().isAgentOldMode() ? Boolean.FALSE : Boolean.valueOf(this.getAgent().IAgent_getConfigurationManager().getProperty("introscope.agent.external.biz.enabled"));
    }

    public boolean ITracerFactory_isShutoff() {
        return this.isFeatureOn == false;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        data.storeWallClockStartTime();
        IBizTrx businessTransaction = (IBizTrx)data.get("BusinessTrxData");
        String pkey = this.getParameter("attributeKey");
        String pvalue = null;
        if (pkey != null && KExternalBizConstants.propertykeys.get(pkey) != null) {
            pvalue = (String)data.get(KExternalBizConstants.propertykeys.get(pkey));
        }
        if (businessTransaction == null || pvalue == null || "".equalsIgnoreCase(pvalue)) {
            data.setComponentNameAt(null, tracerIndex);
            return;
        }
        data.put("attributeKey", (Object)pkey);
        data.put("attributeValue", (Object)pvalue);
        super.ITracer_startTrace(tracerIndex, data);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
        if (data.getComponentNameAt(tracerIndex) == null) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        RepositoryFactory rf = new RepositoryFactory(this.getAgent().IAgent_getDataAccumulatorFactory(), this.fHighConcurrency);
        IRepository rep = rf.safeGetBizTrxLongIntervalCounterDataAccumulator(this.getComponentName(data), holder);
        return rep;
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        if (this.invocationPassesResultFilter((InvocationData)data)) {
            long startTime = data.getWallClockStartTime();
            int hashCode = data.hashCode();
            mh.getRepository().update(kUpdater, 1L, startTime, hashCode);
        }
    }
}

