/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.Map;

public class ObjectInputStreamWithLoader
extends ObjectInputStream {
    private final Map fRegisteredLoaders;

    public ObjectInputStreamWithLoader(InputStream in, Map registeredLoaders) throws IOException, StreamCorruptedException {
        super(in);
        this.fRegisteredLoaders = registeredLoaders;
    }

    private Class primitiveType(char type) {
        switch (type) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String classLoaderName = this.readUTF();
        String cname = classDesc.getName();
        if (!this.fRegisteredLoaders.containsKey(classLoaderName)) {
            String message = "Classloader \"" + classLoaderName + "\" is not registered. Object of type \"" + cname + "\" cannot be deserialized.";
            throw new ClassNotFoundException(message);
        }
        ClassLoader localLoader = (ClassLoader)this.fRegisteredLoaders.get(classLoaderName);
        try {
            if (cname.startsWith("[")) {
                Class<?> component;
                int dcount = 1;
                while (cname.charAt(dcount) == '[') {
                    ++dcount;
                }
                if (cname.charAt(dcount) == 'L') {
                    component = Class.forName(cname.substring(dcount + 1, cname.length() - 1), true, localLoader);
                } else {
                    if (cname.length() != dcount + 1) {
                        throw new ClassNotFoundException(cname);
                    }
                    component = this.primitiveType(cname.charAt(dcount));
                }
                int[] dim = new int[dcount];
                for (int i = 0; i < dcount; ++i) {
                    dim[i] = 0;
                }
                return Array.newInstance(component, dim).getClass();
            }
            return Class.forName(cname, true, localLoader);
        }
        catch (ClassNotFoundException e) {
            String message = "Object of type \"" + cname + "\" cannot be deserialized since it was not found in Classloader \"" + classLoaderName + "\".";
            throw new ClassNotFoundException(message);
        }
    }
}

