/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extensions.sqlagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ISqlNormalizer;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexSqlNormalizer
implements ISqlNormalizer {
    private static IAgent fAgent;
    private String fPatternRegex;
    private String fReplacementRegex;
    private static final String fRegexGroupPrefix = "introscope.agent.sqlagent.normalizer.regex";
    private static final String fRegexGroupKeys = "introscope.agent.sqlagent.normalizer.regex.keys";
    private static final String fRegexMatchFallThrough = "introscope.agent.sqlagent.normalizer.regex.matchFallThrough";
    private static final String fRegexCaseSensitiveSuffix = "caseSensitive";
    private static final String fPatternMatchSuffix = "pattern";
    private static final String fReplaceAllSuffix = "replaceAll";
    private static final String fReplaceFormatSuffix = "replaceFormat";
    private static final String fPropSeparator = ".";
    private static List fPatternMatchList;
    private static List fReplaceAllModeList;
    private static List fReplaceFormatList;
    private static List fIsMatchCaseSensitiveList;
    private static List fCompiledPatternList;
    private static boolean fShouldMatchFallThrough;
    private static String fGroupKeys;
    private static Object fLock;
    private static IConfigurationListener fListener;

    static {
        fPatternMatchList = new ArrayList();
        fReplaceAllModeList = new ArrayList();
        fReplaceFormatList = new ArrayList();
        fIsMatchCaseSensitiveList = new ArrayList();
        fCompiledPatternList = new ArrayList();
        fShouldMatchFallThrough = false;
        fLock = new Object();
        try {
            fAgent = AgentShim.getAgent();
            RegexSqlNormalizer.initializeProperties();
            RegexSqlNormalizer.initializeRegexGroups();
            fListener = new IConfigurationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onChange(IndexedProperties props) {
                    String changedGroupKeys;
                    boolean changedMatchFallThrough = props.getBooleanProperty(RegexSqlNormalizer.fRegexMatchFallThrough, false);
                    if (changedMatchFallThrough != fShouldMatchFallThrough) {
                        Object object = fLock;
                        synchronized (object) {
                            fShouldMatchFallThrough = changedMatchFallThrough;
                        }
                        fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property introscope.agent.sqlagent.normalizer.regex.matchFallThrough has changed ");
                    }
                    if ((changedGroupKeys = props.getTrimmedProperty(RegexSqlNormalizer.fRegexGroupKeys)) != null && changedGroupKeys.length() == 0) {
                        changedGroupKeys = null;
                    }
                    if (changedGroupKeys == null && fGroupKeys != null) {
                        Object object = fLock;
                        synchronized (object) {
                            fGroupKeys = changedGroupKeys;
                            RegexSqlNormalizer.reInitializeLists();
                        }
                        fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property introscope.agent.sqlagent.normalizer.regex.keys has changed ");
                        fAgent.IAgent_getModuleFeedback().warn("Statement Normalizer Extension: value of property introscope.agent.sqlagent.normalizer.regex.keys was not set ");
                    } else if (changedGroupKeys != null && fGroupKeys == null) {
                        Object object = fLock;
                        synchronized (object) {
                            fGroupKeys = changedGroupKeys;
                            RegexSqlNormalizer.reInitializeLists();
                            RegexSqlNormalizer.initializeRegexGroups();
                        }
                        fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property introscope.agent.sqlagent.normalizer.regex.keys has changed ");
                    } else if (changedGroupKeys != null && fGroupKeys != null) {
                        if (!changedGroupKeys.equals(fGroupKeys)) {
                            Object object = fLock;
                            synchronized (object) {
                                fGroupKeys = changedGroupKeys;
                                RegexSqlNormalizer.reInitializeLists();
                                RegexSqlNormalizer.initializeRegexGroups();
                            }
                            fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property introscope.agent.sqlagent.normalizer.regex.keys has changed ");
                        } else {
                            Object object = fLock;
                            synchronized (object) {
                                RegexSqlNormalizer.reEvaluateRegexLists(changedGroupKeys, props);
                            }
                        }
                    }
                }
            };
            fAgent.addConfigurationListener(fListener);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
        }
        catch (Exception e) {
            fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: an exception was thrown while initializing " + e.getMessage());
            fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String normalize(String rawSql, int maxLength) {
        boolean shouldMatchFallThrough;
        ArrayList compiledPatternList;
        ArrayList replaceFormatList;
        ArrayList replaceAllModeList;
        ArrayList patternMatchList;
        Object object = fLock;
        synchronized (object) {
            patternMatchList = (ArrayList)((ArrayList)fPatternMatchList).clone();
            replaceAllModeList = (ArrayList)((ArrayList)fReplaceAllModeList).clone();
            replaceFormatList = (ArrayList)((ArrayList)fReplaceFormatList).clone();
            ArrayList cfr_ignored_0 = (ArrayList)((ArrayList)fIsMatchCaseSensitiveList).clone();
            compiledPatternList = (ArrayList)((ArrayList)fCompiledPatternList).clone();
            shouldMatchFallThrough = fShouldMatchFallThrough;
        }
        boolean replacedAtleastOnce = false;
        String patternString = null;
        String replaceString = null;
        int i = 0;
        while (i < patternMatchList.size()) {
            try {
                Matcher myMatcher;
                Pattern myPattern = (Pattern)compiledPatternList.get(i);
                patternString = (String)patternMatchList.get(i);
                replaceString = (String)replaceFormatList.get(i);
                if (myPattern != null && replaceString != null && (myMatcher = myPattern.matcher(rawSql)).find()) {
                    rawSql = (Boolean)replaceAllModeList.get(i) != false ? myMatcher.replaceAll(replaceString) : myMatcher.replaceFirst(replaceString);
                    replacedAtleastOnce = true;
                    if (!shouldMatchFallThrough) {
                        break;
                    }
                }
            }
            catch (Exception e) {
                fAgent.IAgent_getModuleFeedback().error("RegexSqlNormalizer: exception was thrown for the pattern " + patternString + " and replace format " + replaceString + ", " + "check the syntax. Pattern will be ignored");
                fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
            }
            ++i;
        }
        if (!replacedAtleastOnce) {
            fAgent.IAgent_getModuleFeedback().debug("RegexSqlNormalizer: none of the configured regex patterns matched for input sql " + rawSql);
            return null;
        }
        if (rawSql.length() > maxLength) {
            rawSql = rawSql.substring(0, maxLength);
        }
        return rawSql;
    }

    private static void initializeProperties() {
        fShouldMatchFallThrough = fAgent.IAgent_getIndexedProperties().getBooleanProperty(fRegexMatchFallThrough, false);
        fGroupKeys = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(fRegexGroupKeys);
        if (fGroupKeys != null && fGroupKeys.length() == 0) {
            fGroupKeys = null;
        }
        if (fGroupKeys == null) {
            fAgent.IAgent_getModuleFeedback().warn("Statement Normalizer Extension: value of property introscope.agent.sqlagent.normalizer.regex.keys was not set ");
        }
    }

    private static void reInitializeLists() {
        fPatternMatchList = new ArrayList();
        fReplaceAllModeList = new ArrayList();
        fReplaceFormatList = new ArrayList();
        fIsMatchCaseSensitiveList = new ArrayList();
        fCompiledPatternList = new ArrayList();
    }

    private static void reEvaluateRegexLists(String groupKeys, IndexedProperties props) {
        ArrayList<String> patternMatchList = new ArrayList<String>();
        ArrayList<Boolean> replaceAllModeList = new ArrayList<Boolean>();
        ArrayList<String> replaceFormatList = new ArrayList<String>();
        ArrayList<Boolean> isMatchCaseSensitiveList = new ArrayList<Boolean>();
        ArrayList<Pattern> compiledPatternList = new ArrayList<Pattern>();
        List[] listArray = new List[]{patternMatchList, replaceAllModeList, replaceFormatList, isMatchCaseSensitiveList, compiledPatternList};
        boolean changedPattern = false;
        boolean changedReplaceAllMode = false;
        boolean changedReplaceFormat = false;
        boolean changedCaseSensitivity = false;
        if (groupKeys != null && groupKeys.length() > 0) {
            String[] strtok = groupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                String replaceString;
                String prefixWithKey = "introscope.agent.sqlagent.normalizer.regex." + strtok[i].trim();
                String patternMatchProp = String.valueOf(prefixWithKey) + fPropSeparator + fPatternMatchSuffix;
                String replaceAllProp = String.valueOf(prefixWithKey) + fPropSeparator + fReplaceAllSuffix;
                String replaceFormatProp = String.valueOf(prefixWithKey) + fPropSeparator + fReplaceFormatSuffix;
                String caseSensitiveProp = String.valueOf(prefixWithKey) + fPropSeparator + fRegexCaseSensitiveSuffix;
                String patternString = props.getTrimmedProperty(patternMatchProp);
                if (patternString != null && patternString.length() == 0) {
                    patternString = null;
                }
                if (patternString == null) {
                    if (fPatternMatchList.get(i) != null) {
                        fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property " + patternMatchProp + " has changed");
                        fAgent.IAgent_getModuleFeedback().warn("Statement Normalizer Extension: value for the property " + patternMatchProp + " was not set. This is a non-optional property when the regex key is set");
                        changedPattern = true;
                    }
                } else if (!patternString.equals((String)fPatternMatchList.get(i))) {
                    fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property " + patternMatchProp + " has changed");
                    changedPattern = true;
                }
                if ((replaceString = props.getTrimmedProperty(replaceFormatProp)) != null && replaceString.length() == 0) {
                    replaceString = null;
                }
                if (replaceString == null) {
                    if (fReplaceFormatList.get(i) != null) {
                        fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property " + replaceFormatProp + " has changed");
                        fAgent.IAgent_getModuleFeedback().warn("Statement Normalizer Extension: value for the property " + replaceFormatProp + " was not set. This is a non-optional property when the regex key is set");
                        changedReplaceFormat = true;
                    }
                } else if (!replaceString.equals((String)fReplaceFormatList.get(i))) {
                    fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property " + replaceFormatProp + " has changed");
                    changedReplaceFormat = true;
                }
                boolean replaceAllMode = props.getBooleanProperty(replaceAllProp, false);
                boolean caseSensitivityMode = props.getBooleanProperty(caseSensitiveProp, false);
                if (replaceAllMode != (Boolean)fReplaceAllModeList.get(i)) {
                    fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property " + replaceAllProp + " has changed");
                    changedReplaceAllMode = true;
                }
                if (caseSensitivityMode != (Boolean)fIsMatchCaseSensitiveList.get(i)) {
                    fAgent.IAgent_getModuleFeedback().info("Statement Normalizer Extension: value of property " + caseSensitiveProp + " has changed");
                    changedCaseSensitivity = true;
                }
                patternMatchList.add(i, patternString);
                replaceAllModeList.add(i, new Boolean(props.getBooleanProperty(replaceAllProp, false)));
                replaceFormatList.add(i, replaceString);
                isMatchCaseSensitiveList.add(i, new Boolean(props.getBooleanProperty(caseSensitiveProp, false)));
                boolean caseSensitiveness = changedCaseSensitivity ? ((Boolean)isMatchCaseSensitiveList.get(i)).booleanValue() : ((Boolean)fIsMatchCaseSensitiveList.get(i)).booleanValue();
                if (patternString != null) {
                    try {
                        Pattern compiledPattern = caseSensitiveness ? Pattern.compile(patternString) : Pattern.compile(patternString, 2);
                        compiledPatternList.add(i, compiledPattern);
                    }
                    catch (PatternSyntaxException e) {
                        fAgent.IAgent_getModuleFeedback().error("RegexSqlNormalizer: PatternSyntaxException was thrown for " + patternString + ", check your syntax. Pattern will be ignored");
                        fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
                        compiledPatternList.add(i, null);
                    }
                } else {
                    compiledPatternList.add(i, null);
                }
                ++i;
            }
            if (changedPattern) {
                fPatternMatchList = patternMatchList;
                fCompiledPatternList = compiledPatternList;
            }
            if (changedReplaceFormat) {
                fReplaceFormatList = replaceFormatList;
            }
            if (changedReplaceAllMode) {
                fReplaceAllModeList = replaceAllModeList;
            }
            if (changedCaseSensitivity) {
                fIsMatchCaseSensitiveList = isMatchCaseSensitiveList;
                fCompiledPatternList = compiledPatternList;
            }
        }
    }

    private static void initializeRegexGroups() {
        String groupKeys = fGroupKeys;
        if (groupKeys != null && groupKeys.length() > 0) {
            String[] strtok = groupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                String prefixWithKey = "introscope.agent.sqlagent.normalizer.regex." + strtok[i].trim();
                String patternMatchProp = String.valueOf(prefixWithKey) + fPropSeparator + fPatternMatchSuffix;
                String replaceAllProp = String.valueOf(prefixWithKey) + fPropSeparator + fReplaceAllSuffix;
                String replaceFormatProp = String.valueOf(prefixWithKey) + fPropSeparator + fReplaceFormatSuffix;
                String caseSensitiveProp = String.valueOf(prefixWithKey) + fPropSeparator + fRegexCaseSensitiveSuffix;
                String patternString = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(patternMatchProp);
                String replaceString = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(replaceFormatProp);
                if (patternString != null && patternString.length() == 0) {
                    patternString = null;
                }
                if (replaceString != null && replaceString.length() == 0) {
                    replaceString = null;
                }
                fPatternMatchList.add(i, patternString);
                fReplaceAllModeList.add(i, new Boolean(fAgent.IAgent_getIndexedProperties().getBooleanProperty(replaceAllProp, false)));
                fReplaceFormatList.add(i, replaceString);
                fIsMatchCaseSensitiveList.add(i, new Boolean(fAgent.IAgent_getIndexedProperties().getBooleanProperty(caseSensitiveProp, false)));
                if (patternString == null) {
                    fAgent.IAgent_getModuleFeedback().warn("Statement Normalizer Extension: value for the property " + patternMatchProp + " was not set. This is a non-optional property when the regex key is set");
                    fCompiledPatternList.add(i, null);
                } else {
                    boolean caseSensitiveness = (Boolean)fIsMatchCaseSensitiveList.get(i);
                    try {
                        Pattern compiledPattern = caseSensitiveness ? Pattern.compile(patternString) : Pattern.compile(patternString, 2);
                        fCompiledPatternList.add(i, compiledPattern);
                    }
                    catch (PatternSyntaxException e) {
                        fAgent.IAgent_getModuleFeedback().error("RegexSqlNormalizer: PatternSyntaxException was thrown for " + patternString + ", check your syntax. Pattern will be ignored");
                        fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
                        fCompiledPatternList.add(i, null);
                    }
                }
                if (replaceString == null) {
                    fAgent.IAgent_getModuleFeedback().warn("Statement Normalizer Extension: value for the property " + replaceFormatProp + " was not set. This is a non-optional property when the regex key is set");
                }
                ++i;
            }
        }
    }
}

