/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.IConsolidableAgentCommand;
import com.wily.introscope.agent.connection.IConsolidatedAgentCommand;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.util.adt.BlockingQueue;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.thread.IThreadFactory;
import com.wily.wilyassert.AssertionFailureException;
import java.util.HashMap;
import java.util.Map;

class CommandQueue
implements IServerConnectionNotification {
    private static final Module kModule = new Module("CommandQueue");
    private static final String kSizeName = "introscope.agent.appmap.queue.size";
    private static final String kSizeDefault = "1000";
    private static final String kWaitName = "introscope.agent.appmap.queue.period";
    private static final String kWaitDefault = "1000";
    private final BlockingQueue fQueue;
    private volatile SendFromQueue fBehavior;
    private final IStringLocalizer fLocalizer;
    private final IModuleFeedbackChannel fFeedback;
    private volatile int fWait;
    private volatile int fSize;
    private final IntervalHeartbeat fHeartbeat;
    private volatile boolean fConnectionUp = false;

    private CommandQueue(IThreadFactory threadFactory, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        this.fHeartbeat = new IntervalHeartbeat("Command Queue", threadFactory, feedback, localizer);
        this.fLocalizer = localizer;
        this.fFeedback = feedback;
        this.fQueue = new BlockingQueue(kModule.getName(), this.fFeedback);
    }

    public CommandQueue(ConfigurationManager manager, IThreadFactory threadFactory, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        this(threadFactory, localizer, feedback);
        try {
            PositiveIntegerConfigurationProperty sizeProperty = new PositiveIntegerConfigurationProperty(kSizeName, new Integer("1000"), feedback, kModule, localizer){

                public void set(Object value) {
                    CommandQueue.this.fSize = (Integer)value;
                    if (this.isInitialized()) {
                        CommandQueue.this.scheduleResetBehavior();
                    }
                }
            };
            PositiveIntegerConfigurationProperty waitProperty = new PositiveIntegerConfigurationProperty(kWaitName, new Integer("1000"), feedback, kModule, localizer){

                public void set(Object value) {
                    CommandQueue.this.fWait = (Integer)value;
                    if (this.isInitialized()) {
                        CommandQueue.this.scheduleResetBehavior();
                    }
                }
            };
            manager.add(sizeProperty, true);
            manager.add(waitProperty, true);
        }
        catch (AssertionFailureException e) {
            e.printStackTrace();
        }
        this.resetBehavior();
    }

    protected void scheduleResetBehavior() {
        new WaitAndExecuteBehavior(this.fHeartbeat, 1L, "Reset Behavior After Property Change"){

            protected boolean execute() {
                CommandQueue.this.resetBehavior();
                return true;
            }
        };
    }

    private synchronized void resetBehavior() {
        this.fQueue.setLimit(this.fSize);
        if (this.fBehavior != null) {
            this.fBehavior.kill();
        }
        long longWait = this.fWait;
        this.fBehavior = new SendFromQueue(this.fHeartbeat, longWait);
    }

    public void start() {
        this.fHeartbeat.start();
    }

    public boolean add(IAgentCommand data) {
        if (!this.fConnectionUp) {
            return false;
        }
        return this.fQueue.enqueue(data);
    }

    private boolean handleNextAgentCommand(Map consolidatedCommands) throws Exception {
        IAgentCommand command;
        try {
            command = (IAgentCommand)this.fQueue.interruptableDequeue(1L);
        }
        catch (Exception exception) {
            return false;
        }
        if (command instanceof IConsolidatedAgentCommand) {
            IConsolidableAgentCommand wrappedCommand = ((IConsolidatedAgentCommand)command).getConsolidableAgentCommand();
            if (wrappedCommand != null) {
                String key = wrappedCommand.getKey();
                if (key != null) {
                    IConsolidatedAgentCommand consolidated = (IConsolidatedAgentCommand)consolidatedCommands.get(key);
                    if (consolidated == null) {
                        consolidated = (IConsolidatedAgentCommand)command;
                        consolidatedCommands.put(key, consolidated);
                    } else {
                        consolidated.add((IConsolidatedAgentCommand)command);
                    }
                }
            } else {
                command.handleAgentCommand();
            }
        } else {
            command.handleAgentCommand();
        }
        return true;
    }

    public void connectionUp() {
        this.clear();
        this.fConnectionUp = true;
        this.resetBehavior();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionDown() {
        this.fConnectionUp = false;
        this.clear();
        CommandQueue commandQueue = this;
        synchronized (commandQueue) {
            this.fBehavior.kill();
        }
    }

    private void clear() {
        this.fQueue.removeAllElements();
    }

    private IStringLocalizer getLocalizer() {
        return this.fLocalizer;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    private class SendFromQueue
    extends WaitAndExecuteBehavior {
        public SendFromQueue(IntervalHeartbeat register, long wait) {
            super(register, wait, "SendFromQueue");
        }

        protected boolean execute() {
            boolean isSuccessful = true;
            HashMap consolidatedCommands = new HashMap();
            while (isSuccessful) {
                try {
                    isSuccessful = CommandQueue.this.handleNextAgentCommand(consolidatedCommands);
                }
                catch (Throwable t) {
                    if (CommandQueue.this.getFeedbackChannel().isWarningEnabled(kModule)) {
                        String additionalWarnMsg = "\n Error Message: " + t.getLocalizedMessage();
                        CommandQueue.this.getFeedbackChannel().warn(kModule, String.valueOf(CommandQueue.this.getLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_Reporter_Exception_Message")) + additionalWarnMsg);
                    }
                    if (!CommandQueue.this.getFeedbackChannel().isDebugEnabled(kModule)) continue;
                    CommandQueue.this.getFeedbackChannel().debug(kModule, "Error Message: ", t);
                }
            }
            for (Map.Entry e : consolidatedCommands.entrySet()) {
                try {
                    ((IAgentCommand)e.getValue()).handleAgentCommand();
                }
                catch (Throwable t) {
                    if (CommandQueue.this.getFeedbackChannel().isWarningEnabled(kModule)) {
                        String additionalWarnMsg = "\n Error Message: " + t.getLocalizedMessage();
                        CommandQueue.this.getFeedbackChannel().warn(kModule, String.valueOf(CommandQueue.this.getLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_Reporter_Exception_Message")) + additionalWarnMsg);
                    }
                    if (!CommandQueue.this.getFeedbackChannel().isDebugEnabled(kModule)) continue;
                    CommandQueue.this.getFeedbackChannel().debug(kModule, "Error Message: ", t);
                }
            }
            return false;
        }
    }
}

