/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.servlet.IDirectParameterAccessor;
import com.wily.introscope.agent.trace.servlet.IDirectUserIDAccessor;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.RequestWrapper;
import com.wily.introscope.agent.trace.servlet.ServletParameterLoader;
import com.wily.util.StringUtils;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class LoaderContext {
    private static final int kUserMethodKeyIdx = 4;
    private static final int kSessionAttrIdx = 3;
    private static final int kRequestAttrIdx = 2;
    private static final int kRequestParamIdx = 1;
    private static final int kHeaderParamIdx = 0;
    private static final int kWatchedParamListNum = 5;
    private static final String kHttpSessionGetAttributeValue = "HttpSession.getAttribute";
    private static final String kUserIDMethodGetValueValue = "HttpSession.getValue";
    private static final String kHttpServletRequestGetHeaderValue = "HttpServletRequest.getHeader";
    private static final Module kModule = new Module("LoaderCOntext");
    private static final String kTransactionTraceUserIDNotConfiguredMessage = "Transaction Tracer user ID has not been configured.  User ID will not be reported with transactions.";
    private static final String kTransactionTraceUserIDMissingKeyMessage = "Transaction Tracer user ID configuration is missing the required key.  User ID will not be reported with transactions.";
    private static final String kTransactionTraceUserIDUnknownMethodMessage = "Transaction Tracer user ID configuration has an unknown value \"{0}\".  User ID will not be reported with transactions.";
    private static final String kUserIDMethodGetRemoteUserValue = "HttpServletRequest.getRemoteUser";
    final HashMap fAccessors = new HashMap();
    final String[] fWatchedParamList = new String[5];
    IUserIDAccessor fUserIdAccessor = null;
    IDirectUserIDAccessor fDirectUserIdAccessor = null;
    String fCharEncoding = null;
    static volatile Map sContextMap;

    public IDirectUserIDAccessor getUserIdAccessor() {
        return this.fDirectUserIdAccessor;
    }

    public Object getAccessor(Object key) {
        return this.fAccessors.get(key);
    }

    public Set getAccessoryKeys() {
        return this.fAccessors.keySet();
    }

    public String getEncoding() {
        return this.fCharEncoding;
    }

    public static void initializeContext(IAgent agent) {
        IConcurrentMapFactory factory = agent.IAgent_getConcurrentMapFactory();
        sContextMap = factory != null ? factory.getConcurrentMap("ServletContextMapCache") : Collections.synchronizedMap(new HashMap());
    }

    public static LoaderContext getContext(String key) {
        LoaderContext ctx = (LoaderContext)sContextMap.get(key);
        if (ctx == null) {
            ctx = new LoaderContext();
            int i = 0;
            while (i < 5) {
                ctx.fWatchedParamList[i] = "";
                ++i;
            }
            if (sContextMap.size() < 10) {
                LoaderContext existingContext = sContextMap.put(key, ctx);
                if (existingContext != null) {
                    ctx = existingContext;
                }
            } else {
                Assertion.wilyAssert(false);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoadUserId(IModuleFeedbackChannel feedback, String context, String userIDMethod, String key) {
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            IUserIDAccessor userIdAccessor = null;
            StringBuffer sb = new StringBuffer();
            if (userIDMethod != null) {
                sb.append(userIDMethod);
            }
            sb.append(",");
            if (key != null) {
                sb.append(key);
            }
            String testStr = sb.toString();
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using user id: " + testStr);
            }
            if (ctx.fWatchedParamList[4].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[4] = testStr;
            if (userIDMethod == null) {
                userIdAccessor = new NoUserIDAccessor();
                feedback.warn(kTransactionTraceUserIDNotConfiguredMessage);
            } else if (userIDMethod.equalsIgnoreCase(kUserIDMethodGetRemoteUserValue)) {
                userIdAccessor = new ServletParameterLoader.GetRemoteUserUserIDAccessor();
            } else if (userIDMethod.equalsIgnoreCase(kHttpServletRequestGetHeaderValue)) {
                if (key == null) {
                    userIdAccessor = new NoUserIDAccessor();
                    feedback.error(kTransactionTraceUserIDMissingKeyMessage);
                } else {
                    userIdAccessor = new ServletParameterLoader.GetHeaderUserIDAccessor(key, ctx.fCharEncoding);
                }
            } else if (userIDMethod.equalsIgnoreCase(kUserIDMethodGetValueValue) || userIDMethod.equalsIgnoreCase(kHttpSessionGetAttributeValue)) {
                if (key == null) {
                    userIdAccessor = new NoUserIDAccessor();
                    feedback.error(kTransactionTraceUserIDMissingKeyMessage);
                } else {
                    userIdAccessor = new ServletParameterLoader.SessionGetAttributeUserIdAccessor(key);
                }
            } else {
                userIdAccessor = new NoUserIDAccessor();
                feedback.error(MessageFormat.format(kTransactionTraceUserIDUnknownMethodMessage, userIDMethod.toString()));
            }
            ctx.fUserIdAccessor = userIdAccessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoadSessionAttributes(IModuleFeedbackChannel feedback, String context, String[] attrs) {
        String testStr = Arrays.asList(attrs).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[3].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[3] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using session attributes: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "session.attrs.");
            if (attrs != null && attrs.length > 0) {
                int i = 0;
                while (i < attrs.length) {
                    ctx.fAccessors.put("session.attrs." + attrs[i], new ServletParameterLoader.SessionGetAttributeAccessor(attrs[i]));
                    ++i;
                }
            }
        }
    }

    public static void setLoadSessionAttributes(IModuleFeedbackChannel feedback, String context, String attrList) {
        if (attrList != null && attrList.length() > 0) {
            LoaderContext.setLoadSessionAttributes(feedback, context, StringUtils.parseList(attrList, ","));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoadRequestAttributes(IModuleFeedbackChannel feedback, String context, String[] attrs) {
        String testStr = Arrays.asList(attrs).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[2].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[2] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using request attributes: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "request.attrs.");
            if (attrs != null && attrs.length > 0) {
                int i = 0;
                while (i < attrs.length) {
                    ctx.fAccessors.put("request.attrs." + attrs[i], new ServletParameterLoader.RequestGetAttributeAccessor(attrs[i]));
                    ++i;
                }
            }
        }
    }

    public static void setLoadRequestAttributes(IModuleFeedbackChannel feedback, String context, String attrList) {
        if (attrList != null && attrList.length() > 0) {
            LoaderContext.setLoadRequestAttributes(feedback, context, StringUtils.parseList(attrList, ","));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoadRequestParams(IModuleFeedbackChannel feedback, String context, String[] params) {
        String testStr = Arrays.asList(params).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[1].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[1] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using request parameters: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "request.params.");
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    ctx.fAccessors.put("request.params." + params[i], new ServletParameterLoader.RequestGetParameterAccessor(params[i]));
                    ++i;
                }
            }
        }
    }

    public static void setLoadRequestParams(IModuleFeedbackChannel feedback, String context, String paramList) {
        if (paramList != null && paramList.length() > 0) {
            LoaderContext.setLoadRequestParams(feedback, context, StringUtils.parseList(paramList, ","));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoadHeaderParams(IModuleFeedbackChannel feedback, String context, String[] params) {
        String testStr = Arrays.asList(params).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[0].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[0] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using headers: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "header.");
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    ctx.fAccessors.put("header." + params[i], new ServletParameterLoader.GetHeaderAccessor(params[i]));
                    ++i;
                }
            }
        }
    }

    public static void setLoadHeaderParams(IModuleFeedbackChannel feedback, String context, String paramList) {
        if (paramList != null && paramList.length() > 0) {
            LoaderContext.setLoadHeaderParams(feedback, context, StringUtils.parseList(paramList, ","));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCharEncoding(IModuleFeedbackChannel feedback, String context, String charencoding) {
        LoaderContext ctx;
        LoaderContext loaderContext = ctx = LoaderContext.getContext(context);
        synchronized (loaderContext) {
            ctx.fCharEncoding = charencoding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDirectLoadUserId(IModuleFeedbackChannel feedback, String context, String userIDMethod, String key) {
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            IDirectUserIDAccessor userIdAccessor = null;
            StringBuffer sb = new StringBuffer();
            if (userIDMethod != null) {
                sb.append(userIDMethod);
            }
            sb.append(",");
            if (key != null) {
                sb.append(key);
            }
            String testStr = sb.toString();
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using user id: " + testStr);
            }
            if (ctx.fWatchedParamList[4].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[4] = testStr;
            if (userIDMethod == null) {
                userIdAccessor = new NoUserIDAccessor();
                feedback.warn(kTransactionTraceUserIDNotConfiguredMessage);
            } else if (userIDMethod.equalsIgnoreCase(kUserIDMethodGetRemoteUserValue)) {
                userIdAccessor = new GetDirectRemoteUserUserIDAccessor();
            } else if (userIDMethod.equalsIgnoreCase(kHttpServletRequestGetHeaderValue)) {
                if (key == null) {
                    userIdAccessor = new NoUserIDAccessor();
                    feedback.error(kTransactionTraceUserIDMissingKeyMessage);
                } else {
                    userIdAccessor = new GetDirectHeaderUserIDAccessor(key, ctx.fCharEncoding);
                }
            } else if (userIDMethod.equalsIgnoreCase(kUserIDMethodGetValueValue) || userIDMethod.equalsIgnoreCase(kHttpSessionGetAttributeValue)) {
                if (key == null) {
                    userIdAccessor = new NoUserIDAccessor();
                    feedback.error(kTransactionTraceUserIDMissingKeyMessage);
                } else {
                    userIdAccessor = new SessionDirectGetAttributeUserIdAccessor(key);
                }
            } else {
                userIdAccessor = new NoUserIDAccessor();
                feedback.error(MessageFormat.format(kTransactionTraceUserIDUnknownMethodMessage, userIDMethod.toString()));
            }
            ctx.fDirectUserIdAccessor = userIdAccessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDirectLoadSessionAttributes(IModuleFeedbackChannel feedback, String context, String[] attrs) {
        String testStr = Arrays.asList(attrs).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[3].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[3] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using session attributes: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "session.attrs.");
            if (attrs != null && attrs.length > 0) {
                int i = 0;
                while (i < attrs.length) {
                    ctx.fAccessors.put("httpsession.attribute." + attrs[i], new SessionDirectGetAttributeAccessor(attrs[i]));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDirectLoadRequestAttributes(IModuleFeedbackChannel feedback, String context, String[] attrs) {
        String testStr = Arrays.asList(attrs).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[2].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[2] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using request attributes: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "request.attrs.");
            if (attrs != null && attrs.length > 0) {
                int i = 0;
                while (i < attrs.length) {
                    ctx.fAccessors.put("httprequest.attribute." + attrs[i], new RequestDirectGetAttributeAccessor(attrs[i]));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDirectLoadRequestParams(IModuleFeedbackChannel feedback, String context, String[] params) {
        String testStr = Arrays.asList(params).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[1].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[1] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using request parameters: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "request.params.");
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    ctx.fAccessors.put("httprequest.parameter." + params[i], new RequestDirectGetParameterAccessor(params[i]));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDirectLoadHeaderParams(IModuleFeedbackChannel feedback, String context, String[] params) {
        String testStr = Arrays.asList(params).toString();
        LoaderContext ctx = LoaderContext.getContext(context);
        boolean debugOut = feedback.isDebugEnabled();
        LoaderContext loaderContext = ctx;
        synchronized (loaderContext) {
            if (ctx.fWatchedParamList[0].equals(testStr)) {
                return;
            }
            ctx.fWatchedParamList[0] = testStr;
            if (debugOut) {
                feedback.debug(kModule, String.valueOf(context) + ": Using headers: " + testStr);
            }
            LoaderContext.removeAccessors(ctx, "header.");
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    ctx.fAccessors.put("httprequest.header." + params[i], new GetDirectHeaderAccessor(params[i]));
                    ++i;
                }
            }
        }
    }

    private static void removeAccessors(LoaderContext ctx, String prefix) {
        Iterator i = ctx.fAccessors.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            if (!key.startsWith(prefix)) continue;
            i.remove();
        }
    }

    private static abstract class ADirectParameterAccessor
    implements IDirectParameterAccessor {
        private final String fParameterName;

        public ADirectParameterAccessor(String parameterName) {
            this.fParameterName = parameterName;
        }

        public final String IParameterAccessor_getParameterName() {
            return this.fParameterName;
        }
    }

    static abstract class AParameterAccessor
    implements IParameterAccessor {
        private final String fParameterName;

        public AParameterAccessor(String parameterName) {
            this.fParameterName = parameterName;
        }

        public final String IParameterAccessor_getParameterName() {
            return this.fParameterName;
        }
    }

    private static class GetDirectHeaderAccessor
    extends ADirectParameterAccessor {
        private final String fHeaderName;

        public GetDirectHeaderAccessor(String key) {
            super("httprequest.header." + key);
            this.fHeaderName = key;
        }

        public String IParameterAccessor_accessParameter(IServletRequestHelper helper, Object request, LoaderContext context, Map parameterMap) {
            return helper.getHeader(request, this.fHeaderName);
        }
    }

    private static final class GetDirectHeaderUserIDAccessor
    extends GetDirectHeaderAccessor
    implements IDirectUserIDAccessor {
        private String fEncoding;

        public GetDirectHeaderUserIDAccessor(String key, String encoding) {
            super(key);
            this.fEncoding = encoding;
        }

        public String IUserIDAccessor_accessUserID(IServletRequestHelper helper, Object request) {
            return this.IParameterAccessor_accessParameter(helper, request, null, null);
        }
    }

    private static final class GetDirectRemoteUserUserIDAccessor
    implements IDirectUserIDAccessor {
        private GetDirectRemoteUserUserIDAccessor() {
        }

        public String IUserIDAccessor_accessUserID(IServletRequestHelper helper, Object request) {
            return helper.getRemoteUser(request);
        }
    }

    static interface IParameterAccessor {
        public String IParameterAccessor_getParameterName();

        public String IParameterAccessor_accessParameter(RequestWrapper var1, String var2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException;
    }

    static interface IUserIDAccessor {
        public String IUserIDAccessor_accessUserID(RequestWrapper var1) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException;
    }

    static final class NoUserIDAccessor
    implements IUserIDAccessor,
    IDirectUserIDAccessor {
        NoUserIDAccessor() {
        }

        public String IUserIDAccessor_accessUserID(RequestWrapper request) {
            return null;
        }

        public String IUserIDAccessor_accessUserID(IServletRequestHelper helper, Object request) {
            return null;
        }
    }

    private static class RequestDirectGetAttributeAccessor
    extends ADirectParameterAccessor {
        private String fAttributeName;

        public RequestDirectGetAttributeAccessor(String key) {
            super("httprequest.attribute." + key);
            this.fAttributeName = key;
        }

        public String IParameterAccessor_accessParameter(IServletRequestHelper helper, Object request, LoaderContext context, Map parameterMap) {
            return helper.getAttribute(request, this.fAttributeName);
        }
    }

    private static class RequestDirectGetParameterAccessor
    extends ADirectParameterAccessor {
        private final String fParameterName;

        public RequestDirectGetParameterAccessor(String key) {
            super("httprequest.parameter." + key);
            this.fParameterName = key;
        }

        public String IParameterAccessor_accessParameter(IServletRequestHelper helper, Object request, LoaderContext context, Map parameterMap) {
            String[] values = (String[])parameterMap.get(this.fParameterName);
            return values == null || values.length == 0 ? null : values[0];
        }
    }

    private static class SessionDirectGetAttributeAccessor
    extends ADirectParameterAccessor {
        private final String fName;

        public SessionDirectGetAttributeAccessor(String key) {
            super("httpsession.attribute." + key);
            this.fName = key;
        }

        public String IParameterAccessor_accessParameter(IServletRequestHelper helper, Object request, LoaderContext context, Map parameterMap) {
            Object session = helper.getSession(false, request);
            if (session != null) {
                return helper.getSessionAttribute(session, this.fName);
            }
            return null;
        }
    }

    private static final class SessionDirectGetAttributeUserIdAccessor
    extends SessionDirectGetAttributeAccessor
    implements IDirectUserIDAccessor {
        public SessionDirectGetAttributeUserIdAccessor(String key) {
            super(key);
        }

        public String IUserIDAccessor_accessUserID(IServletRequestHelper helper, Object request) {
            return this.IParameterAccessor_accessParameter(helper, request, null, null);
        }
    }
}

