/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.CompilerEnvironment;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.introscope.probebuilder.ProbeBuilderCommandLineUI;
import com.wily.util.text.ILocalizableException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import java.io.PrintWriter;

public class ProbeBuilderUI
implements ICompilerUI {
    private final CompilerEnvironment fEnvironment;
    private final PrintWriter fOutputWriter;
    private final PrintWriter fErrorWriter;
    private final ICompilerUI fCommandLineUI;
    private final IStringLocalizer fStringLocalizer;
    private String fPackageName;
    private static final char kBorderCharacter = '*';

    public ProbeBuilderUI(CompilerEnvironment env, PrintWriter outputWriter, PrintWriter errorWriter, IStringLocalizer localizer) {
        this.fCommandLineUI = env.useCommandLineUI() ? new ProbeBuilderCommandLineUI(env, outputWriter, localizer) : null;
        this.fEnvironment = env;
        this.fOutputWriter = outputWriter;
        this.fErrorWriter = errorWriter;
        this.fStringLocalizer = localizer;
    }

    private PrintWriter getOutputWriter() {
        return this.fOutputWriter;
    }

    private PrintWriter getErrorWriter() {
        return this.fErrorWriter;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    private boolean useProxyUI() {
        return this.useCommandLineUI();
    }

    private ICompilerUI getProxyUI() {
        return this.getCommandLineUI();
    }

    private boolean useCommandLineUI() {
        return this.fCommandLineUI != null;
    }

    private ICompilerUI getCommandLineUI() {
        return this.fCommandLineUI;
    }

    private boolean isVerbose() {
        return this.fEnvironment.isVerbose();
    }

    public void ICompilerUI_setup(String packageName, int itemCount) {
        this.fPackageName = packageName;
        if (this.useProxyUI()) {
            this.getProxyUI().ICompilerUI_setup(this.fPackageName, itemCount);
        } else if (this.isVerbose() && this.fPackageName != null) {
            this.getOutputWriter().println(this.fStringLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Converting", this.fPackageName));
        }
    }

    public void ICompilerUI_updateStatusBar(String fileName, int entryNum) {
        if (this.useProxyUI()) {
            this.getProxyUI().ICompilerUI_updateStatusBar(fileName, entryNum);
        } else if (this.isVerbose() && fileName != null) {
            this.getOutputWriter().println(this.fStringLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Processing", fileName));
        }
    }

    public void ICompilerUI_setStatusText(String statusText) {
        if (this.useProxyUI()) {
            this.getProxyUI().ICompilerUI_setStatusText(statusText);
        } else if (this.isVerbose() && statusText != null) {
            this.getOutputWriter().println(statusText);
        }
    }

    public void ICompilerUI_setStatusMessage(ILocalizableMessage message) {
        if (this.useProxyUI()) {
            this.getProxyUI().ICompilerUI_setStatusMessage(message);
        } else {
            this.ICompilerUI_setStatusText(message.ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
        }
    }

    public void ICompilerUI_close() {
        if (this.useProxyUI()) {
            this.getProxyUI().ICompilerUI_close();
        } else if (this.isVerbose() && this.fPackageName != null) {
            this.getOutputWriter().println(this.fStringLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Closing", this.fPackageName));
        }
    }

    private void showBorderedMessage(String message) {
        PrintWriter err = this.getErrorWriter();
        int size = message.length() + 4;
        int i = 0;
        while (i < size) {
            err.print('*');
            ++i;
        }
        err.println();
        err.print('*');
        err.print(" ");
        err.print(message);
        err.print(" ");
        err.println('*');
        i = 0;
        while (i < size) {
            err.print('*');
            ++i;
        }
        err.println();
    }

    public boolean ICompilerUI_handleException(Exception e) {
        if (this.useProxyUI()) {
            return this.getProxyUI().ICompilerUI_handleException(e);
        }
        String message = e.getMessage();
        if (e instanceof ILocalizableException) {
            message = ((ILocalizableException)((Object)e)).ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer());
        }
        this.showBorderedMessage(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_UI_General_Exception_Message", message));
        if (this.isVerbose()) {
            e.printStackTrace(this.getErrorWriter());
        }
        return true;
    }

    public void ICompilerUI_handleExceptionProcessingFile(String file, Exception e) throws DGCompilationFailedException {
        if (this.useProxyUI()) {
            this.getProxyUI().ICompilerUI_handleExceptionProcessingFile(file, e);
        } else {
            String message = e.getMessage();
            if (e instanceof ILocalizableException) {
                message = ((ILocalizableException)((Object)e)).ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer());
            }
            this.showBorderedMessage(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_UI_File_Exception_Message", file, message));
            if (this.isVerbose()) {
                e.printStackTrace(this.getErrorWriter());
            }
        }
    }

    public void ICompilerUI_handleExceptionCopyingFile(String file, Exception e) throws DGCompilationFailedException {
        if (this.useProxyUI()) {
            this.getProxyUI().ICompilerUI_handleExceptionCopyingFile(file, e);
        } else {
            String message = e.getMessage();
            if (e instanceof ILocalizableException) {
                message = ((ILocalizableException)((Object)e)).ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer());
            }
            this.showBorderedMessage(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Probe_Builder_UI_File_Exception_Message", file, message));
            if (this.isVerbose()) {
                e.printStackTrace(this.getErrorWriter());
            }
        }
    }
}

