/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.isengard.IsengardException;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.StringUtils;
import com.wily.util.properties.IndexedProperties;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class TransportConfigurationPropertiesParser {
    public static final String kUseOswegoConcurrencyLibrary = "transport.useOswegoConcurrencyLibrary";
    private static final String kTransportIsNioEnabled = "transport.enable.nio";
    private static final String kEnterpriseManagerBindAddress = "introscope.enterprisemanager.ipaddress";
    private static final String kTransportMaxNumInputBuffer = "transport.buffer.input.maxNum";
    private static final String kTransportMaxNumInputBufferNio = "transport.buffer.input.maxNumNio";
    private static final String kTransportUseDirectBuffers = "transport.useDirectBuffers";
    private static final String kTransportNumDispatchers = "transport.numDispatchers";
    public static final String kTransportOutgoingMessageQueueSize = "transport.outgoingMessageQueueSize";
    private static final String kTransportIncomingMessageQueueSize = "transport.incomingMessageQueueSize";
    private static final String kTransportIsHttpTunnelingServerEnabled = "transport.enable.isengard.http.tunneling";
    private static final String kTransportOverridingHttpTunnelingServerPort = "transport.override.isengard.http.tunneling.port";
    private static final String kTransportIsHighConcurrencyEnabled = "transport.enable.isengard.high.concurrency";
    private static final String kTransportOverridingHighConcurrencyThreadPoolMaxSize = "transport.override.isengard.high.concurrency.pool.max.size";
    private static final String kTransportOverridingHighConcurrencyThreadPoolMinSize = "transport.override.isengard.high.concurrency.pool.min.size";
    private static final String kTransportOverridingHighConcurrencyThreadPoolQueueSize = "transport.override.isengard.high.concurrency.pool.queue.size";
    private static final String kTransportOverridingHighConcurrencyThreadPoolKeepAlive = "transport.override.isengard.high.concurrency.pool.keep.alive";
    private static final String kTransportShouldUseOrderedExceutor = "transport.override.isengard.use.orderedexecutor";
    public static final String kIsengardClientPOThreadPoolSize = "transport.isengard.client.po.threadpoolsize";
    public static final String kSlowClientTransportTolerance = "transport.slow.client.tolerance";
    public static final String kSlowClientDisconnectTimeLimit = "transport.slow.client.disconnect.time.limit";
    public static final String kSlowClientTimePeriod = "transport.slow.client.tolerance.time.period";
    private TransportConfiguration fTransportConfiguration;
    private boolean fUseDefaultValues;

    public TransportConfigurationPropertiesParser(IndexedProperties properties, boolean useDefaultValues) throws IsengardException {
        CheckParameter.notNull("Properties", properties);
        this.fUseDefaultValues = useDefaultValues;
        this.fTransportConfiguration = this.initializeTransportConfiguration(properties);
    }

    public TransportConfiguration getTransportConfiguration() {
        return this.fTransportConfiguration;
    }

    public static void removeAllTransportConfigurationProperties(IndexedProperties properties) {
        CheckParameter.notNull("Properties", properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportOutgoingMessageQueueSize, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportIncomingMessageQueueSize, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportIsHttpTunnelingServerEnabled, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportOverridingHttpTunnelingServerPort, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportIsHighConcurrencyEnabled, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportIsNioEnabled, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kUseOswegoConcurrencyLibrary, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportMaxNumInputBuffer, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportMaxNumInputBufferNio, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportUseDirectBuffers, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportNumDispatchers, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportOverridingHighConcurrencyThreadPoolMaxSize, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportOverridingHighConcurrencyThreadPoolMinSize, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportOverridingHighConcurrencyThreadPoolQueueSize, properties);
        TransportConfigurationPropertiesParser.removePropertyEntry(kTransportOverridingHighConcurrencyThreadPoolKeepAlive, properties);
    }

    private TransportConfiguration initializeTransportConfiguration(IndexedProperties properties) throws IsengardException {
        int outgoingMessageQueueSize = this.initializeOutgoingMessageQueueSize(properties);
        int incomingMessageQueueSize = this.initializeIncomingMessageQueueSize(properties);
        boolean isHttpTunnelingServerEnabled = this.initializeIsHttpServerTunnelingEnabled(properties);
        boolean isHighConcurrencyEnabled = this.initializeIsHighConcurrencyEnabled(properties);
        boolean isUseOswegoConcurrencyLibrary = this.initializeUseOswegoConcurrencyLibrary(properties);
        boolean isNioEnabled = this.initializeIsNioEnabled(properties);
        boolean isSlowClientTolerant = this.initializeSlowClientTolerance(properties);
        long slowClientToleranceLimit = this.initializeSlowClientToleranceLimit(properties);
        long slowClientTolerancePeriod = this.initializeSlowClientTolerancePeriod(properties);
        int bufferMaxNum = this.initializeMaxNumInputBuffer(properties);
        int bufferMaxNumNio = this.initializeMaxNumInputBufferNio(properties);
        boolean useDirectBuffers = this.initializeUseDirectBuffers(properties);
        int numDispatchers = this.initializeNumDispatchers(properties);
        TransportConfiguration transportConfig = null;
        try {
            transportConfig = new TransportConfiguration(outgoingMessageQueueSize, incomingMessageQueueSize, isHttpTunnelingServerEnabled, isHighConcurrencyEnabled, isUseOswegoConcurrencyLibrary, isNioEnabled, bufferMaxNum, bufferMaxNumNio, useDirectBuffers, numDispatchers);
        }
        catch (Exception e) {
            throw new IsengardException("Failed to create transport layer configuration.", e);
        }
        transportConfig.setSlowClientTolerance(isSlowClientTolerant);
        transportConfig.setSlowClientTimeLimit(slowClientToleranceLimit);
        transportConfig.setSlowClientTimePeriod(slowClientTolerancePeriod);
        this.initializeOverridingHttpTunnelingServerPort(transportConfig, properties);
        this.initializeOverridingHighConcurrencyThreadPoolValues(transportConfig, properties);
        this.initializeOverridingABaseServerTransportExecutor(transportConfig, properties);
        this.initializeIsengardClientPOThreadPoolSize(transportConfig, properties);
        return transportConfig;
    }

    private boolean initializeSlowClientTolerance(IndexedProperties properties) {
        boolean slowClientTolerance = true;
        String isClientToleranceEnabled = StringUtils.trim(properties.getProperty(kSlowClientTransportTolerance));
        slowClientTolerance = isClientToleranceEnabled == null && this.usingDefaultValues() ? true : Boolean.valueOf(isClientToleranceEnabled);
        return slowClientTolerance;
    }

    private long initializeSlowClientToleranceLimit(IndexedProperties properties) {
        long clientToleranceTimeLimit = 60000L;
        String customClientTimeLimit = StringUtils.trim(properties.getProperty(kSlowClientDisconnectTimeLimit));
        clientToleranceTimeLimit = customClientTimeLimit == null && this.usingDefaultValues() ? 60000L : Long.valueOf(customClientTimeLimit);
        return clientToleranceTimeLimit;
    }

    private long initializeSlowClientTolerancePeriod(IndexedProperties properties) {
        long clientToleranceTimePeriod = 120000L;
        String customClientTimePeriod = StringUtils.trim(properties.getProperty(kSlowClientTimePeriod));
        clientToleranceTimePeriod = customClientTimePeriod == null && this.usingDefaultValues() ? 120000L : Long.valueOf(customClientTimePeriod);
        return clientToleranceTimePeriod;
    }

    private int initializeOutgoingMessageQueueSize(Properties properties) throws IsengardException {
        String outgoingMessageQueueSize = StringUtils.trim(properties.getProperty(kTransportOutgoingMessageQueueSize));
        int queueSize = 0;
        if (outgoingMessageQueueSize == null && this.usingDefaultValues()) {
            queueSize = 3000;
        } else {
            try {
                queueSize = Integer.parseInt(outgoingMessageQueueSize);
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for 'transport.outgoingMessageQueueSize' property: " + outgoingMessageQueueSize, e);
            }
        }
        return queueSize;
    }

    private int initializeIncomingMessageQueueSize(Properties properties) throws IsengardException {
        String incomingMessageQueueSize = StringUtils.trim(properties.getProperty(kTransportIncomingMessageQueueSize));
        int queueSize = 0;
        if (incomingMessageQueueSize == null && this.usingDefaultValues()) {
            queueSize = 100;
        } else {
            try {
                queueSize = Integer.parseInt(incomingMessageQueueSize);
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for 'transport.incomingMessageQueueSize' property: " + incomingMessageQueueSize, e);
            }
        }
        return queueSize;
    }

    private void initializeOverridingHttpTunnelingServerPort(TransportConfiguration transportConfig, Properties properties) throws IsengardException {
        String tunnelingPort;
        if (transportConfig.isHttpTunnelingServerEnabled() && (tunnelingPort = StringUtils.trim(properties.getProperty(kTransportOverridingHttpTunnelingServerPort))) != null) {
            try {
                int port = Integer.parseInt(tunnelingPort);
                transportConfig.setHttpTunnelingServerPort(port);
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for 'transport.override.isengard.http.tunneling.port' property: " + tunnelingPort, e);
            }
        }
    }

    private void initializeOverridingHighConcurrencyThreadPoolValues(TransportConfiguration transportConfig, Properties properties) throws IsengardException {
        if (transportConfig.isHighConcurrencyTransportEnabled()) {
            String poolKeepAlive;
            String poolQueueSize;
            String poolMinSize;
            String poolMaxSize = StringUtils.trim(properties.getProperty(kTransportOverridingHighConcurrencyThreadPoolMaxSize));
            if (poolMaxSize != null) {
                try {
                    int size = Integer.parseInt(poolMaxSize);
                    transportConfig.setHighConcurrencyTransportPoolMaxSize(size);
                }
                catch (Exception e) {
                    throw new IsengardException("Invalid value for 'transport.override.isengard.high.concurrency.pool.max.size' property: " + poolMaxSize, e);
                }
            }
            if ((poolMinSize = StringUtils.trim(properties.getProperty(kTransportOverridingHighConcurrencyThreadPoolMinSize))) != null) {
                try {
                    int size = Integer.parseInt(poolMinSize);
                    transportConfig.setHighConcurrencyTransportPoolMinSize(size);
                }
                catch (Exception e) {
                    throw new IsengardException("Invalid value for 'transport.override.isengard.high.concurrency.pool.min.size' property: " + poolMinSize, e);
                }
            }
            if ((poolQueueSize = StringUtils.trim(properties.getProperty(kTransportOverridingHighConcurrencyThreadPoolQueueSize))) != null) {
                try {
                    int size = Integer.parseInt(poolQueueSize);
                    transportConfig.setHighConcurrencyTransportPoolQueueSize(size);
                }
                catch (Exception e) {
                    throw new IsengardException("Invalid value for 'transport.override.isengard.high.concurrency.pool.queue.size' property: " + poolQueueSize, e);
                }
            }
            if ((poolKeepAlive = StringUtils.trim(properties.getProperty(kTransportOverridingHighConcurrencyThreadPoolKeepAlive))) != null) {
                try {
                    int keepAlive = Integer.parseInt(poolKeepAlive);
                    transportConfig.setHighConcurrencyTransportPoolKeepAlive(keepAlive);
                }
                catch (Exception e) {
                    throw new IsengardException("Invalid value for 'transport.override.isengard.high.concurrency.pool.keep.alive' property: " + poolKeepAlive, e);
                }
            }
        }
    }

    private boolean initializeIsHttpServerTunnelingEnabled(Properties properties) {
        boolean enableTunneling = false;
        String isHttpTunnelingServerEnabled = StringUtils.trim(properties.getProperty(kTransportIsHttpTunnelingServerEnabled));
        enableTunneling = isHttpTunnelingServerEnabled == null && this.usingDefaultValues() ? true : Boolean.valueOf(isHttpTunnelingServerEnabled);
        return enableTunneling;
    }

    private boolean initializeIsHighConcurrencyEnabled(IndexedProperties properties) {
        boolean enableHighConcurrency = false;
        String isHighConcurrencyEnabled = StringUtils.trim(properties.getProperty(kTransportIsHighConcurrencyEnabled));
        enableHighConcurrency = isHighConcurrencyEnabled == null && this.usingDefaultValues() ? true : Boolean.valueOf(isHighConcurrencyEnabled);
        return enableHighConcurrency;
    }

    private boolean initializeUseOswegoConcurrencyLibrary(IndexedProperties properties) {
        boolean useOswegoConcurrencyLibrary = false;
        String isUseOswegoConcurrencyLibrary = StringUtils.trim(properties.getProperty(kUseOswegoConcurrencyLibrary));
        useOswegoConcurrencyLibrary = isUseOswegoConcurrencyLibrary == null ? false : Boolean.valueOf(isUseOswegoConcurrencyLibrary);
        return useOswegoConcurrencyLibrary;
    }

    private boolean initializeIsNioEnabled(IndexedProperties properties) {
        boolean enableNio = false;
        String isNioEnabled = StringUtils.trim(properties.getProperty(kTransportIsNioEnabled));
        enableNio = isNioEnabled == null ? true : Boolean.valueOf(isNioEnabled);
        enableNio = this.disableNewIOPropertyOnWindowsIPv6Systems(properties, enableNio);
        return enableNio;
    }

    private boolean disableNewIOPropertyOnWindowsIPv6Systems(IndexedProperties properties, boolean enableNio) {
        if (this.isWindowsOS()) {
            String value;
            String ipValue = StringUtils.trim(properties.getProperty(kEnterpriseManagerBindAddress));
            boolean isIPV6Enabled = false;
            if (ipValue != null && ipValue.indexOf(58) != -1) {
                isIPV6Enabled = true;
            } else if (ipValue == null && this.isIPv6EnabledSystem()) {
                isIPV6Enabled = true;
            }
            if (isIPV6Enabled && ((value = StringUtils.trim(properties.getProperty(kTransportIsNioEnabled))) == null || value.equalsIgnoreCase("true"))) {
                enableNio = false;
            }
        }
        return enableNio;
    }

    private boolean isWindowsOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("windows") != -1;
    }

    private boolean isIPv6EnabledSystem() {
        boolean isIPv6EnabledSystem = false;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            InetAddress[] address = InetAddress.getAllByName(localMachine.getHostName());
            int index = 0;
            while (index < address.length) {
                if (address[index] instanceof Inet6Address) {
                    isIPv6EnabledSystem = true;
                    break;
                }
                ++index;
            }
        }
        catch (UnknownHostException unknownHostException) {
            isIPv6EnabledSystem = true;
        }
        return isIPv6EnabledSystem;
    }

    private int initializeMaxNumInputBuffer(IndexedProperties properties) {
        String prop = StringUtils.trim(properties.getProperty(kTransportMaxNumInputBuffer));
        int bufferMaxNum = prop == null ? 600 : Integer.valueOf(prop);
        return bufferMaxNum;
    }

    private int initializeMaxNumInputBufferNio(IndexedProperties properties) {
        String prop = StringUtils.trim(properties.getProperty(kTransportMaxNumInputBufferNio));
        int bufferMaxNum = prop == null ? 4000 : Integer.valueOf(prop);
        return bufferMaxNum;
    }

    private boolean initializeUseDirectBuffers(IndexedProperties properties) {
        boolean useDirectBuffers = false;
        String prop = StringUtils.trim(properties.getProperty(kTransportUseDirectBuffers));
        useDirectBuffers = prop == null ? false : Boolean.valueOf(prop);
        return useDirectBuffers;
    }

    private int initializeNumDispatchers(IndexedProperties properties) throws IsengardException {
        int maxDispatchers = 0;
        String prop = StringUtils.trim(properties.getProperty(kTransportNumDispatchers));
        if (prop == null) {
            maxDispatchers = 1;
        } else {
            try {
                maxDispatchers = Integer.parseInt(prop);
            }
            catch (Exception e) {
                throw new IsengardException("Invalid value for 'transport.numDispatchers' property: " + prop, e);
            }
        }
        return maxDispatchers;
    }

    private void initializeOverridingABaseServerTransportExecutor(TransportConfiguration transportConfig, IndexedProperties properties) {
        boolean useOrderedExecutor = false;
        String transportShouldUseOrderedExceutor = StringUtils.trim(properties.getProperty(kTransportShouldUseOrderedExceutor));
        useOrderedExecutor = transportShouldUseOrderedExceutor == null && this.usingDefaultValues() ? false : Boolean.valueOf(transportShouldUseOrderedExceutor);
        transportConfig.setTransportShouldUseOrderedExecutor(useOrderedExecutor);
    }

    private void initializeIsengardClientPOThreadPoolSize(TransportConfiguration transportConfig, Properties properties) {
        String isengardClientPOThreadPoolSize = StringUtils.trim(properties.getProperty(kIsengardClientPOThreadPoolSize));
        int clientPOThreadPoolSize = 0;
        if (isengardClientPOThreadPoolSize == null && this.usingDefaultValues()) {
            clientPOThreadPoolSize = 3;
        } else {
            try {
                clientPOThreadPoolSize = Integer.parseInt(isengardClientPOThreadPoolSize);
            }
            catch (Exception exception) {
                clientPOThreadPoolSize = 3;
            }
        }
        transportConfig.setIsengardClientPOThreadPoolSize(clientPOThreadPoolSize);
    }

    private boolean usingDefaultValues() {
        return this.fUseDefaultValues;
    }

    private static void removePropertyEntry(String key, Properties properties) {
        properties.remove(key);
    }
}

