/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.io;

import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import com.wily.util.io.ScatteringBufferInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FullDuplexPipe {
    public static final int kDefaultIncomingBufferSize = 8192;
    public static final int kDefaultOutgoingBufferSize = 8192;
    private final ScatteringBufferInputStream fInputSource;
    private final InputStreamSyncWrapper fSynchedInputSource;
    private final NonSyncByteArrayOutputStream fOutputSink;
    private final OutputStreamSyncWrapper fSynchedOutputSink;
    private final byte[] fInputSemaphore = new byte[0];
    private final byte[] fOutputSemaphore = new byte[0];

    public FullDuplexPipe() throws IOException {
        this(8192, 8192);
    }

    public FullDuplexPipe(int incomingBufferSize, int outgoingBufferSize) throws IOException {
        CheckParameter.isPositive("Incoming Buffer Size", incomingBufferSize);
        CheckParameter.isPositive("Outgoing Buffer Size", outgoingBufferSize);
        this.fInputSource = new ScatteringBufferInputStream(incomingBufferSize);
        this.fSynchedInputSource = new InputStreamSyncWrapper(this.fInputSource, this.fInputSemaphore);
        this.fOutputSink = new NonSyncByteArrayOutputStream(outgoingBufferSize);
        this.fSynchedOutputSink = new OutputStreamSyncWrapper(this.fOutputSink, this.fOutputSemaphore);
    }

    /*
     * Exception decompiling
     */
    public void close() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 48->52)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream getInputStream() {
        return this.fSynchedInputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToInputStream(byte[] bytes) {
        byte[] byArray = this.fInputSemaphore;
        synchronized (this.fInputSemaphore) {
            this.fInputSource.fillFromArray(bytes);
            this.fInputSemaphore.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public OutputStream getOutputStream() {
        return this.fSynchedOutputSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availableFromOutputStream() {
        byte[] byArray = this.fOutputSemaphore;
        synchronized (this.fOutputSemaphore) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fOutputSink.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromOutputStream() {
        byte[] byArray = this.fOutputSemaphore;
        synchronized (this.fOutputSemaphore) {
            byte[] byteArray = this.fOutputSink.toByteArray();
            this.fOutputSink.reset();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byteArray;
        }
    }

    private static class InputStreamSyncWrapper
    extends FilterInputStream {
        private final ScatteringBufferInputStream fIn;
        private final Object fSemaphore;
        private boolean fIsClosed;

        public InputStreamSyncWrapper(ScatteringBufferInputStream in, Object semaphore) {
            super(in);
            this.fIn = in;
            this.fSemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                return this.fIn.available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int read() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                while (this.available() == 0) {
                    try {
                        this.fSemaphore.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("read interrupted.");
                    }
                }
                return this.fIn.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                while (this.available() == 0) {
                    try {
                        this.fSemaphore.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("read interrupted.");
                    }
                }
                return this.fIn.read(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.fIsClosed = true;
                this.fIn.close();
            }
        }

        private void checkIfStreamClosed() throws IOException {
            if (this.fIsClosed) {
                throw new IOException("stream is closed.");
            }
        }
    }

    private static class OutputStreamSyncWrapper
    extends FilterOutputStream {
        private final Object fSemaphore;
        private boolean fIsClosed;

        public OutputStreamSyncWrapper(OutputStream out, Object semaphore) {
            super(out);
            this.fSemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                this.out.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.checkIfStreamClosed();
                this.out.write(b, off, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = this.fSemaphore;
            synchronized (object) {
                this.fIsClosed = true;
                this.out.close();
            }
        }

        private void checkIfStreamClosed() throws IOException {
            if (this.fIsClosed) {
                throw new IOException("stream is closed.");
            }
        }
    }
}

