/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.wilyassert.Assertion;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class MultiplexReader
extends FilterReader {
    private final CharArrayWriter fContents = new CharArrayWriter();
    private char[] fResults;

    public MultiplexReader(Reader input) {
        super(input);
    }

    public Reader getDuplicateReader() {
        Assertion.wilyAssert(this.fResults != null);
        return new CharArrayReader(this.fResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
            Object var2_1 = null;
            if (this.fResults == null) {
                this.fResults = this.fContents.toCharArray();
                this.fContents.reset();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.fResults == null) {
                this.fResults = this.fContents.toCharArray();
                this.fContents.reset();
            }
            throw throwable;
        }
    }

    public int read() throws IOException {
        int result = super.read();
        if (result >= 0) {
            this.fContents.write(result);
        }
        return result;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = super.read(cbuf, off, len);
        if (result >= 0) {
            this.fContents.write(cbuf, off, result);
        }
        return result;
    }
}

