/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile;

import com.wily.util.classfile.FullyQualifiedFieldName;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IContainerName;
import com.wily.util.classfile.IFieldName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;

public abstract class ClassFileUtilities {
    private ClassFileUtilities() {
    }

    public static boolean looselyMatches(IContainerName pattern, IContainerName candidate) {
        return pattern.equals(candidate);
    }

    public static boolean matchPartialAssemblyName(IClassName pattern, IClassName candidate) {
        String candidateAssemblyName;
        String partialAssemblyName = pattern.getContainerName().getSimpleName();
        if (!partialAssemblyName.equals(candidateAssemblyName = candidate.getContainerName().getSimpleName())) {
            return false;
        }
        return pattern.getPackageAndNameString().equals(candidate.getPackageAndNameString());
    }

    public static boolean looselyMatches(IClassName pattern, IClassName candidate) {
        return pattern.looselyMatches(candidate);
    }

    public static boolean looselyMatches(IMethodName pattern, IMethodName candidate) {
        if (pattern.getNameString().equals(candidate.getNameString())) {
            if (!pattern.hasSignature()) {
                return true;
            }
            return ClassFileUtilities.looselyMatches(pattern.getSignature(), candidate.getSignature());
        }
        return false;
    }

    public static boolean looselyMatches(IFieldName pattern, IFieldName candidate) {
        if (pattern.getNameString().equals(candidate.getNameString())) {
            if (!pattern.hasSignature()) {
                return true;
            }
            return ClassFileUtilities.looselyMatches(pattern.getSignature(), candidate.getSignature());
        }
        return false;
    }

    public static boolean looselyMatches(FullyQualifiedFieldName pattern, FullyQualifiedFieldName candidate) {
        return ClassFileUtilities.looselyMatches(pattern.getClassName(), candidate.getClassName()) && ClassFileUtilities.looselyMatches(pattern.getFieldName(), candidate.getFieldName());
    }

    public static boolean looselyMatches(FullyQualifiedMethodName pattern, FullyQualifiedMethodName candidate) {
        return ClassFileUtilities.looselyMatches(pattern.getClassName(), candidate.getClassName()) && ClassFileUtilities.looselyMatches(pattern.getMethodName(), candidate.getMethodName());
    }

    public static boolean looselyMatches(ISlotSignature pattern, ISlotSignature candidate) {
        return pattern.looselyMatches(candidate);
    }

    public static boolean looselyMatches(IMethodSignature pattern, IMethodSignature candidate) {
        if (pattern.getParameterCount() != candidate.getParameterCount()) {
            return false;
        }
        if (!ClassFileUtilities.looselyMatches(pattern.getReturnSlotSignature(), candidate.getReturnSlotSignature())) {
            return false;
        }
        for (int x = 0; x < pattern.getParameterCount(); ++x) {
            if (ClassFileUtilities.looselyMatches(pattern.getParameterSignatureByIndex(x), candidate.getParameterSignatureByIndex(x))) continue;
            return false;
        }
        return true;
    }
}

