/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.layout;

import com.wily.ui.swing.ExtendedJLabel;
import com.wily.ui.swing.layout.ATitleComponentPairsPanel;
import com.wily.ui.swing.layout.TitleComponentPair;
import com.wily.util.text.IStringLocalizer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;

public class YAlignedTitleComponentPairsPanel
extends ATitleComponentPairsPanel {
    private static final long serialVersionUID = 8805268168433434472L;
    private int fAxis;
    private int fCount;

    public YAlignedTitleComponentPairsPanel(TitleComponentPair[] titleComponentPairs, IStringLocalizer stringLocalizer) {
        this(titleComponentPairs, 1, stringLocalizer);
    }

    public YAlignedTitleComponentPairsPanel(TitleComponentPair[] titleComponentPairs, int axis, IStringLocalizer stringLocalizer) {
        super(titleComponentPairs, stringLocalizer);
        this.fAxis = axis;
        this.initUI();
    }

    private void initUI() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        Enumeration pairs = this.getTitleComponentPairs();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(1, 1, this.fAxis == 1 ? this.getVerticalGap() - 1 : 0, this.fAxis == 0 ? this.getHorizontalGap() - 1 : 0);
        int i = 0;
        while (pairs.hasMoreElements()) {
            TitleComponentPair pair = (TitleComponentPair)pairs.nextElement();
            String titleWithSeparator = pair.getTitle() == null ? null : pair.getTitle() + this.getTitleSeparatorString();
            ExtendedJLabel titleLabel = new ExtendedJLabel(titleWithSeparator);
            switch (pair.getVerticalAnchor()) {
                case 15: {
                    constraints.anchor = 14;
                    break;
                }
                case 10: {
                    constraints.anchor = 13;
                    break;
                }
                default: {
                    constraints.anchor = 12;
                }
            }
            if (pair.isCustomConstraints()) {
                constraints.fill = 0;
                constraints.weightx = 0.0;
                constraints.gridwidth = -1;
            }
            constraints.gridx = this.fAxis == 1 ? 0 : i * 2;
            constraints.gridy = this.fAxis == 1 ? i : 0;
            layout.setConstraints(titleLabel, constraints);
            this.add(titleLabel);
            Component comp = pair.getComponent();
            switch (pair.getVerticalAnchor()) {
                case 15: {
                    constraints.anchor = 16;
                    break;
                }
                case 10: {
                    constraints.anchor = 17;
                    break;
                }
                default: {
                    constraints.anchor = 18;
                }
            }
            if (pair.isCustomConstraints()) {
                constraints.fill = pair.getComponentFill();
                constraints.gridwidth = 0;
                constraints.weightx = pair.getComponentWeightX();
            }
            constraints.gridx = this.fAxis == 1 ? 1 : i * 2 + 1;
            layout.setConstraints(comp, constraints);
            this.add(comp);
            ++i;
        }
        this.fCount = i;
    }

    public void addSingleComponent(Component c) {
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(1, 1, this.fAxis == 1 ? this.getVerticalGap() - 1 : 0, this.fAxis == 0 ? this.getHorizontalGap() - 1 : 0);
        constraints.anchor = 17;
        constraints.gridx = this.fAxis == 1 ? 1 : this.fCount * 2 + 1;
        layout.setConstraints(c, constraints);
        this.add(c);
        ++this.fCount;
    }
}

