/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.util.properties.AttributeListing;

public class TNFlowServiceBlameTracer
extends ASingleInstanceTracerFactory {
    public static final String kRPIMetric = "RPIMetric";
    public static final String kARTMetric = "ARTMetric";
    public static final String kService = "service";
    public static final String kParentResource = "ParentResource";
    public static final String kMetricSeperator = ":";

    public TNFlowServiceBlameTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            String strFlowServiceNameFound;
            String strFlowServiceName = this.getParameter(kService);
            Object objInvocationObject = data.getInvocationObject();
            if (objInvocationObject != null && strFlowServiceName.equals(strFlowServiceNameFound = objInvocationObject.toString())) {
                DataAccumulatorFactory factory = this.getAgent().IAgent_getDataAccumulatorFactory();
                String componentname = this.formatParameterizedName(data);
                String strRPIMetricname = String.valueOf(componentname) + kMetricSeperator + this.getParameter(kRPIMetric);
                factory.safeGetLongIntervalCounterDataAccumulator(strRPIMetricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
                if (!WmCache.isAsyncServiceExec()) {
                    strRPIMetricname = String.valueOf(this.getParameter(kParentResource)) + kMetricSeperator + this.getParameter(kRPIMetric);
                    factory.safeGetLongIntervalCounterDataAccumulator(strRPIMetricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                int responsetime = data.getWallClockElapsedTimeAsInt();
                this.getAgent().IAgent_getModuleFeedback().debug("TNFlowServiceBlameTracer.ITracer_finishTrace()responsetime:" + responsetime);
                String strARTMetricname = String.valueOf(componentname) + kMetricSeperator + this.getParameter(kARTMetric);
                factory.safeGetIntegerAverageDataAccumulator(strARTMetricname).IIntegerAggregatingDataAccumulator_recordDataPoint(responsetime);
                if (!WmCache.isAsyncServiceExec()) {
                    strARTMetricname = String.valueOf(this.getParameter(kParentResource)) + kMetricSeperator + this.getParameter(kARTMetric);
                    factory.safeGetIntegerAverageDataAccumulator(strARTMetricname).IIntegerAggregatingDataAccumulator_recordDataPoint(responsetime);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getAgent().IAgent_getModuleFeedback().error(e.getMessage());
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            String strFlowServiceName = this.getParameter(kService);
            Object objInvocationObject = data.getInvocationObject();
            if (objInvocationObject != null) {
                String strFlowServiceNameFound = objInvocationObject.toString();
                if (strFlowServiceNameFound.equals("wm.tn:receive")) {
                    WmCache.enableActivityErrorLog(true);
                }
                if (strFlowServiceName.equals(strFlowServiceNameFound)) {
                    WmCache.enableActivityErrorLog(true);
                    data.storeWallClockStartTime();
                }
            }
        }
        catch (Exception e) {
            this.getAgent().IAgent_getModuleFeedback().error(e.getMessage());
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

