/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class CXFNameAndSOAPCorrelationTracer
extends WSCorrelationTracer
implements KConstants {
    private static final QName kCOR_HEADER_QNAME = new QName("http://www.wilytech.com/", "WSCorIDSOAPHeader");

    public CXFNameAndSOAPCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            boolean correlationIdFound = false;
            WSMUtils.refreshLogLevels();
            boolean isHTTPReadEnabled = WSMUtils.correlationHTTPReadEnabled();
            correlationIdFound = this.readHTTPCorrelationInfo(data, isHTTPReadEnabled);
            if (!correlationIdFound && WSMUtils.correlationSOAPReadEnabled()) {
                Object objExchange = data.getInvocationParameterAsObject(0);
                Map mapInMessage = (Map)WSMUtils.invokeMethodOnObject(objExchange, "getInMessage");
                List lstHeaders = (List)mapInMessage.get("org.apache.cxf.headers.Header.list");
                String correlationId = null;
                if (lstHeaders != null) {
                    int nHeaders = lstHeaders.size();
                    int i = 0;
                    while (i < nHeaders) {
                        Object objHeader = lstHeaders.get(i);
                        Object currentQName = WSMUtils.invokeMethodOnObject(objHeader, "getName");
                        String namespace = (String)WSMUtils.invokeMethodOnObject(currentQName, "getNamespaceURI");
                        if (namespace.equals(kCOR_HEADER_QNAME.getNamespaceURI())) {
                            Element elemWSSoapHeader = (Element)WSMUtils.invokeMethodOnObject(objHeader, "getObject");
                            correlationId = elemWSSoapHeader.getAttributeNode("CorID").getValue();
                            WSMUtils.getLogger().debug("CXFNameAndSOAPCorrelationTracer CorrelationId found" + correlationId);
                            break;
                        }
                        ++i;
                    }
                }
                if (correlationId != null) {
                    new CorrelationId(correlationId);
                }
                if (correlationId == null) {
                    WSMUtils.getLogger().debug("CXFNameAndSOAPCorrelationTracer CorrelationId not found");
                }
            }
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFNameAndSOAPCorrelationTracer ITracer_startTrace", e);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        super.ITracer_finishTrace(tracerIndex, data);
    }

    protected boolean readHTTPCorrelationInfo(InvocationData data, boolean isHTTPReadEnabled) throws Exception {
        boolean found = false;
        if (isHTTPReadEnabled) {
            Object objExchange = data.getInvocationParameterAsObject(0);
            Map mapInMessage = (Map)WSMUtils.invokeMethodOnObject(objExchange, "getInMessage");
            Map protocolHeaders = (Map)mapInMessage.get("org.apache.cxf.message.Message.PROTOCOL_HEADERS");
            found = this.getCorrelationInfoFromHttpHeaders(protocolHeaders);
        }
        return found;
    }

    protected boolean getCorrelationInfoFromHttpHeaders(Map<String, List<String>> protocolHeaders) throws Exception {
        boolean corIdFound = false;
        if (protocolHeaders != null) {
            List<String> correlationIdList = protocolHeaders.get("CorID".toLowerCase());
            if (correlationIdList != null) {
                new CorrelationId(correlationIdList.get(0));
                corIdFound = true;
            } else {
                WSMUtils.getLogger().debug("CXFNameAndSOAPCorrelationTracer HTTP CorrelationId not found");
            }
        } else {
            WSMUtils.getLogger().debug("CXFNameAndSOAPCorrelationTracer protocolHeaders=null");
        }
        return corIdFound;
    }
}

