/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.trace.common.MutableInteger;
import com.wily.introscope.agent.brtm.trace.common.PPSimpleTracer;
import com.wily.introscope.agent.brtm.utilities.KBRTMConstants;
import com.wily.introscope.agent.brtm.utilities.WrapperFactoryUtils;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class BrtmHTTPResponseTracer
extends PPSimpleTracer
implements ITracer {
    private static final Module BRTM_MODULE = new Module("BrowserAgent");
    private static IAgent agent;
    public static final String[] methodNames;
    public static final String[] overrideClassName;
    private static ThreadLocal stackDepthLocal;

    static {
        methodNames = KBRTMConstants.methodNames;
        overrideClassName = KBRTMConstants.overrideClassName;
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }

    public BrtmHTTPResponseTracer(IAgent a, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) throws AgentNotAvailableException {
        super(a, parameters, probe, sampleTracedObject);
        agent = a;
        new DelegatingFeedbackChannel(agent.IAgent_getModuleFeedback(), BRTM_MODULE);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object shouldAddCookie;
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        BTThreadLocalAdministrator.getInstance().insert("endTime", (Object)data.getWallClockTime());
        if (BTThreadLocalAdministrator.getInstance().get("brtm-response-wrapper-created") != null && !((Boolean)BTThreadLocalAdministrator.getInstance().get("brtm-response-wrapper-created")).booleanValue() && (shouldAddCookie = BTThreadLocalAdministrator.getInstance().get("shouldAddResponseCookie")) instanceof Boolean && ((Boolean)shouldAddCookie).booleanValue()) {
            this.addResponseCookie(data);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return (agent.IAgent_getComponentTracer().isAgentOldMode() ? Boolean.FALSE : BTThreadLocalAdministrator.getInstance().isResponseCookieEnabled()) == false;
    }

    private void addResponseCookie(InvocationData invocationData) {
        WrapperFactoryUtils wrapperFactoryUtil = (WrapperFactoryUtils)BTThreadLocalAdministrator.getInstance().get("wrapperFactoryUtil");
        Object factoryObject = wrapperFactoryUtil.getFactoryObject();
        Object[] argArray = new Object[1];
        Class[] argClassArray = new Class[1];
        argArray[0] = invocationData.getInvocationObject();
        argClassArray[0] = Object.class;
        BrtmHTTPResponseTracer.invokeReturnsVoid(factoryObject, invocationData, 3, argArray, argClassArray, wrapperFactoryUtil.getMethodCache());
    }
}

