/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ICloseable;
import com.wily.util.ILifeCycle;
import java.util.ArrayList;
import java.util.List;

public abstract class ALifeCycle
implements ILifeCycle {
    private int fState = 3;
    private final Object fLifeCycleLock = new Object();
    private final List fCloseables = new ArrayList();

    public final synchronized int getState() {
        return this.fState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCloseables() {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            for (ICloseable closeable : this.fCloseables) {
                closeable.close();
            }
            this.fCloseables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addCloseable(ICloseable closeable) {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            if (this.isStopped() || this.isStopping() || this.isFailed()) {
                closeable.close();
            } else {
                this.fCloseables.add(closeable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeCloseable(ICloseable closeable) {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            this.fCloseables.remove(closeable);
        }
    }

    public final Object getLifeCycleLock() {
        return this.fLifeCycleLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            this.fState = 1;
            try {
                this.doStart();
                this.fState = 0;
            }
            finally {
                if (this.fState == 1) {
                    this.fState = 4;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws Exception {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            if (this.fState == 3) {
                return;
            }
            this.fState = 2;
            try {
                this.doStop();
                this.closeCloseables();
                this.fState = 3;
            }
            finally {
                if (this.fState == 2) {
                    this.fState = 4;
                }
            }
        }
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setState(int state) {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            this.fState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            return this.fState == 0 || this.fState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStarted() {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            return this.fState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStarting() {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            return this.fState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStopping() {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            return this.fState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStopped() {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            return this.fState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFailed() {
        Object object = this.fLifeCycleLock;
        synchronized (object) {
            return this.fState == 4;
        }
    }
}

