/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.config.parser;

import com.wily.rave.agent.config.ConfigException;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import com.wily.rave.agent.task.Schedule;
import org.w3c.dom.Element;

public final class ScheduleParser {
    public static Schedule getSchedule(Element element) throws ConfigException {
        Schedule schedule;
        String type = ElementParserHelper.getRequiredAttribute(element, "type");
        if (type.equals("repetitive")) {
            int interval = ElementParserHelper.getRequiredIntegerAttribute(element, "interval");
            String unit = ElementParserHelper.getRequiredAttribute(element, "unit");
            if (unit.equals("min")) {
                interval *= 60;
            } else if (unit.equals("hour")) {
                interval *= 3600;
            } else if (!unit.equals("sec")) {
                throw new ConfigException("Invalid unit: " + unit);
            }
            schedule = Schedule.getRepetetiveSchedule(interval);
        } else if (type.equals("post-startup")) {
            schedule = Schedule.getOneRunSchedule();
        } else {
            throw new ConfigException("Invalid schedule type: " + type);
        }
        return schedule;
    }
}

