/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.epa;

import com.wily.introscope.agent.epa.IXMLHandler;
import com.wily.rave.agent.IAgentConfiguration;
import com.wily.rave.agent.IListenerContainer;
import com.wily.rave.agent.config.parser.ConfigFileParser;
import com.wily.rave.agent.ds.ASimpleDataSource;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPADataSourceContainer
implements IXMLHandler {
    private static final String DATA_SOURCE_TAG = "dataSource";
    private static final String DATA_SOURCE_DISPLAY_NAME_TAG = "dataSourceDisplayName";
    private static final String RESOURCE_TAG = "resource";
    private static final String VALUE_TAG = "value";
    private static final String NAME_TAG = "name";
    private IListenerContainer listenerContainer;
    private Map dataSources;
    private IModuleFeedbackChannel feedback;
    private IAgentConfiguration raveConfig;
    private final IntervalHeartbeat heartbeat;

    public EPADataSourceContainer(IListenerContainer listenerContainer, IModuleFeedbackChannel feedback, IAgentConfiguration raveConfig, IntervalHeartbeat heartbeat) {
        this.listenerContainer = listenerContainer;
        this.dataSources = new HashMap();
        this.feedback = feedback;
        this.raveConfig = raveConfig;
        this.heartbeat = heartbeat;
    }

    public void handleData(String content) {
        Document document = null;
        try {
            document = this.getDocument(content);
            this.parse(document);
            return;
        }
        catch (ParserConfigurationException e) {
            this.feedback.error(content);
            this.feedback.error("Failed to create Document object! Document will be ignored.", e);
        }
        catch (SAXException e) {
            this.feedback.error(content);
            this.feedback.error("Failed to create Document object! Document will be ignored.", e);
        }
        catch (IOException e) {
            this.feedback.error(content);
            this.feedback.error("Failed to create Document object! Document will be ignored.", e);
        }
        catch (Exception e) {
            this.feedback.error(content);
            this.feedback.error("Unexpected internal error while parsing EPA document. Document will be ignored.", e);
        }
    }

    private Document getDocument(String content) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(content.getBytes("UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Document document) {
        EPADataSource dataSource;
        Element element = (Element)document.getFirstChild();
        if (!"changeData".equals(element.getTagName())) {
            this.feedback.error("Fatal error! XML document does not represent a change document!");
            throw new RuntimeException("Fatal error! XML document does not represent a change document!");
        }
        String dataSourceName = element.getAttribute(DATA_SOURCE_TAG);
        if (!ConfigFileParser.isValidDataSourceName(dataSourceName)) {
            String errorMsg = "Invalid context name.  Context name cannot include the following characters: \\, /, #, ?, \", <, >, |.  Use the dataSourceDisplayName attribute if you wish to have a datasource that is identified by a string with one of these elments";
            this.feedback.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        String dataSourceDisplayName = null;
        Attr dsDisplayNameAttr = element.getAttributeNode(DATA_SOURCE_DISPLAY_NAME_TAG);
        dataSourceDisplayName = dsDisplayNameAttr == null ? dataSourceName : dsDisplayNameAttr.getValue();
        EPADataSourceContainer ePADataSourceContainer = this;
        synchronized (ePADataSourceContainer) {
            dataSource = (EPADataSource)this.dataSources.get(dataSourceName);
            if (dataSource == null) {
                dataSource = new EPADataSource(this.listenerContainer, dataSourceName, dataSourceDisplayName, this.raveConfig.getProperty("introscope.changeDetector.eventBatchSize", 10), this.heartbeat);
                this.dataSources.put(dataSourceName, dataSource);
            }
        }
        dataSource.requestCollection(element);
    }

    private static final class EPADataSource
    extends ASimpleDataSource {
        private Element nextRootToProcess;
        private boolean taskSchedOrRunning = false;
        private final IDataSourceListener listener;
        private final IntervalHeartbeat heartbeat;

        private EPADataSource(IListenerContainer listenerContainer, String dataSourceName, String dataSourceDisplayName, int eventBatchSize, IntervalHeartbeat heartbeat) {
            this.heartbeat = heartbeat;
            this.listener = listenerContainer.getListener(dataSourceName, dataSourceDisplayName, "Change_EPA", true, eventBatchSize);
            this.init(this.listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestCollection(Element root) {
            EPADataSource ePADataSource = this;
            synchronized (ePADataSource) {
                if (this.taskSchedOrRunning) {
                    if (this.nextRootToProcess != null) {
                        this.getFeedback().info("New EPA dataset for datasource " + this.getDSInstance() + " overwrites previous unprocessed dataset.");
                        if (this.getFeedback().isDebugEnabled()) {
                            this.getFeedback().debug(this.nextRootToProcess.toString());
                        }
                    }
                } else {
                    this.addCollectionTask();
                }
                this.nextRootToProcess = root;
            }
        }

        /*
         * Exception decompiling
         */
        private void collect() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 137->141)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final void addCollectionTask() {
            new EPACollectionTask();
            this.taskSchedOrRunning = true;
        }

        private void internalCollect(Element root) throws RestartScanException {
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    Element child = (Element)children.item(i);
                    if (!child.getTagName().equals(EPADataSourceContainer.RESOURCE_TAG)) {
                        this.getFeedback().error("Element " + child.getTagName() + " is not a " + EPADataSourceContainer.RESOURCE_TAG + " element. Ignoring...");
                    } else if (!child.hasAttribute(EPADataSourceContainer.NAME_TAG) || !child.hasAttribute(EPADataSourceContainer.VALUE_TAG)) {
                        this.getFeedback().error("Missing at least one of the following attributes name, value. Ignoring this resource!");
                    } else {
                        String resourceName = child.getAttribute(EPADataSourceContainer.NAME_TAG);
                        String resourceValue = child.getAttribute(EPADataSourceContainer.VALUE_TAG);
                        this.handContent(resourceName, resourceValue);
                    }
                }
                ++i;
            }
            this.reportEndOfScan();
        }

        private final class EPACollectionTask
        implements ITimestampedRunnable {
            private IRegisteredBehavior behavior;

            private EPACollectionTask() {
                this.behavior = EPADataSource.this.heartbeat.addBehavior((ITimestampedRunnable)this, "EPA " + EPADataSource.this.getDSInstance().getName(), true, 100L, false);
            }

            public void ITimestampedRunnable_execute(long nowInMillis) {
                EPADataSource.this.heartbeat.removeBehavior(this.behavior);
                EPADataSource.this.collect();
            }
        }
    }
}

