/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.jobstatistics.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.soaextension.tibcobw.TibcoWeakHashSet;
import com.wily.soaextension.tibcobw.jobstatistics.tracer.JobWatchCollector;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class TibcoJobMonitor
implements ITimestampedRunnable {
    private final IAgent agent;
    private JobWatchCollector collector;

    public TibcoJobMonitor(IAgent agent) {
        this.agent = agent;
        this.collector = JobWatchCollector.getInstance();
    }

    public void ITimestampedRunnable_execute(long arg0) {
        TibcoWeakHashSet jobCreatorCollection = this.collector.getJobCreators();
        HashMap tempMap = new HashMap();
        Object jobCreator2 = null;
        if ((tempMap = jobCreatorCollection.addAll(tempMap)) != null) {
            for (Object jobCreator2 : tempMap.keySet()) {
                if (jobCreator2 == null) continue;
                try {
                    String _pathName = (String)tempMap.get(jobCreator2);
                    this.reportStatus(jobCreator2, _pathName);
                }
                catch (Exception e) {
                    this.agent.IAgent_getModuleFeedback().error((Throwable)e);
                }
            }
        }
    }

    public final String getStateAsString(int state) {
        switch (state) {
            case 1: {
                return "Active";
            }
            case 2: {
                return "Flow-Controlled";
            }
        }
        return "Inactive";
    }

    private void reportStatus(Object jobCreator, String jobname) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getStateMethod = jobCreator.getClass().getMethod("getState", new Class[0]);
        Integer state = (Integer)getStateMethod.invoke(jobCreator, new Object[0]);
        this.agent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Tibco|Jobs|" + jobname + ":Process Starter State").IStringEveryEventDataAccumulator_addString(this.getStateAsString(state));
        Method getJobsRunningMethod = jobCreator.getClass().getMethod("getJobsRunning", new Class[0]);
        Integer runningJobs = (Integer)getJobsRunningMethod.invoke(jobCreator, new Object[0]);
        this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobname + ":Running Jobs").ILongCounterDataAccumulator_setValue(runningJobs.longValue());
        Method getJobsCompletedMethod = jobCreator.getClass().getMethod("getCompleted", new Class[0]);
        Integer jobsCompleted = (Integer)getJobsCompletedMethod.invoke(jobCreator, new Object[0]);
        this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobname + ":Completed Jobs").ILongCounterDataAccumulator_setValue(jobsCompleted.longValue());
        Method getJobsCreatedMethod = jobCreator.getClass().getMethod("getCreated", new Class[0]);
        Integer jobsCreated = (Integer)getJobsCreatedMethod.invoke(jobCreator, new Object[0]);
        this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobname + ":Created Jobs").ILongCounterDataAccumulator_setValue((long)jobsCreated.intValue());
        Method getJobsCreationRate = jobCreator.getClass().getMethod("getJobCreationRate", new Class[0]);
        Integer jobCreationRate = (Integer)getJobsCreationRate.invoke(jobCreator, new Object[0]);
        this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobname + ":Jobs Created Per Hour").ILongCounterDataAccumulator_setValue(jobCreationRate.longValue());
        Method getFlowLimitMethod = jobCreator.getClass().getMethod("getFlowLimit", new Class[0]);
        Integer flowLimit = (Integer)getFlowLimitMethod.invoke(jobCreator, new Object[0]);
        this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Tibco|Jobs|" + jobname + ":Flow Limit").ILongCounterDataAccumulator_setValue((long)flowLimit.intValue());
    }
}

