/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.tibcobw.ATibcoSingleInstanceTracer;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoPPException;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class SubprocessStartTracer
extends ATibcoSingleInstanceTracer {
    private static final String TracerName = "SubprocessStartTracer: ";

    private HashMap getJobHashMap(Object createdJobObject) throws TibcoPPException {
        HashMap variablesMap = null;
        try {
            variablesMap = (HashMap)TibcoReflectionCache.getF_Job_M(createdJobObject).get(createdJobObject);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
        return variablesMap;
    }

    private void setJobHashMap(Object createdJobObject, HashMap variablesMap) throws TibcoPPException {
        try {
            TibcoReflectionCache.getF_Job_M(createdJobObject).set(createdJobObject, variablesMap);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
    }

    public SubprocessStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        try {
            String component = this.formatParameterizedName(data);
            if (component != null) {
                this.getComponentTracer().removeComponent(component);
            }
            data.setComponentNameAt(component, i);
            Object objparentJob = data.getInvocationObject();
            HashMap<String, String> variablesMap = this.getJobHashMap(objparentJob);
            if (variablesMap == null) {
                variablesMap = new HashMap<String, String>();
            }
            if (!variablesMap.containsKey(component)) {
                long sttime = System.currentTimeMillis();
                variablesMap.put(component, String.valueOf(sttime));
                this.setJobHashMap(objparentJob, variablesMap);
                IIntegerFluctuatingCounterDataAccumulator tcicounter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + ":Concurrent Invocations");
                tcicounter.IIntegerFluctuatingCounterDataAccumulator_increment();
            }
        }
        catch (TibcoPPException e) {
            TibcoBWUtils.handleError(this.getAgent(), TracerName, e);
        }
    }

    public void ITracer_startTrace(int i, InvocationData invocationdata) {
        String component = this.formatParameterizedName(invocationdata);
        String businessProcessName = (String)invocationdata.get("com.wily.soaextension.tibcobw.SubprocessNameKey");
        if (businessProcessName != null && businessProcessName.length() > 0) {
            this.getComponentTracer().addComponent(component, "businessprocess", businessProcessName);
        } else {
            this.getComponentTracer().addComponent(component);
            TibcoBWUtils.getLogger().error("SubprocessStartTracer:ITracer_startTrace, SubProcessName is either null or empty : " + businessProcessName);
        }
    }
}

