/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.builder;

import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.tracer.IMethodTracerValidator;
import com.wily.util.classfile.IClassName;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.ValidationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TracerClassMapping
implements IValidatable {
    private Map fMapping = new HashMap();
    private Map fDuplicates = new HashMap();
    private Map fValidationClassNames = new HashMap();
    private Map fValidationDuplicates = new HashMap();
    private Map fValidationClasses = new HashMap();
    private Map fTracerOrderings = new HashMap();
    private Map fTracerOrderingDuplicates = new HashMap();
    private Map fTracerParameters = new HashMap();
    private Map fTracerParameterDuplicates = new HashMap();

    TracerClassMapping() {
    }

    public void addMapping(TracerName shorthand, IClassName tracerClass, IClassName validationClass) {
        IClassName curTracerClass = this.getMapping(shorthand);
        if (curTracerClass != null && !curTracerClass.equals(tracerClass)) {
            this.setMappingDuplicate(shorthand, curTracerClass);
        }
        this.setMapping(shorthand, tracerClass);
        IClassName curValidationClass = this.getValidatorName(shorthand);
        if (curValidationClass != null && !curValidationClass.equals(validationClass)) {
            this.setValidatorNameDuplicate(shorthand, curValidationClass);
        }
        this.setValidatorName(shorthand, validationClass);
    }

    public void addOrdering(TracerName shorthand, int ordering) {
        Integer newOrdering = new Integer(ordering);
        Integer currentOrdering = (Integer)this.fTracerOrderings.get(shorthand);
        if (currentOrdering != null && !currentOrdering.equals(newOrdering)) {
            this.fTracerOrderingDuplicates.put(shorthand, currentOrdering);
        }
        this.fTracerOrderings.put(shorthand, newOrdering);
    }

    public void addParameter(TracerName shorthand, String key, String value) {
        String currentValue;
        HashMap<String, String> tracerMap = (HashMap<String, String>)this.fTracerParameters.get(shorthand);
        if (tracerMap == null) {
            tracerMap = new HashMap<String, String>();
            this.fTracerParameters.put(shorthand, tracerMap);
        }
        if ((currentValue = (String)tracerMap.get(key)) != null && !currentValue.equals(value)) {
            HashMap<String, String> duplicateMap = (HashMap<String, String>)this.fTracerParameterDuplicates.get(shorthand);
            if (duplicateMap == null) {
                duplicateMap = new HashMap<String, String>();
                this.fTracerParameterDuplicates.put(shorthand, duplicateMap);
            }
            duplicateMap.put(key, currentValue);
        }
        tracerMap.put(key, value);
    }

    public int getTracerOrdering(TracerName source, int defaultOrdering) {
        Integer result = (Integer)this.fTracerOrderings.get(source);
        if (result == null) {
            return defaultOrdering;
        }
        return result;
    }

    public Map getTracerParameters(TracerName source) {
        return (Map)this.fTracerParameters.get(source);
    }

    public IClassName getMapping(TracerName source) {
        return (IClassName)this.fMapping.get(source);
    }

    private void setMapping(TracerName source, IClassName value) {
        this.fMapping.put(source, value);
    }

    public boolean hasMapping(TracerName source) {
        return this.getMapping(source) != null;
    }

    private void setMappingDuplicate(TracerName source, IClassName value) {
        this.fDuplicates.put(source, value);
    }

    private IClassName getValidatorName(TracerName source) {
        return (IClassName)this.fValidationClassNames.get(source);
    }

    private void setValidatorName(TracerName source, IClassName validator) {
        this.fValidationClassNames.put(source, validator);
    }

    private void setValidatorNameDuplicate(TracerName source, IClassName validator) {
        this.fValidationDuplicates.put(source, validator);
    }

    public IMethodTracerValidator getValidator(TracerName source) {
        return (IMethodTracerValidator)this.fValidationClasses.get(source);
    }

    private void loadValidators() throws ValidationException {
        for (TracerName tracerName : this.fValidationClassNames.keySet()) {
            IClassName validationClassName = this.getValidatorName(tracerName);
            Class<?> validationClass = null;
            try {
                validationClass = Class.forName(validationClassName.getReflectionFriendlyQualifiedNameString());
            }
            catch (Throwable t) {
                throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Cannot_Load_Validation_Class", validationClassName.getReflectionFriendlyQualifiedNameString(), t.toString()));
            }
            if (!IMethodTracerValidator.class.isAssignableFrom(validationClass)) {
                throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Invalid_Validation_Class", validationClassName.getReflectionFriendlyQualifiedNameString()));
            }
            IMethodTracerValidator validator = null;
            try {
                validator = (IMethodTracerValidator)validationClass.newInstance();
            }
            catch (Throwable t) {
                throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Cannot_Instantiate_Validation_Class", validationClassName.getReflectionFriendlyQualifiedNameString(), t.toString()));
            }
            this.fValidationClasses.put(tracerName, validator);
        }
    }

    public void IValidatable_validate(int validationConstraintFlags) throws ValidationException {
        this.IValidatable_validate();
    }

    public void IValidatable_validate() throws ValidationException {
        if (!this.fDuplicates.isEmpty()) {
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Conflicting_Tracer_Mappings", this.buildMappingList(this.fDuplicates.keySet().iterator()), false));
        }
        if (!this.fValidationDuplicates.isEmpty()) {
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Conflicting_Tracer_Validation_Classes", this.buildMappingList(this.fValidationDuplicates.keySet().iterator()), false));
        }
        if (!this.fTracerOrderingDuplicates.isEmpty()) {
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Conflicting_Tracer_Orderings", this.buildMappingList(this.fTracerOrderingDuplicates.keySet().iterator()), false));
        }
        for (TracerName shorthand : this.fTracerOrderings.keySet()) {
            if (this.hasMapping(shorthand)) continue;
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Tracer_Ordering_Without_Mapping", shorthand.toString(), false));
        }
        if (!this.fTracerParameterDuplicates.isEmpty()) {
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Conflicting_Tracer_Parameters", this.buildMappingList(this.fTracerParameterDuplicates.keySet().iterator()), false));
        }
        for (TracerName shorthand : this.fTracerParameters.keySet()) {
            if (this.hasMapping(shorthand)) continue;
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Tracer_Parameter_Without_Mapping", shorthand.toString(), false));
        }
        this.loadValidators();
    }

    private String buildMappingList(Iterator listElements) {
        StringBuffer list = new StringBuffer();
        boolean firstElement = true;
        while (listElements.hasNext()) {
            if (!firstElement) {
                list.append(", ");
            }
            String element = listElements.next().toString();
            list.append(element);
            firstElement = false;
        }
        return list.toString();
    }

    int debug_getMappingCount() {
        return this.fMapping.size();
    }

    IClassName debug_getValidatorName(TracerName source) {
        return this.getValidatorName(source);
    }
}

