/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.bytecode;

import com.wily.diagnos.personality.java.classfile.bytecode.DGLocalVar;
import com.wily.diagnos.personality.java.classfile.bytecode.DGOpcodes;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DGByteCode
implements DGOpcodes {
    public static final int kTwoBitThreshold = 4;
    public static final int kOneByteUnsignedThreshold = 256;
    public static final int kTwoBytePositiveSignedThreshold = 32768;
    public static final int kTwoByteNegativeSignedThreshold = Short.MIN_VALUE;
    protected DataOutputStream fOut;
    private ByteArrayOutputStream fBuffer = new ByteArrayOutputStream(32);
    private ArrayList fLocalsAdded;

    public DGByteCode() {
        this.fOut = new DataOutputStream(this.fBuffer);
        this.fLocalsAdded = new ArrayList(0);
    }

    protected void addLocalVariable(int relativePC, int slot, String descriptor) {
        DGLocalVar var = new DGLocalVar(relativePC, slot, descriptor);
        this.fLocalsAdded.add(var);
    }

    public List getLocalVariables() {
        return this.fLocalsAdded;
    }

    public void write(DGByteCode byteCode) throws IOException {
        byteCode.fOut.flush();
        byteCode.fBuffer.writeTo(this.fOut);
    }

    public void write(int b) throws IOException {
        this.fOut.write(b);
    }

    public void writeShort(int s) throws IOException {
        this.fOut.writeShort(s);
    }

    public void writeInt(int i) throws IOException {
        this.fOut.writeInt(i);
    }

    public void writeLong(int l) throws IOException {
        this.fOut.writeLong(l);
    }

    public void writeString(String s) throws IOException {
        this.fOut.writeChars(s);
    }

    public int getsize_invokeinterface() {
        return 5;
    }

    public int getsize_load(int varIndex) {
        return this.getSizeLoadStoreCommon(varIndex, 4, 256);
    }

    public int getsize_store(int varIndex) {
        return this.getSizeLoadStoreCommon(varIndex, 4, 256);
    }

    public int getsize_aload(int varIndex) {
        return this.getSizeLoadStoreCommon(varIndex, 4, 256);
    }

    public int getsize_astore(int varIndex) {
        return this.getSizeLoadStoreCommon(varIndex, 4, 256);
    }

    public int getsize_jsr(int offset) {
        if (offset >= Short.MIN_VALUE && offset < 32768) {
            return 3;
        }
        return 5;
    }

    public int getsize_ifnull() {
        return 3;
    }

    public void write_nop() throws IOException {
        this.write(0);
    }

    public void write_ldc(int cpi) throws IOException {
        this.writeLdcCommon(18, 19, cpi);
    }

    public void write_ldc2(int cpi) throws IOException {
        this.write(20);
        this.writeShort(cpi);
    }

    public void write_load(int oneByteOp, int multiByteOp, int index) throws IOException {
        this.writeLoadStoreCommon(oneByteOp, multiByteOp, index, 4, 256);
    }

    public void write_store(int oneByteOp, int multiByteOp, int index) throws IOException {
        this.writeLoadStoreCommon(oneByteOp, multiByteOp, index, 4, 256);
    }

    public void write_aload(int index) throws IOException {
        this.writeLoadStoreCommon(42, 25, index, 4, 256);
    }

    public void write_astore(int index) throws IOException {
        this.writeLoadStoreCommon(75, 58, index, 4, 256);
    }

    public void write_iload(int index) throws IOException {
        this.writeLoadStoreCommon(26, 21, index, 4, 256);
    }

    public void write_istore(int index) throws IOException {
        this.writeLoadStoreCommon(59, 54, index, 4, 256);
    }

    public void write_lload(int index) throws IOException {
        this.writeLoadStoreCommon(30, 22, index, 4, 256);
    }

    public void write_lstore(int index) throws IOException {
        this.writeLoadStoreCommon(63, 55, index, 4, 256);
    }

    public void write_dload(int index) throws IOException {
        this.writeLoadStoreCommon(38, 24, index, 4, 256);
    }

    public void write_dstore(int index) throws IOException {
        this.writeLoadStoreCommon(71, 57, index, 4, 256);
    }

    public void write_fload(int index) throws IOException {
        this.writeLoadStoreCommon(34, 23, index, 4, 256);
    }

    public void write_fstore(int index) throws IOException {
        this.writeLoadStoreCommon(67, 56, index, 4, 256);
    }

    public void write_jsr(int offset) throws IOException {
        if (offset >= Short.MIN_VALUE && offset < 32768) {
            this.write(168);
            this.writeShort(offset);
        } else {
            this.write(201);
            this.writeInt(offset);
        }
    }

    public void write_jsr_w(int offset) throws IOException {
        this.write(201);
        this.writeInt(offset);
    }

    public void write_ifnull(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifnull branch");
        }
        this.write(198);
        this.writeShort(offset);
    }

    public void write_ifnonnull(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifnonnull branch");
        }
        this.write(199);
        this.writeShort(offset);
    }

    public void write_ifne(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifle branch");
        }
        this.write(154);
        this.writeShort(offset);
    }

    public void write_ifeq(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifle branch");
        }
        this.write(153);
        this.writeShort(offset);
    }

    public void write_ifle(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifle branch");
        }
        this.write(158);
        this.writeShort(offset);
    }

    public void write_ifgt(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifgt branch");
        }
        this.write(157);
        this.writeShort(offset);
    }

    public void write_if_icmpgt(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifcmpgt branch");
        }
        this.write(163);
        this.writeShort(offset);
    }

    public void write_if_icmple(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifcmple branch");
        }
        this.write(164);
        this.writeShort(offset);
    }

    public void write_if_icmpge(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifcmpge branch");
        }
        this.write(162);
        this.writeShort(offset);
    }

    public void write_if_icmplt(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for ifcmplt branch");
        }
        this.write(161);
        this.writeShort(offset);
    }

    public void write_if_acmpeq(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for if_acmpeq branch");
        }
        this.write(165);
        this.writeShort(offset);
    }

    public void write_if_acmpne(int offset) throws IOException {
        if (offset < Short.MIN_VALUE || offset >= 32768) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for if_acmpne branch");
        }
        this.write(166);
        this.writeShort(offset);
    }

    public void write_goto(int offset) throws IOException {
        if (offset >= Short.MIN_VALUE && offset < 32768) {
            this.write(167);
            this.writeShort(offset);
        } else {
            this.write(200);
            this.writeInt(offset);
        }
    }

    public void write_goto_w(int offset) throws IOException {
        this.write(200);
        this.writeInt(offset);
    }

    public void write_ret(int index) throws IOException {
        if (index < 256) {
            this.write(169);
            this.write(index);
        } else {
            this.write(196);
            this.write(169);
            this.writeShort(index);
        }
    }

    public void write_iconst(int constValue) throws IOException {
        if (constValue < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Values under -32768 are not supported");
        }
        if (constValue > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Values over 32767 are not supported");
        }
        if (constValue >= -1 && constValue <= 5) {
            this.write(3 + constValue);
        } else if (constValue >= -128 && constValue <= 127) {
            this.write(16);
            this.write(constValue);
        } else if (constValue >= Short.MIN_VALUE && constValue <= Short.MAX_VALUE) {
            this.write(17);
            this.writeShort(constValue);
        }
    }

    public void write_invokeinterface(int cpiMethod, int argCount) throws IOException {
        this.write(185);
        this.writeShort(cpiMethod);
        this.write(argCount);
        this.write(0);
    }

    public void write_invokedynamic(int cpiMethod) throws IOException {
        this.write(186);
        this.writeShort(cpiMethod);
        this.write(0);
        this.write(0);
    }

    public byte[] getByteCode() {
        return this.fBuffer.toByteArray();
    }

    public int getLength() {
        return this.fBuffer.size();
    }

    public int getAlignedLength() {
        int len = this.fBuffer.size();
        while (len % 4 != 0) {
            ++len;
        }
        return len;
    }

    public abstract int getMaxStackSlotsUsed();

    private int getSizeLoadStoreCommon(int arg, int threshold1, int threshold2) {
        if (arg < threshold1) {
            return 1;
        }
        if (arg < threshold2) {
            return 2;
        }
        return 4;
    }

    private void writeLoadStoreCommon(int oneByteOp, int multiByteOp, int arg, int threshold1, int threshold2) throws IOException {
        if (arg < threshold1) {
            this.write(oneByteOp + arg);
        } else if (arg < threshold2) {
            this.write(multiByteOp);
            this.write(arg);
        } else {
            this.write(196);
            this.write(multiByteOp);
            this.writeShort(arg);
        }
    }

    private void writeLdcCommon(int twoByteOp, int threeByteOp, int arg) throws IOException {
        if (arg < 256) {
            this.write(twoByteOp);
            this.write(arg);
        } else {
            this.write(threeByteOp);
            this.writeShort(arg);
        }
    }
}

