/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.ISharedElement;

public abstract class MetricGathererWrapper
implements ISharedElement {
    public static int kRead = 2;
    public static int kDirty = 1;
    public static int kStandBy = 0;
    private long startTimestamp = Long.MAX_VALUE;
    private volatile boolean fIsRead = false;
    private final boolean fShouldBeConsumedOnRead;

    protected MetricGathererWrapper(boolean shouldBeConsumedOnRead) {
        this.fShouldBeConsumedOnRead = shouldBeConsumedOnRead;
    }

    @Override
    public void merge(IGathererElement offered) {
        MetricGathererWrapper other = (MetricGathererWrapper)offered;
        if (!this.fShouldBeConsumedOnRead) {
            this.forceSpecificCombine(other);
        } else {
            this.specificCombine(other);
        }
        this.combineTime(other.startTimestamp);
    }

    @Override
    public final void combineTime(long wallClockStartTime) {
        if (wallClockStartTime < this.startTimestamp) {
            this.startTimestamp = wallClockStartTime;
        }
    }

    @Override
    public final void combineTime(long endTime, long startTime) {
        if (startTime < this.startTimestamp) {
            this.startTimestamp = startTime;
        }
    }

    public final void combineTime(MetricGathererWrapper offered) {
        if (offered.startTimestamp < this.startTimestamp) {
            this.startTimestamp = offered.startTimestamp;
        }
    }

    protected abstract void specificCombine(ISharedElement var1);

    protected abstract void forceSpecificCombine(ISharedElement var1);

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public long getEndTimestamp() {
        return 0L;
    }

    @Override
    public abstract long getValue();

    @Override
    public abstract long getMaximum();

    @Override
    public abstract long getMinimum();

    @Override
    public abstract long getCount();

    @Override
    public abstract void reset();

    @Override
    public abstract void combineValue(long var1);

    public ISharedElement getThreadSafeBookmark() {
        return this.getSharedElementInstance();
    }

    @Override
    public boolean shouldBeConsumendOnRead() {
        return this.fShouldBeConsumedOnRead;
    }

    protected abstract void increase();

    protected abstract void decrease();

    @Override
    public final void decrease(long startTime) {
        this.decrease();
        if (startTime < this.startTimestamp) {
            this.startTimestamp = startTime;
        }
    }

    @Override
    public final void increase(long startTime) {
        this.increase();
        if (startTime < this.startTimestamp) {
            this.startTimestamp = startTime;
        }
    }

    @Override
    public final void increase(long endTime, long startTime) {
        this.increase();
        if (startTime < this.startTimestamp) {
            this.startTimestamp = startTime;
        }
    }

    @Override
    public final void decrease(long endTime, long startTime) {
        this.decrease();
        if (startTime < this.startTimestamp) {
            this.startTimestamp = startTime;
        }
    }
}

