/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelBackendTracer;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public final class SocketBackendTracer
extends ChannelBackendTracer {
    public SocketBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected final String getComponentName(InvocationData data) {
        SocketChannel channel;
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof SocketChannel && SocketChannelMap.isRequired(channel = (SocketChannel)invocationObject, this.getAgent())) {
            return this.formatParameterizedName(data);
        }
        return null;
    }

    @Override
    protected final boolean isRequired(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof SocketChannel) {
            SocketChannel channel = (SocketChannel)invocationObject;
            if (SocketChannelMap.isRequired(channel, this.getAgent())) {
                return SocketChannelMap.isClientConnection(channel);
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: invocation object not a SocketChannel");
        }
        return false;
    }

    @Override
    protected String getAnnotationTitle(InvocationData data) {
        return "Socket " + data.getProbeInformation().getProbeIdentification().getProbeMethodName();
    }

    @Override
    protected InetSocketAddress getResourceAddress(InvocationData data) {
        Object channel = data.getInvocationObject();
        return SocketChannelMap.getAddress(channel);
    }
}

