/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postoffice;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.MailboxInUseException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public abstract class Mailbox {
    private static final boolean sDebugMode = false;
    private static final int kOpen = 1;
    private static final int kClosing = 2;
    private static final int kClosed = 3;
    private int fState = 1;
    private final PostOffice fPostOffice;
    private boolean fIsSystemService;
    private Exception fStackTraceOnCreation;
    private Address fAddress;
    private PostOfficeSpecifier fCloseOnDisconnect;
    private POTracker fPOTracker;

    public Mailbox(PostOffice po, int mailboxNumber) throws MailboxInUseException {
        this.fPostOffice = po;
        this.initialize(mailboxNumber);
        this.fPostOffice.registerNewMailbox(this, mailboxNumber);
    }

    public Mailbox(PostOffice po) {
        CheckParameter.notNull("Post Office", po);
        this.fPostOffice = po;
        int mailboxNum = this.fPostOffice.createNewMailbox(this);
        this.initialize(mailboxNum);
    }

    public Mailbox() {
        this.fPostOffice = null;
    }

    private void initialize(int mailboxNum) {
        this.fIsSystemService = false;
        this.fAddress = new Address(this.fPostOffice.getSpecifier(), mailboxNum);
    }

    public final void setInvocationHandler(Object invocationHandler) {
        this.fAddress.setInvocationHandler(invocationHandler);
    }

    public final Object getInvocationHandler() {
        return this.fAddress.getInvocationHandler();
    }

    public final Address getAddress() {
        return this.fAddress;
    }

    public final void dumpCreationStack() {
        if (this.fStackTraceOnCreation != null) {
            System.out.println("Mailbox Creation Stack Trace for: " + this);
            this.fStackTraceOnCreation.printStackTrace();
            System.out.println("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Mailbox mailbox = this;
        synchronized (mailbox) {
            if (this.fState != 1) {
                return;
            }
            this.fState = 2;
        }
        this.fPostOffice.closeMailbox(this);
        if (this.fPOTracker != null) {
            this.cancelPostOfficeNotification(this.fPOTracker);
        }
        this.fState = 3;
    }

    public void closeOnPODisconnect(PostOfficeSpecifier spec) {
        this.fCloseOnDisconnect = spec;
        this.fPOTracker = new POTracker();
        this.receivePostOfficeNotification(this.fPOTracker);
        if (!this.fPostOffice.isConnectedPO(spec)) {
            this.close();
        }
    }

    public final void setIsSystemService(boolean isSystemService) {
        this.fIsSystemService = isSystemService;
    }

    public final boolean getIsSystemService() {
        return this.fIsSystemService;
    }

    public final void receivePostOfficeNotification(IPostOfficeNotification handler) {
        this.fPostOffice.addPostOfficeNotification(handler);
    }

    public final void cancelPostOfficeNotification(IPostOfficeNotification handler) {
        this.fPostOffice.removePostOfficeNotification(handler);
    }

    public final int getMailboxNumber() {
        return this.fAddress.getMailboxNumber();
    }

    public final PostOffice getPostOffice() {
        return this.fPostOffice;
    }

    public final void sendMessage(AMessage message, Address destination) throws MessageUndeliverableException {
        if (this.fPostOffice.isClosed() || this.fState != 1 && !message.isDeliverIfClosed()) {
            throw new MessageUndeliverableException("Outgoing mailbox is closed. Message cannot be sent");
        }
        message.setSourceAddress(this.getAddress());
        this.fPostOffice.handleMessage(message, destination);
    }

    final void handleMessage(AMessage message) {
        if (this.fState != 3) {
            this.receiveMessage(message);
        }
    }

    protected abstract void receiveMessage(AMessage var1);

    protected IModuleFeedbackChannel getFeedbackChannel() {
        return this.fPostOffice.getPostOfficeHub().getFeedbackChannel();
    }

    public String toString() {
        return this.fPostOffice.getSpecifier() + ":" + this.getMailboxNumber();
    }

    private class POTracker
    implements IPostOfficeNotification {
        private POTracker() {
        }

        public void postOfficeAdded(PostOfficeSpecifier postOffice) {
        }

        public void postOfficeRemoved(PostOfficeSpecifier postOffice) {
            if (postOffice.equals(Mailbox.this.fCloseOnDisconnect)) {
                Mailbox.this.close();
            }
        }
    }
}

