/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io.filefilter;

import com.wily.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.util.List;

public class PrefixFileFilter
extends AbstractFileFilter {
    private String[] prefixes;

    public PrefixFileFilter(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix must not be null");
        }
        this.prefixes = new String[]{prefix};
    }

    public PrefixFileFilter(String[] prefixes) {
        if (prefixes == null) {
            throw new IllegalArgumentException("The array of prefixes must not be null");
        }
        this.prefixes = prefixes;
    }

    public PrefixFileFilter(List prefixes) {
        if (prefixes == null) {
            throw new IllegalArgumentException("The list of prefixes must not be null");
        }
        this.prefixes = prefixes.toArray(new String[prefixes.size()]);
    }

    public boolean accept(File file) {
        String name = file.getName();
        int i = 0;
        while (i < this.prefixes.length) {
            if (name.startsWith(this.prefixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(File file, String name) {
        int i = 0;
        while (i < this.prefixes.length) {
            if (name.startsWith(this.prefixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

