/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;

public abstract class SafeFeedbackWrapper
implements IModuleFeedbackChannel {
    private final int kMaxReportedErrors;
    private final IGuaranteedCounter fCounter;
    private final IModuleFeedbackChannel fDelegate;

    public SafeFeedbackWrapper(IModuleFeedbackChannel delegate, IGuaranteedCounter agent, int maxErrors) {
        this.fDelegate = delegate;
        this.fCounter = agent;
        this.kMaxReportedErrors = maxErrors;
    }

    public boolean isVerboseEnabled() {
        return this.fDelegate.isVerboseEnabled();
    }

    public boolean isDebugEnabled() {
        return this.fDelegate.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.fDelegate.isTraceEnabled();
    }

    public boolean isErrorEnabled(Module module) {
        return this.fDelegate.isErrorEnabled(module);
    }

    public boolean isWarningEnabled(Module module) {
        return this.fDelegate.isWarningEnabled(module);
    }

    public boolean isInfoEnabled(Module module) {
        return this.fDelegate.isInfoEnabled(module);
    }

    public boolean isVerboseEnabled(Module module) {
        return this.fDelegate.isVerboseEnabled(module);
    }

    public boolean isDebugEnabled(Module module) {
        return this.fDelegate.isDebugEnabled(module);
    }

    public boolean isTraceEnabled(Module module) {
        return this.fDelegate.isTraceEnabled(module);
    }

    public boolean isLogEnabled(SeverityLevel severity, Module module) {
        return this.fDelegate.isLogEnabled(severity, module);
    }

    public void error(String message) {
        if (this.checkMax()) {
            this.fDelegate.error(message);
        }
    }

    public void error(String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.error(message, t);
        }
    }

    public void warn(String message) {
        if (this.checkMax()) {
            this.fDelegate.warn(message);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.warn(message, t);
        }
    }

    public void info(String message) {
        if (this.checkMax()) {
            this.fDelegate.info(message);
        }
    }

    public void info(String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.info(message, t);
        }
    }

    public void verbose(String message) {
        if (this.checkMax()) {
            this.fDelegate.verbose(message);
        }
    }

    public void verbose(String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.verbose(message, t);
        }
    }

    public void debug(String message) {
        if (this.checkMax()) {
            this.fDelegate.debug(message);
        }
    }

    public void trace(String message) {
        if (this.checkMax()) {
            this.fDelegate.trace(message);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.debug(message, t);
        }
    }

    public void log(SeverityLevel severity, String message) {
        if (this.checkMax()) {
            this.fDelegate.log(severity, message);
        }
    }

    public void log(SeverityLevel severity, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.log(severity, message, t);
        }
    }

    public void error(Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.error(t);
        }
    }

    public void verbose(Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.verbose(t);
        }
    }

    public void debug(Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.debug(t);
        }
    }

    public void error(Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.error(module, message);
        }
    }

    public void error(Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.error(module, message, t);
        }
    }

    public void warn(Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.warn(module, message);
        }
    }

    public void warn(Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.warn(module, message, t);
        }
    }

    public void info(Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.info(module, message);
        }
    }

    public void info(Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.info(module, message, t);
        }
    }

    public void verbose(Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.verbose(module, message);
        }
    }

    public void verbose(Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.verbose(module, message, t);
        }
    }

    public void debug(Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.debug(module, message);
        }
    }

    public void debug(Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.debug(module, message, t);
        }
    }

    public void trace(Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.trace(module, message);
        }
    }

    public void trace(Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.trace(module, message, t);
        }
    }

    public void log(SeverityLevel severity, Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.log(severity, module, message);
        }
    }

    public void log(SeverityLevel severity, Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.log(severity, module, message, t);
        }
    }

    public void logImmediate(SeverityLevel severity, Module module, String message) {
        if (this.checkMax()) {
            this.fDelegate.logImmediate(severity, module, message);
        }
    }

    public void logImmediate(SeverityLevel severity, Module module, String message, Throwable t) {
        if (this.checkMax()) {
            this.fDelegate.logImmediate(severity, module, message, t);
        }
    }

    public void setLevel(SeverityLevel level, Module module) {
        this.fDelegate.setLevel(level, module);
    }

    public SeverityLevel getLevel(Module module) {
        return this.fDelegate.getLevel(module);
    }

    public SeverityLevel getEffectiveLevel(Module module) {
        return this.fDelegate.getEffectiveLevel(module);
    }

    public String getApplicationName() {
        return this.fDelegate.getApplicationName();
    }

    public String getModuleName() {
        return this.fDelegate.getModuleName();
    }

    public void signalSuccessCondition(Module module, String message) {
        if (this.fCounter.peek() >= this.kMaxReportedErrors) {
            this.fDelegate.info(module, "A success condition occurred, log can resume: " + message);
            this.fCounter.reset();
        }
    }

    private boolean checkMax() {
        int counter = this.fCounter.next();
        if (counter > this.kMaxReportedErrors) {
            return false;
        }
        if (counter == this.kMaxReportedErrors) {
            this.fDelegate.error("Reached the limit of " + this.kMaxReportedErrors + " for reporting." + " Additional log will not be logged until " + "a success condition will not occur");
            this.doOnMaxError(this.kMaxReportedErrors);
            return false;
        }
        return true;
    }

    public abstract void doOnMaxError(int var1);
}

