/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db.directives;

import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.IExportDirectiveCallback;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.db.directives.DatabaseDirectiveCollection;
import com.wily.introscope.agent.db.directives.IDatabaseDirective;
import com.wily.introscope.agent.transformer.dynamic.IDynamicDirectivesService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicDirectivesServiceCallback;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicDirectivesResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IDynamicInstrumentationListener;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.IMethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.ALocalizableException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DatabaseDynamicDirectivesService
implements IDynamicDirectivesService,
IExportDirectiveCallback {
    private DynamicDirectivesResult addDynamicDirectiveCollection(IDynamicInstrumentationService instService, IClassSchemaPolicy policy, Collection targetDirectiveCollection, IModuleFeedbackChannel feedback) {
        DynamicDirectivesResult collectionResult = instService.getDynamicDirectiveCollection();
        if (!collectionResult.isError()) {
            DatabaseDirectiveCollection databaseWrapper = new DatabaseDirectiveCollection(policy, feedback, collectionResult.getDynamicDirectiveCollection());
            targetDirectiveCollection.add(databaseWrapper);
        }
        return collectionResult;
    }

    private DynamicDirectivesResult addDynamicInstrumentationDirective(int id, IDynamicInstrumentationService instService, IClassSchemaPolicy policy, Collection targetDirectiveCollection, IModuleFeedbackChannel feedback) {
        DynamicDirectivesResult collectionResult = instService.getDynamicDirectiveById(id);
        if (!collectionResult.isError()) {
            DatabaseDirectiveCollection databaseWrapper = new DatabaseDirectiveCollection(policy, feedback, collectionResult.getDynamicDirectiveCollection());
            targetDirectiveCollection.add(databaseWrapper);
            ArrayList<String> list = new ArrayList<String>();
            Iterator i = databaseWrapper.getDirectives();
            while (i.hasNext()) {
                IDatabaseDirective d = (IDatabaseDirective)i.next();
                list.add(d.getText());
            }
            collectionResult.setCheckdDynamicDirectiveCollection(list);
        }
        return collectionResult;
    }

    public void getDynamicInstrumentationPBD(IDynamicInstrumentationListener listener, String label, boolean permanentOnly, IDynamicInstrumentationService instService, IClassSchemaPolicy policy, IModuleFeedbackChannel feedback) {
        DynamicDirectivesResult collectionResult = instService.getDynamicDirectiveCollectionByLabel(label);
        if (!collectionResult.isError()) {
            DatabaseDirectiveCollection databaseWrapper = new DatabaseDirectiveCollection(policy, permanentOnly, feedback, collectionResult.getDynamicDirectiveCollection());
            collectionResult.setDynamicDirectiveCollection(null);
            Map text = databaseWrapper.getTextLines();
            if (text.isEmpty()) {
                collectionResult.setEmpty();
                collectionResult.setLastResult(Boolean.valueOf(true));
                listener.deliverResult((DynamicInstrumentationResult)collectionResult);
            } else {
                Iterator i = text.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String labelResult = (String)entry.getKey();
                    List lines = (List)entry.getValue();
                    Iterator j = lines.iterator();
                    while (j.hasNext()) {
                        DynamicDirectivesResult collectionToSend = new DynamicDirectivesResult(collectionResult);
                        String pbdLine = (String)j.next();
                        collectionToSend.setLabel(labelResult);
                        collectionToSend.setPbdLine(pbdLine);
                        boolean hasMoreResults = i.hasNext() || !i.hasNext() && j.hasNext();
                        collectionToSend.setLastResult(new Boolean(!hasMoreResults));
                        listener.deliverResult((DynamicInstrumentationResult)collectionToSend);
                    }
                }
            }
        }
    }

    public DynamicDirectivesResult addDynamicDirectiveCollection(IDynamicInstrumentationService dynamicInstrumentationService, IClassSchemaPolicy policy, IDynamicDirectivesServiceCallback collectionCallback, IModuleFeedbackChannel feedback) throws ALocalizableException, IOException {
        return this.addDynamicDirectiveCollection(dynamicInstrumentationService, policy, collectionCallback.getCollection(), feedback);
    }

    public DynamicDirectivesResult addDynamicInstrumentationDirective(int id, IDynamicInstrumentationService dynamicInstrumentationService, IClassSchemaPolicy policy, IDynamicDirectivesServiceCallback collectionCallback, IModuleFeedbackChannel feedback) {
        return this.addDynamicInstrumentationDirective(id, dynamicInstrumentationService, policy, collectionCallback.getCollection(), feedback);
    }

    public void export(String source, FlagName flagName, IClassName className, IMethodName methodName, TracerName tracerName, String nameParameter, String label, boolean isActive, IClassName callingClassName, IMethodName callingMethodName) {
        try {
            IDynamicInstrumentationTransformer transformer = this.getDynamicInstrumentationTransformer();
            if (tracerName != null) {
                transformer.getDynamicInstrumentationService().createPermanentDirective(className, methodName, label, nameParameter, tracerName.getName(), flagName.getName(), callingClassName, callingMethodName);
            } else {
                transformer.getDynamicInstrumentationService().createPermanentGroupDirective(flagName.getName(), isActive);
            }
        }
        catch (AgentNotAvailableException e) {
            e.printStackTrace();
        }
    }

    private IDynamicInstrumentationTransformer getDynamicInstrumentationTransformer() throws AgentNotAvailableException {
        return AgentShim.getAgent().IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
    }
}

