/*
 * Decompiled with CFR 0.152.
 */
package com.wily.zos.common;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.zos.common.Tools;
import com.wily.zos.common.Tracer;

public final class InvocationContext {
    private String className;
    private String methodName;
    private String methodSignature;
    private String objectId;
    private String pbdMetricName;
    private String simpleClassName;

    public InvocationContext(Tracer tracer, InvocationData data) {
        ProbeIdentification probeIdentification = data.getProbeInformation().getProbeIdentification();
        Object invocationObject = data.getInvocationObject();
        if (invocationObject != null) {
            this.className = invocationObject.getClass().getName();
            this.objectId = Tools.lastPieceOf(invocationObject.toString(), "@");
            this.simpleClassName = Tools.lastPieceOf(this.className, "\\.");
        }
        if (tracer != null) {
            this.pbdMetricName = tracer.pbdMetricNameFor(data);
        }
        this.methodName = probeIdentification.getProbeMethodName();
        this.methodSignature = probeIdentification.getProbeMethodDescriptor();
    }

    protected String getClassName() {
        return this.className;
    }

    protected String getMethodName() {
        return this.methodName;
    }

    protected String getMethodSignature() {
        return this.methodSignature;
    }

    protected String getObjectId() {
        return this.objectId;
    }

    protected String getPbdMetricName() {
        return this.pbdMetricName;
    }

    protected String getSimpleClassName() {
        return this.simpleClassName;
    }
}

